/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.awt.geom.Point2D;
import java.util.Locale;
import org.geotools.cs.Projection;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.proj.ConicProjection;
import org.geotools.ct.proj.ProjectionException;
import org.geotools.pt.Latitude;
import org.geotools.resources.cts.Resources;

public class AlbersEqualArea
extends ConicProjection {
    private static final double EPS = 1.0E-7;
    private static final int MAX_ITER = 15;
    private final double n;
    private final double c;
    private final double rho0;
    private final double ec;
    private final double phi1;
    private final double phi2;

    protected AlbersEqualArea(Projection parameters) throws MissingParameterException {
        super(parameters);
        boolean secant;
        this.phi1 = AlbersEqualArea.latitudeToRadians(parameters.getValue("standard_parallel_1", 50.0), true);
        this.phi2 = AlbersEqualArea.latitudeToRadians(parameters.getValue("standard_parallel_2", 58.5), true);
        if (Math.abs(this.phi1 + this.phi2) < 1.0E-10) {
            throw new IllegalArgumentException(Resources.format(44, new Latitude(Math.toDegrees(this.phi1)), new Latitude(Math.toDegrees(this.phi2))));
        }
        double sinphi = Math.sin(this.phi1);
        double cosphi = Math.cos(this.phi1);
        double n = sinphi;
        boolean bl = secant = Math.abs(this.phi1 - this.phi2) >= 1.0E-10;
        if (this.isSpherical) {
            if (secant) {
                n = 0.5 * (n + Math.sin(this.phi2));
            }
            this.c = cosphi * cosphi + n * 2.0 * sinphi;
            this.rho0 = Math.sqrt(this.c - n * 2.0 * Math.sin(this.latitudeOfOrigin)) / n;
            this.ec = Double.NaN;
        } else {
            double m1 = this.msfn(sinphi, cosphi);
            double q1 = this.qsfn(sinphi);
            if (secant) {
                sinphi = Math.sin(this.phi2);
                cosphi = Math.cos(this.phi2);
                double m2 = this.msfn(sinphi, cosphi);
                double q2 = this.qsfn(sinphi);
                n = (m1 * m1 - m2 * m2) / (q2 - q1);
            }
            this.c = m1 * m1 + n * q1;
            this.rho0 = Math.sqrt(this.c - n * this.qsfn(Math.sin(this.latitudeOfOrigin))) / n;
            this.ec = 1.0 - 0.5 * (1.0 - this.es) * Math.log((1.0 - this.e) / (1.0 + this.e)) / this.e;
        }
        this.n = n;
    }

    public String getName(Locale locale) {
        return Resources.getResources(locale).getString(93);
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        x *= this.n;
        double rho = this.isSpherical ? this.c - this.n * 2.0 * Math.sin(y) : this.c - this.n * this.qsfn(Math.sin(y));
        if (rho < 0.0) {
            throw new ProjectionException("Tolerance condition error");
        }
        rho = Math.sqrt(rho) / this.n;
        y = this.rho0 - rho * Math.cos(x);
        x = rho * Math.sin(x);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double rho = Math.sqrt(x * x + (y = this.rho0 - y) * y);
        if (rho != 0.0) {
            if (this.n < 0.0) {
                rho = -rho;
                x = -x;
                y = -y;
            }
            x = Math.atan2(x, y) / this.n;
            y = rho * this.n;
            y = this.isSpherical ? (Math.abs(y = (this.c - y * y) / (this.n * 2.0)) <= 1.0 ? Math.asin(y) : (y < 0.0 ? -1.5707963267948966 : 1.5707963267948966)) : (Math.abs(this.ec - Math.abs(y = (this.c - y * y) / this.n)) > 1.0E-7 ? this.phi1(y) : (y < 0.0 ? -1.5707963267948966 : 1.5707963267948966));
        } else {
            x = 0.0;
            double d = y = this.n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    private double phi1(double qs) throws ProjectionException {
        double tone_es = 1.0 - this.es;
        double phi = Math.asin(0.5 * qs);
        if (this.e < 1.0E-7) {
            return phi;
        }
        for (int i = 0; i < 15; ++i) {
            double sinpi = Math.sin(phi);
            double cospi = Math.cos(phi);
            double con = this.e * sinpi;
            double com = 1.0 - con * con;
            double dphi = 0.5 * com * com / cospi * (qs / tone_es - sinpi / com + 0.5 / this.e * Math.log((1.0 - con) / (1.0 + con)));
            phi += dphi;
            if (!(Math.abs(dphi) <= 1.0E-10)) continue;
            return phi;
        }
        throw new ProjectionException(Resources.format(69));
    }

    private double qsfn(double sinphi) {
        double one_es = 1.0 - this.es;
        if (this.e >= 1.0E-7) {
            double con = this.e * sinphi;
            return one_es * (sinphi / (1.0 - con * con) - 0.5 / this.e * Math.log((1.0 - con) / (1.0 + con)));
        }
        return sinphi + sinphi;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.c);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            AlbersEqualArea that = (AlbersEqualArea)object;
            return AlbersEqualArea.equals(this.n, that.n) && AlbersEqualArea.equals(this.c, that.c) && AlbersEqualArea.equals(this.rho0, that.rho0) && AlbersEqualArea.equals(this.phi1, that.phi1) && AlbersEqualArea.equals(this.phi2, that.phi2);
        }
        return false;
    }

    void toString(StringBuffer buffer) {
        super.toString(buffer);
        AlbersEqualArea.addParameter(buffer, "standard_parallel_1", Math.toDegrees(this.phi1));
        AlbersEqualArea.addParameter(buffer, "standard_parallel_2", Math.toDegrees(this.phi2));
    }

    static final class Provider
    extends org.geotools.ct.proj.Provider {
        public Provider() {
            super("Albers_Conic_Equal_Area", 93);
            this.remove("scale_factor");
            this.put("standard_parallel_1", 50.0, LATITUDE_RANGE);
            this.put("standard_parallel_2", 58.5, LATITUDE_RANGE);
        }

        public MathTransform create(Projection parameters) throws MissingParameterException {
            return new AlbersEqualArea(parameters);
        }
    }
}

