/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashSet;
import java.util.Locale;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.util.CaselessStringKey;
import org.geotools.cs.FactoryException;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransformFactory;
import org.geotools.ct.NoninvertibleTransformException;
import org.geotools.resources.WKTElement;
import org.geotools.resources.WKTFormat;
import org.geotools.resources.cts.Resources;

final class WKTParser
extends WKTFormat {
    private MathTransformFactory factory;
    static /* synthetic */ Class class$java$lang$Integer;

    public WKTParser(Locale locale, MathTransformFactory factory) {
        super(locale);
        this.factory = factory;
    }

    private MathTransform parseParamMT(WKTElement parent) throws ParseException {
        WKTElement param;
        ParameterList parameters;
        WKTElement element = parent.pullElement("PARAM_MT");
        String classification = element.pullString("classification");
        try {
            parameters = this.factory.getMathTransformProvider(classification).getParameterList();
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
        HashSet<CaselessStringKey> integers = new HashSet<CaselessStringKey>();
        ParameterListDescriptor descriptor = parameters.getParameterListDescriptor();
        Class[] classes = descriptor.getParamClasses();
        if (classes != null) {
            String[] names = null;
            for (int i = 0; i < classes.length; ++i) {
                if (!(class$java$lang$Integer == null ? WKTParser.class$("java.lang.Integer") : class$java$lang$Integer).equals(classes[i])) continue;
                if (names == null) {
                    names = descriptor.getParamNames();
                }
                integers.add(new CaselessStringKey(names[i]));
            }
        }
        while ((param = element.pullOptionalElement("PARAMETER")) != null) {
            String name = param.pullString("name");
            parameters = integers.contains(new CaselessStringKey(name)) ? parameters.setParameter(name, param.pullInteger("value")) : parameters.setParameter(name, param.pullDouble("value"));
            param.close();
        }
        element.close();
        try {
            return this.factory.createParameterizedTransform(classification, parameters);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private MathTransform parseInverseMT(WKTElement parent) throws ParseException {
        WKTElement element = parent.pullElement("INVERSE_MT");
        try {
            MathTransform transform = this.parseMathTransform(element, true).inverse();
            element.close();
            return transform;
        }
        catch (NoninvertibleTransformException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private MathTransform parsePassThroughMT(WKTElement parent) throws ParseException {
        WKTElement element = parent.pullElement("PASSTHROUGH_MT");
        int firstAffectedOrdinate = parent.pullInteger("firstAffectedOrdinate");
        MathTransform transform = this.parseMathTransform(element, true);
        element.close();
        return this.factory.createPassThroughTransform(firstAffectedOrdinate, transform, 0);
    }

    private MathTransform parseConcatMT(WKTElement parent) throws ParseException {
        MathTransform optionalTransform;
        WKTElement element = parent.pullElement("CONCAT_MT");
        MathTransform transform = this.parseMathTransform(element, true);
        while ((optionalTransform = this.parseMathTransform(element, false)) != null) {
            transform = this.factory.createConcatenatedTransform(transform, optionalTransform);
        }
        element.close();
        return transform;
    }

    private MathTransform parseMathTransform(WKTElement element, boolean required) throws ParseException {
        Object key = element.peek();
        if (key instanceof WKTElement) {
            String keyword = ((WKTElement)key).keyword.trim().toUpperCase(this.locale);
            if ("PARAM_MT".equals(keyword)) {
                return this.parseParamMT(element);
            }
            if ("CONCAT_MT".equals(keyword)) {
                return this.parseConcatMT(element);
            }
            if ("INVERSE_MT".equals(keyword)) {
                return this.parseInverseMT(element);
            }
            if ("PASSTHROUGH_MT".equals(keyword)) {
                return this.parsePassThroughMT(element);
            }
        }
        if (required) {
            throw element.parseFailed(null, Resources.format(77, key));
        }
        return null;
    }

    public MathTransform parseMathTransform(String text) throws ParseException {
        WKTElement element = this.getTree(text, new ParsePosition(0));
        MathTransform mt = this.parseMathTransform(element, true);
        element.close();
        return mt;
    }

    protected Object parse(WKTElement element) throws ParseException {
        return this.parseMathTransform(element, true);
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(obj);
    }
}

