/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.io.ObjectStreamException;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.media.jai.EnumeratedParameter;
import org.geotools.resources.cts.Resources;

public final class TransformType
extends EnumeratedParameter {
    private static final long serialVersionUID = -4186653001664797298L;
    public static final TransformType OTHER = new TransformType("OTHER", 0, 29);
    public static final TransformType CONVERSION = new TransformType("CONVERSION", 1, 6);
    public static final TransformType TRANSFORMATION = new TransformType("TRANSFORMATION", 2, 36);
    public static final TransformType CONVERSION_AND_TRANSFORMATION = new TransformType("CONVERSION_AND_TRANSFORMATION", 3, 7);
    private static final TransformType[] ENUMS = new TransformType[]{OTHER, CONVERSION, TRANSFORMATION, CONVERSION_AND_TRANSFORMATION};
    private final transient int key;

    private TransformType(String name, int value, int key) {
        super(name, value);
        this.key = key;
    }

    public static TransformType getEnum(int value) throws NoSuchElementException {
        if (value >= 1 && value < ENUMS.length) {
            return ENUMS[value];
        }
        throw new NoSuchElementException(String.valueOf(value));
    }

    public String getName(Locale locale) {
        return Resources.getResources(locale).getString(this.key);
    }

    public TransformType concatenate(TransformType type) {
        int thisValue = this.getValue();
        int thatValue = type.getValue();
        if (thisValue == 0 || thatValue == 0) {
            return OTHER;
        }
        return TransformType.getEnum(thisValue | thatValue);
    }

    private Object readResolve() throws ObjectStreamException {
        int value = this.getValue();
        if (value >= 0 && value < ENUMS.length) {
            return ENUMS[value];
        }
        return ENUMS[0];
    }

    static {
        for (int i = 0; i < ENUMS.length; ++i) {
            if (ENUMS[i].getValue() != i) {
                throw new AssertionError((Object)ENUMS[i]);
            }
        }
    }
}

