/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.io.Serializable;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.MathTransform;
import org.geotools.ct.NoninvertibleTransformException;
import org.geotools.ct.TransformException;
import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Matrix;
import org.geotools.pt.MismatchedDimensionException;
import org.geotools.resources.Utilities;

final class PassThroughTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -1673997634240223449L;
    protected final int firstAffectedOrdinate;
    protected final int numTrailingOrdinates;
    protected final MathTransform transform;
    private transient PassThroughTransform inverse;

    public PassThroughTransform(int firstAffectedOrdinate, MathTransform transform, int numTrailingOrdinates) {
        if (transform instanceof PassThroughTransform) {
            PassThroughTransform passThrough = (PassThroughTransform)transform;
            this.firstAffectedOrdinate = passThrough.firstAffectedOrdinate + firstAffectedOrdinate;
            this.numTrailingOrdinates = passThrough.numTrailingOrdinates + numTrailingOrdinates;
            this.transform = passThrough.transform;
        } else {
            this.firstAffectedOrdinate = firstAffectedOrdinate;
            this.numTrailingOrdinates = numTrailingOrdinates;
            this.transform = transform;
        }
    }

    public int getDimSource() {
        return this.firstAffectedOrdinate + this.transform.getDimSource() + this.numTrailingOrdinates;
    }

    public int getDimTarget() {
        return this.firstAffectedOrdinate + this.transform.getDimTarget() + this.numTrailingOrdinates;
    }

    public boolean isIdentity() {
        return this.transform.isIdentity();
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int subDimSource = this.transform.getDimSource();
        int subDimTarget = this.transform.getDimTarget();
        int srcStep = this.numTrailingOrdinates;
        int dstStep = this.numTrailingOrdinates;
        if (srcPts == dstPts && srcOff < dstOff) {
            int dimSource = this.getDimSource();
            int dimTarget = this.getDimTarget();
            srcOff += numPts * dimSource;
            dstOff += numPts * dimTarget;
            srcStep -= 2 * dimSource;
            dstStep -= 2 * dimTarget;
        }
        while (--numPts >= 0) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, this.firstAffectedOrdinate);
            this.transform.transform(srcPts, srcOff += this.firstAffectedOrdinate, dstPts, dstOff += this.firstAffectedOrdinate, 1);
            System.arraycopy(srcPts, srcOff += subDimSource, dstPts, dstOff += subDimTarget, this.numTrailingOrdinates);
            srcOff += srcStep;
            dstOff += dstStep;
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int subDimSource = this.transform.getDimSource();
        int subDimTarget = this.transform.getDimTarget();
        int srcStep = this.numTrailingOrdinates;
        int dstStep = this.numTrailingOrdinates;
        if (srcPts == dstPts && srcOff < dstOff) {
            int dimSource = this.getDimSource();
            int dimTarget = this.getDimTarget();
            srcOff += numPts * dimSource;
            dstOff += numPts * dimTarget;
            srcStep -= 2 * dimSource;
            dstStep -= 2 * dimTarget;
        }
        while (--numPts >= 0) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, this.firstAffectedOrdinate);
            this.transform.transform(srcPts, srcOff += this.firstAffectedOrdinate, dstPts, dstOff += this.firstAffectedOrdinate, 1);
            System.arraycopy(srcPts, srcOff += subDimSource, dstPts, dstOff += subDimTarget, this.numTrailingOrdinates);
            srcOff += srcStep;
            dstOff += dstStep;
        }
    }

    public Matrix derivative(CoordinatePoint point) throws TransformException {
        int nSkipped = this.firstAffectedOrdinate + this.numTrailingOrdinates;
        int transDim = this.transform.getDimSource();
        int pointDim = point.getDimension();
        if (pointDim != transDim + nSkipped) {
            throw new MismatchedDimensionException(pointDim, transDim + nSkipped);
        }
        CoordinatePoint subPoint = new CoordinatePoint(transDim);
        System.arraycopy(point.ord, this.firstAffectedOrdinate, subPoint.ord, 0, transDim);
        return PassThroughTransform.expand(this.transform.derivative(subPoint), this.firstAffectedOrdinate, this.numTrailingOrdinates, 0);
    }

    static Matrix expand(Matrix subMatrix, int firstAffectedOrdinate, int numTrailingOrdinates, int affine) {
        int nSkipped = firstAffectedOrdinate + numTrailingOrdinates;
        int numRow = subMatrix.getNumRow() - affine;
        int numCol = subMatrix.getNumCol() - affine;
        Matrix matrix = new Matrix(numRow + nSkipped + affine, numCol + nSkipped + affine);
        matrix.setZero();
        for (int j = 0; j < firstAffectedOrdinate; ++j) {
            matrix.setElement(j, j, 1.0);
        }
        subMatrix.copySubMatrix(0, 0, numRow, numCol, firstAffectedOrdinate, firstAffectedOrdinate, matrix);
        int offset = numCol - numRow;
        int numRowOut = numRow + nSkipped;
        for (int j = numRowOut - numTrailingOrdinates; j < numRowOut; ++j) {
            matrix.setElement(j, j + offset, 1.0);
        }
        if (affine != 0) {
            subMatrix.copySubMatrix(0, numCol, numRow, affine, firstAffectedOrdinate, numCol + nSkipped, matrix);
            subMatrix.copySubMatrix(numRow, 0, affine, numCol, numRow + nSkipped, firstAffectedOrdinate, matrix);
            subMatrix.copySubMatrix(numRow, numCol, affine, affine, numRow + nSkipped, numCol + nSkipped, matrix);
        }
        return matrix;
    }

    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = new PassThroughTransform(this.firstAffectedOrdinate, this.transform.inverse(), this.numTrailingOrdinates);
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            PassThroughTransform that = (PassThroughTransform)object;
            return this.firstAffectedOrdinate == that.firstAffectedOrdinate && this.numTrailingOrdinates == that.numTrailingOrdinates && Utilities.equals((Object)this.transform, (Object)that.transform);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("PASSTHROUGH_MT[");
        buffer.append(this.firstAffectedOrdinate);
        buffer.append(',');
        if (this.numTrailingOrdinates != 0) {
            buffer.append(this.numTrailingOrdinates);
            buffer.append(',');
        }
        buffer.append(this.transform);
        buffer.append(']');
        return buffer.toString();
    }
}

