/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import javax.media.jai.ParameterList;
import javax.vecmath.GMatrix;
import javax.vecmath.SingularMatrixException;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.AffineTransform2D;
import org.geotools.ct.IdentityTransform;
import org.geotools.ct.LinearTransform;
import org.geotools.ct.LinearTransform1D;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransformProvider;
import org.geotools.ct.MatrixParameters;
import org.geotools.ct.NoninvertibleTransformException;
import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Matrix;
import org.geotools.resources.cts.Resources;

final class MatrixTransform
extends AbstractMathTransform
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -2104496465933824935L;
    private final int numRow;
    private final int numCol;
    private final double[] elt;

    protected MatrixTransform(GMatrix matrix) {
        this.numRow = matrix.getNumRow();
        this.numCol = matrix.getNumCol();
        this.elt = new double[this.numRow * this.numCol];
        int index = 0;
        for (int j = 0; j < this.numRow; ++j) {
            for (int i = 0; i < this.numCol; ++i) {
                this.elt[index++] = matrix.getElement(j, i);
            }
        }
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int upperSrc;
        int inputDimension = this.numCol - 1;
        int outputDimension = this.numRow - 1;
        double[] buffer = new double[this.numRow];
        if (srcPts == dstPts && (upperSrc = srcOff + numPts * inputDimension) > dstOff && (inputDimension >= outputDimension ? dstOff > srcOff : dstOff + numPts * outputDimension > upperSrc)) {
            srcPts = new float[numPts * inputDimension];
            System.arraycopy(dstPts, srcOff, srcPts, 0, srcPts.length);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + inputDimension];
                for (int i = 0; i < inputDimension; ++i) {
                    sum += (double)srcPts[srcOff + i] * this.elt[mix++];
                }
                buffer[j] = sum;
                ++mix;
            }
            double w = buffer[outputDimension];
            for (int j = 0; j < outputDimension; ++j) {
                dstPts[dstOff++] = (float)(buffer[j] / w);
            }
            srcOff += inputDimension;
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int upperSrc;
        int inputDimension = this.numCol - 1;
        int outputDimension = this.numRow - 1;
        double[] buffer = new double[this.numRow];
        if (srcPts == dstPts && (upperSrc = srcOff + numPts * inputDimension) > dstOff && (inputDimension >= outputDimension ? dstOff > srcOff : dstOff + numPts * outputDimension > upperSrc)) {
            srcPts = new double[numPts * inputDimension];
            System.arraycopy(dstPts, srcOff, srcPts, 0, srcPts.length);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + inputDimension];
                for (int i = 0; i < inputDimension; ++i) {
                    sum += srcPts[srcOff + i] * this.elt[mix++];
                }
                buffer[j] = sum;
                ++mix;
            }
            double w = buffer[outputDimension];
            for (int j = 0; j < outputDimension; ++j) {
                dstPts[dstOff++] = buffer[j] / w;
            }
            srcOff += inputDimension;
        }
    }

    public Matrix derivative(Point2D point) {
        return this.derivative((CoordinatePoint)null);
    }

    public Matrix derivative(CoordinatePoint point) {
        Matrix matrix = this.getMatrix();
        matrix.setSize(this.numRow - 1, this.numCol - 1);
        return matrix;
    }

    public Matrix getMatrix() {
        return new Matrix(this.numRow, this.numCol, this.elt);
    }

    public int getDimSource() {
        return this.numCol - 1;
    }

    public int getDimTarget() {
        return this.numRow - 1;
    }

    public boolean isIdentity() {
        if (this.numRow != this.numCol) {
            return false;
        }
        int index = 0;
        for (int j = 0; j < this.numRow; ++j) {
            for (int i = 0; i < this.numCol; ++i) {
                if (this.elt[index++] == (double)(i == j ? 1 : 0)) continue;
                return false;
            }
        }
        return true;
    }

    public MathTransform inverse() throws NoninvertibleTransformException {
        if (this.isIdentity()) {
            return this;
        }
        Matrix matrix = this.getMatrix();
        try {
            matrix.invert();
        }
        catch (SingularMatrixException exception) {
            NoninvertibleTransformException e = new NoninvertibleTransformException(Resources.format(62));
            e.initCause(exception);
            throw e;
        }
        return new MatrixTransform(matrix);
    }

    public int hashCode() {
        long code = 2563217L;
        int i = this.elt.length;
        while (--i >= 0) {
            code = code * 37L + Double.doubleToLongBits(this.elt[i]);
        }
        return (int)(code >>> 32) ^ (int)code;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            MatrixTransform that = (MatrixTransform)object;
            return this.numRow == that.numRow && this.numCol == that.numCol && Arrays.equals(this.elt, that.elt);
        }
        return false;
    }

    public String toString() {
        return MatrixTransform.toString(this.getMatrix());
    }

    static String toString(Matrix matrix) {
        int numRow = matrix.getNumRow();
        int numCol = matrix.getNumCol();
        StringBuffer buffer = MatrixTransform.paramMT("Affine");
        StringBuffer eltBuf = new StringBuffer("elt_");
        MatrixTransform.addParameter(buffer, "num_row", numRow);
        MatrixTransform.addParameter(buffer, "num_col", numCol);
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                double value = matrix.getElement(j, i);
                if (value == (double)(i == j ? 1 : 0)) continue;
                eltBuf.setLength(4);
                eltBuf.append(j);
                eltBuf.append('_');
                eltBuf.append(i);
                MatrixTransform.addParameter(buffer, eltBuf.toString(), value);
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    static final class Provider
    extends MathTransformProvider {
        public Provider() {
            super("Affine", 1, null);
            int defaultSize = MatrixParameters.DEFAULT_SIZE;
            this.putInt("num_row", defaultSize, MatrixParameters.POSITIVE_RANGE);
            this.putInt("num_col", defaultSize, MatrixParameters.POSITIVE_RANGE);
        }

        public ParameterList getParameterList() {
            return new MatrixParameters();
        }

        public MathTransform create(ParameterList parameters) {
            Matrix matrix = MatrixParameters.getMatrix(parameters);
            if (matrix.isAffine()) {
                switch (matrix.getNumRow()) {
                    case 3: {
                        return new AffineTransform2D(matrix.toAffineTransform2D());
                    }
                    case 2: {
                        return LinearTransform1D.create(matrix.getElement(0, 0), matrix.getElement(0, 1));
                    }
                }
            }
            if (matrix.isIdentity()) {
                return new IdentityTransform(matrix.getNumRow() - 1);
            }
            return new MatrixTransform(matrix);
        }
    }
}

