/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.awt.Point;
import java.util.Arrays;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.util.Range;
import org.geotools.ct.MathTransformProvider;
import org.geotools.pt.Matrix;
import org.geotools.resources.cts.Resources;

final class MatrixParameters
extends Matrix
implements ParameterList,
ParameterListDescriptor {
    private static final long serialVersionUID = -5150306783193080487L;
    static final Range POSITIVE_RANGE;
    static final Integer DEFAULT_SIZE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MatrixParameters() {
        super(DEFAULT_SIZE);
    }

    public ParameterListDescriptor getParameterListDescriptor() {
        return this;
    }

    public int getNumParameters() {
        return this.getNumRow() * this.getNumCol() + 2;
    }

    public static Matrix getMatrix(ParameterList parameters) {
        if (parameters instanceof Matrix) {
            return (Matrix)parameters;
        }
        int numRow = parameters.getIntParameter("num_row");
        int numCol = parameters.getIntParameter("num_col");
        Matrix matrix = new Matrix(numRow, numCol);
        String[] names = parameters.getParameterListDescriptor().getParamNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                if (!name.regionMatches(true, 0, "elt_", 0, 4)) continue;
                int separator = name.lastIndexOf(95);
                int row = Integer.parseInt(name.substring(4, separator));
                int col = Integer.parseInt(name.substring(separator + 1));
                matrix.setElement(row, col, parameters.getDoubleParameter(name));
            }
        }
        return matrix;
    }

    private Point getIndex(String name) throws IllegalArgumentException {
        NumberFormatException cause = null;
        if (name != null) {
            try {
                if (name.equalsIgnoreCase("num_row")) {
                    return null;
                }
                if (name.equalsIgnoreCase("num_col")) {
                    return null;
                }
                if (name.regionMatches(true, 0, "elt_", 0, 4)) {
                    int separator = name.lastIndexOf(95);
                    short row = Short.parseShort(name.substring(4, separator));
                    short col = Short.parseShort(name.substring(separator + 1));
                    return new Point(col, row);
                }
            }
            catch (NumberFormatException exception) {
                cause = exception;
            }
        }
        IllegalArgumentException exception = new IllegalArgumentException(name);
        exception.initCause(cause);
        throw exception;
    }

    public String[] getParamNames() {
        String[] names = new String[this.getNumParameters()];
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        int index = 0;
        names[index++] = "num_row";
        names[index++] = "num_col";
        StringBuffer buffer = new StringBuffer("elt_");
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                buffer.setLength(4);
                buffer.append(j);
                buffer.append('_');
                buffer.append(i);
                names[index++] = buffer.toString();
            }
        }
        if (!$assertionsDisabled && index != names.length) {
            throw new AssertionError();
        }
        return names;
    }

    public Class[] getParamClasses() {
        Object[] classes = new Class[this.getNumParameters()];
        Arrays.fill(classes, 0, 2, Integer.class);
        Arrays.fill(classes, 2, classes.length, Double.class);
        return classes;
    }

    public Object[] getParamDefaults() {
        Object[] values = new Number[this.getNumParameters()];
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        int index = 0;
        values[index++] = new Integer(numRow);
        values[index++] = new Integer(numCol);
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                values[index++] = i == j ? MathTransformProvider.ONE : MathTransformProvider.ZERO;
            }
        }
        if (!$assertionsDisabled && index != values.length) {
            throw new AssertionError();
        }
        return values;
    }

    public Object getParamDefaultValue(String name) {
        if (name.equalsIgnoreCase("num_row")) {
            return DEFAULT_SIZE;
        }
        if (name.equalsIgnoreCase("num_col")) {
            return DEFAULT_SIZE;
        }
        Point index = this.getIndex(name);
        return index.x == index.y ? MathTransformProvider.ONE : MathTransformProvider.ZERO;
    }

    public Object getObjectParameter(String name) {
        if (name.equalsIgnoreCase("num_row")) {
            return new Integer(this.getNumRow());
        }
        if (name.equalsIgnoreCase("num_col")) {
            return new Integer(this.getNumCol());
        }
        Point index = this.getIndex(name);
        try {
            return new Double(this.getElement(index.y, index.x));
        }
        catch (IndexOutOfBoundsException cause) {
            IllegalArgumentException exception = new IllegalArgumentException(name);
            exception.initCause(cause);
            throw exception;
        }
    }

    public int getIntParameter(String name) {
        if (name.equalsIgnoreCase("num_row")) {
            return this.getNumRow();
        }
        if (name.equalsIgnoreCase("num_col")) {
            return this.getNumCol();
        }
        throw new IllegalArgumentException(name);
    }

    public double getDoubleParameter(String name) {
        Point index = this.getIndex(name);
        if (index == null) {
            return this.getIntParameter(name);
        }
        try {
            return this.getElement(index.y, index.x);
        }
        catch (IndexOutOfBoundsException cause) {
            IllegalArgumentException exception = new IllegalArgumentException(name);
            exception.initCause(cause);
            throw exception;
        }
    }

    public String[] getEnumeratedParameterNames() {
        return new String[0];
    }

    public EnumeratedParameter[] getEnumeratedParameterValues(String name) {
        return new EnumeratedParameter[0];
    }

    public Range getParamValueRange(String name) {
        return this.getIndex(name) == null ? POSITIVE_RANGE : null;
    }

    public boolean isParameterValueValid(String name, Object value) {
        if (this.getIndex(name) == null) {
            if (value instanceof Integer) {
                return ((Number)value).intValue() > 0;
            }
        } else if (value instanceof Number) {
            return !Double.isNaN(((Number)value).doubleValue());
        }
        throw new IllegalArgumentException(Resources.format(50, name, value));
    }

    private static void ensurePositive(String name, int value) {
        if (value <= 0) {
            throw new IllegalArgumentException(Resources.format(50, name, new Integer(value)));
        }
    }

    public ParameterList setParameter(String name, int value) {
        if (name.equalsIgnoreCase("num_row")) {
            MatrixParameters.ensurePositive("num_row", value);
            this.setSize(value, this.getNumCol());
            return this;
        }
        if (name.equalsIgnoreCase("num_col")) {
            MatrixParameters.ensurePositive("num_col", value);
            this.setSize(this.getNumRow(), value);
            return this;
        }
        return this.setParameter(name, (double)value);
    }

    public ParameterList setParameter(String name, double value) {
        IndexOutOfBoundsException cause = null;
        Point index = this.getIndex(name);
        if (index != null) {
            try {
                this.setElement(index.y, index.x, value);
                return this;
            }
            catch (IndexOutOfBoundsException exception) {
                cause = exception;
            }
        }
        IllegalArgumentException exception = new IllegalArgumentException(name);
        exception.initCause(cause);
        throw exception;
    }

    public ParameterList setParameter(String name, Object value) {
        if (this.isParameterValueValid(name, value)) {
            if (value instanceof Integer) {
                return this.setParameter(name, (Integer)value);
            }
            return this.setParameter(name, ((Number)value).doubleValue());
        }
        throw new IllegalArgumentException(Resources.format(50, name, value));
    }

    public boolean getBooleanParameter(String n) {
        throw new IllegalArgumentException(n);
    }

    public byte getByteParameter(String n) {
        throw new IllegalArgumentException(n);
    }

    public char getCharParameter(String n) {
        throw new IllegalArgumentException(n);
    }

    public short getShortParameter(String n) {
        throw new IllegalArgumentException(n);
    }

    public long getLongParameter(String n) {
        throw new IllegalArgumentException(n);
    }

    public float getFloatParameter(String n) {
        return (float)this.getDoubleParameter(n);
    }

    public ParameterList setParameter(String n, boolean v) {
        return this.setParameter(n, v ? 1 : 0);
    }

    public ParameterList setParameter(String n, byte v) {
        return this.setParameter(n, (int)v);
    }

    public ParameterList setParameter(String n, char v) {
        return this.setParameter(n, (int)v);
    }

    public ParameterList setParameter(String n, short v) {
        return this.setParameter(n, (int)v);
    }

    public ParameterList setParameter(String n, long v) {
        return this.setParameter(n, (double)v);
    }

    public ParameterList setParameter(String n, float v) {
        return this.setParameter(n, (double)v);
    }

    static {
        $assertionsDisabled = !MatrixParameters.class.desiredAssertionStatus();
        POSITIVE_RANGE = new Range(Integer.class, (Comparable)new Integer(1), null);
        DEFAULT_SIZE = new Integer(4);
    }
}

