/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.util.Locale;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.ParameterListDescriptorImpl;
import javax.media.jai.ParameterListImpl;
import javax.media.jai.util.Range;
import org.geotools.cs.FactoryException;
import org.geotools.cs.Projection;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MissingParameterException;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;
import org.geotools.resources.cts.Resources;

public abstract class MathTransformProvider {
    static final Double ZERO = new Double(0.0);
    static final Double ONE = new Double(1.0);
    protected static final Range POSITIVE_RANGE = new Range(Double.class, (Comparable)ZERO, false, null, false);
    protected static final Range LONGITUDE_RANGE = new Range(Double.class, (Comparable)new Double(-180.0), true, (Comparable)new Double(180.0), true);
    protected static final Range LATITUDE_RANGE = new Range(Double.class, (Comparable)new Double(-90.0), true, (Comparable)new Double(90.0), true);
    private static final int RECORD_LENGTH = 4;
    public static final ParameterListDescriptor DEFAULT_PROJECTION_DESCRIPTOR = MathTransformProvider.getDescriptor(new Object[]{"semi_major", Double.class, ParameterListDescriptor.NO_PARAMETER_DEFAULT, POSITIVE_RANGE, "semi_minor", Double.class, ParameterListDescriptor.NO_PARAMETER_DEFAULT, POSITIVE_RANGE, "central_meridian", Double.class, ZERO, LONGITUDE_RANGE, "latitude_of_origin", Double.class, ZERO, LATITUDE_RANGE, "scale_factor", Double.class, ONE, POSITIVE_RANGE, "false_easting", Double.class, ZERO, null, "false_northing", Double.class, ZERO, null});
    private Object[] properties;
    private ParameterListDescriptor descriptor;
    private final String classification;
    private final int nameKey;

    protected MathTransformProvider(String classification, ParameterListDescriptor inherit) {
        this(classification, -1, inherit);
    }

    MathTransformProvider(String classification, int nameKey, ParameterListDescriptor inherit) {
        this.classification = classification.trim();
        this.nameKey = nameKey;
        if (inherit != null) {
            String[] names = inherit.getParamNames();
            Class[] classes = inherit.getParamClasses();
            Object[] defaults = inherit.getParamDefaults();
            this.properties = new Object[names.length * 4];
            for (int i = 0; i < names.length; ++i) {
                int j = i * 4;
                this.properties[j + 0] = names[i];
                this.properties[j + 1] = classes[i];
                this.properties[j + 2] = defaults[i];
                this.properties[j + 3] = inherit.getParamValueRange(names[i]);
            }
        } else {
            this.properties = new Object[0];
        }
    }

    protected final void put(String parameter, double defaultValue, Range range) throws IllegalStateException {
        this.put(parameter, Double.class, MathTransformProvider.wrap(defaultValue), range);
    }

    final void putInt(String parameter, int defaultValue, Range range) throws IllegalStateException {
        this.put(parameter, Integer.class, new Integer(defaultValue), range);
    }

    final void putObject(String parameter, Class type) throws IllegalStateException {
        this.put(parameter, type, ParameterListDescriptor.NO_PARAMETER_DEFAULT, null);
    }

    private void put(String parameter, Class type, Object defaultValue, Range range) throws IllegalStateException {
        if (this.properties == null) {
            throw new IllegalStateException();
        }
        if (defaultValue != null && range != null) {
            Comparable check = range.getMinValue();
            if (defaultValue.equals(check)) {
                defaultValue = check;
            }
            if (defaultValue.equals(check = range.getMaxValue())) {
                defaultValue = check;
            }
        }
        parameter = parameter.trim();
        int end = this.properties.length;
        for (int i = 0; i < end; i += 4) {
            if (!parameter.equalsIgnoreCase(this.properties[i].toString())) continue;
            this.properties[i + 0] = parameter;
            this.properties[i + 1] = type;
            this.properties[i + 2] = defaultValue;
            this.properties[i + 3] = range;
            return;
        }
        this.properties = XArray.resize((Object[])this.properties, (int)(end + 4));
        this.properties[end + 0] = parameter;
        this.properties[end + 1] = type;
        this.properties[end + 2] = defaultValue;
        this.properties[end + 3] = range;
    }

    protected final void remove(String parameter) throws IllegalStateException {
        if (this.properties == null) {
            throw new IllegalStateException();
        }
        int i = this.properties.length;
        while ((i -= 4) != 0) {
            if (!parameter.equalsIgnoreCase(this.properties[i].toString())) continue;
            this.properties = XArray.remove((Object[])this.properties, (int)i, (int)4);
        }
    }

    private static Object wrap(double value) {
        if (Double.isNaN(value)) {
            return ParameterListDescriptor.NO_PARAMETER_DEFAULT;
        }
        if (value == -90.0) {
            return LATITUDE_RANGE.getMinValue();
        }
        if (value == 90.0) {
            return LATITUDE_RANGE.getMaxValue();
        }
        if (value == -180.0) {
            return LONGITUDE_RANGE.getMinValue();
        }
        if (value == 180.0) {
            return LONGITUDE_RANGE.getMaxValue();
        }
        if (value == 0.0) {
            return ZERO;
        }
        if (value == 1.0) {
            return ONE;
        }
        return new Double(value);
    }

    private static ParameterListDescriptor getDescriptor(Object[] properties) {
        String[] names = new String[properties.length / 4];
        Class[] classes = new Class[names.length];
        Object[] defaults = new Object[names.length];
        Object[] ranges = new Range[names.length];
        for (int i = 0; i < names.length; ++i) {
            int j = i * 4;
            names[i] = (String)properties[j + 0];
            classes[i] = (Class)properties[j + 1];
            defaults[i] = properties[j + 2];
            ranges[i] = (Range)properties[j + 3];
        }
        return new ParameterListDescriptorImpl(null, names, classes, defaults, ranges);
    }

    public String getClassName() {
        return this.classification;
    }

    public String getName(Locale locale) {
        return this.nameKey >= 0 ? Resources.getResources(locale).getString(this.nameKey) : this.getClassName();
    }

    public synchronized ParameterListDescriptor getParameterListDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = MathTransformProvider.getDescriptor(this.properties);
            this.properties = null;
        }
        return this.descriptor;
    }

    public ParameterList getParameterList() {
        return new ParameterListImpl(this.getParameterListDescriptor());
    }

    public abstract MathTransform create(ParameterList var1) throws MissingParameterException, FactoryException;

    protected MathTransform create(Projection projection) throws MissingParameterException, FactoryException {
        return this.create(projection.getParameters());
    }

    public String toString() {
        return Utilities.getShortClassName((Object)this) + '[' + this.getName(null) + ']';
    }
}

