/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.awt.geom.AffineTransform;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.ParseException;
import java.util.Locale;
import javax.media.jai.IntegerSequence;
import javax.media.jai.ParameterList;
import org.geotools.cs.FactoryException;
import org.geotools.cs.Projection;
import org.geotools.ct.AbridgedMolodenskiTransform;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.Adapters;
import org.geotools.ct.AffineTransform2D;
import org.geotools.ct.ConcatenatedTransform;
import org.geotools.ct.ExponentialTransform1D;
import org.geotools.ct.GeocentricTransform;
import org.geotools.ct.IdentityTransform;
import org.geotools.ct.LinearTransform;
import org.geotools.ct.LinearTransform1D;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransform2D;
import org.geotools.ct.MathTransformProvider;
import org.geotools.ct.MatrixParameters;
import org.geotools.ct.MatrixTransform;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.NoSuchClassificationException;
import org.geotools.ct.PassThroughTransform;
import org.geotools.ct.WKTParser;
import org.geotools.ct.proj.Provider;
import org.geotools.pt.Matrix;
import org.geotools.resources.DescriptorNaming;
import org.geotools.resources.JAIUtilities;
import org.geotools.resources.XArray;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.geotools.util.WeakHashSet;
import org.opengis.ct.CT_MathTransform;
import org.opengis.ct.CT_MathTransformFactory;
import org.opengis.ct.CT_Parameter;
import org.opengis.pt.PT_Matrix;

public class MathTransformFactory {
    private static MathTransformFactory DEFAULT;
    private transient WKTParser parser;
    static final WeakHashSet pool;
    private static final MathTransform[] identities;
    private final MathTransformProvider[] providers;
    private transient Object proxy;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MathTransformFactory(MathTransformProvider[] providers) {
        this.providers = (MathTransformProvider[])providers.clone();
    }

    public static synchronized MathTransformFactory getDefault() {
        if (DEFAULT == null) {
            Object[] transforms = new MathTransformProvider[]{new MatrixTransform.Provider(), new GeocentricTransform.Provider(false), new GeocentricTransform.Provider(true), new AbridgedMolodenskiTransform.Provider(), new ExponentialTransform1D.Provider(false), new ExponentialTransform1D.Provider(true)};
            int offset = transforms.length;
            Provider[] projections = Provider.getDefaults();
            transforms = (MathTransformProvider[])XArray.resize((Object[])transforms, (int)(offset + projections.length));
            System.arraycopy(projections, 0, transforms, offset, projections.length);
            DEFAULT = new MathTransformFactory((MathTransformProvider[])transforms);
        }
        return DEFAULT;
    }

    public MathTransform createIdentityTransform(int dimension) {
        MathTransform transform;
        if (dimension < identities.length && (transform = identities[dimension]) != null) {
            return transform;
        }
        transform = this.createAffineTransform(new Matrix(dimension + 1));
        if (dimension < identities.length) {
            MathTransformFactory.identities[dimension] = transform;
        }
        return transform;
    }

    public MathTransform2D createAffineTransform(AffineTransform matrix) {
        if (matrix.isIdentity()) {
            return MathTransform2D.IDENTITY;
        }
        return (MathTransform2D)pool.canonicalize((Object)new AffineTransform2D(matrix));
    }

    public MathTransform createAffineTransform(Matrix matrix) {
        int numRow = matrix.getNumRow();
        if (matrix.isAffine()) {
            switch (numRow) {
                case 2: {
                    return (MathTransform)pool.canonicalize((Object)LinearTransform1D.create(matrix.getElement(0, 0), matrix.getElement(0, 1)));
                }
                case 3: {
                    return this.createAffineTransform(matrix.toAffineTransform2D());
                }
            }
        }
        return (MathTransform)pool.canonicalize((Object)(matrix.isIdentity() ? new IdentityTransform(numRow - 1) : new MatrixTransform(matrix)));
    }

    private static Matrix getMatrix(MathTransform transform) {
        if (transform instanceof LinearTransform) {
            return ((LinearTransform)transform).getMatrix();
        }
        if (transform instanceof AffineTransform) {
            return new Matrix((AffineTransform)((Object)transform));
        }
        return null;
    }

    private static boolean areInverse(MathTransform tr1, MathTransform tr2) {
        if (tr2 instanceof AbstractMathTransform.Inverse) {
            return tr1.equals(((AbstractMathTransform.Inverse)tr2).inverse());
        }
        return false;
    }

    public MathTransform createConcatenatedTransform(MathTransform tr1, MathTransform tr2) {
        MathTransform optimized;
        ConcatenatedTransform ctr;
        Matrix matrix2;
        if (tr1.isIdentity()) {
            return tr2;
        }
        if (tr2.isIdentity()) {
            return tr1;
        }
        Matrix matrix1 = MathTransformFactory.getMatrix(tr1);
        if (matrix1 != null && (matrix2 = MathTransformFactory.getMatrix(tr2)) != null) {
            Matrix matrix;
            int numRow = matrix2.getNumRow();
            int numCol = matrix1.getNumCol();
            if (numCol == matrix2.getNumCol()) {
                matrix = matrix2;
                matrix2.mul(matrix1);
            } else {
                matrix = new Matrix(numRow, numCol);
                matrix.mul(matrix2, matrix1);
            }
            return this.createAffineTransform(matrix);
        }
        if (MathTransformFactory.areInverse(tr1, tr2) || MathTransformFactory.areInverse(tr2, tr1)) {
            if (!$assertionsDisabled && tr1.getDimSource() != tr2.getDimTarget()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && tr1.getDimTarget() != tr2.getDimSource()) {
                throw new AssertionError();
            }
            return this.createIdentityTransform(tr1.getDimSource());
        }
        if (tr1 instanceof ConcatenatedTransform) {
            ctr = (ConcatenatedTransform)tr1;
            tr1 = ctr.transform1;
            tr2 = this.createConcatenatedTransform(ctr.transform2, tr2);
        }
        if (tr2 instanceof ConcatenatedTransform) {
            ctr = (ConcatenatedTransform)tr2;
            tr1 = this.createConcatenatedTransform(tr1, ctr.transform1);
            tr2 = ctr.transform2;
        }
        if (tr1 instanceof AbstractMathTransform && (optimized = ((AbstractMathTransform)tr1).concatenate(tr2, false)) != null) {
            return (MathTransform)pool.canonicalize((Object)optimized);
        }
        if (tr2 instanceof AbstractMathTransform && (optimized = ((AbstractMathTransform)tr2).concatenate(tr1, true)) != null) {
            return (MathTransform)pool.canonicalize((Object)optimized);
        }
        return (MathTransform)pool.canonicalize((Object)ConcatenatedTransform.create(this, tr1, tr2));
    }

    public MathTransform createPassThroughTransform(int firstAffectedOrdinate, MathTransform subTransform, int numTrailingOrdinates) {
        int dimension;
        if (firstAffectedOrdinate < 0) {
            throw new IllegalArgumentException(Resources.format(50, "firstAffectedOrdinate", new Integer(firstAffectedOrdinate)));
        }
        if (numTrailingOrdinates < 0) {
            throw new IllegalArgumentException(Resources.format(50, "numTrailingOrdinates", new Integer(numTrailingOrdinates)));
        }
        if (firstAffectedOrdinate == 0 && numTrailingOrdinates == 0) {
            return subTransform;
        }
        if (subTransform.isIdentity() && (dimension = subTransform.getDimSource()) == subTransform.getDimTarget()) {
            return this.createIdentityTransform(firstAffectedOrdinate + dimension + numTrailingOrdinates);
        }
        if (subTransform instanceof LinearTransform) {
            Matrix matrix = ((LinearTransform)subTransform).getMatrix();
            matrix = PassThroughTransform.expand(matrix, firstAffectedOrdinate, numTrailingOrdinates, 1);
            return this.createAffineTransform(matrix);
        }
        return (MathTransform)pool.canonicalize((Object)new PassThroughTransform(firstAffectedOrdinate, subTransform, numTrailingOrdinates));
    }

    public MathTransform createSubMathTransform(int lower, int upper, MathTransform transform) {
        if (transform instanceof PassThroughTransform) {
            try {
                return this.createSubTransform(transform, JAIUtilities.createSequence(lower, upper - 1), null);
            }
            catch (FactoryException exception) {
                throw new RuntimeException(exception.getLocalizedMessage(), exception);
            }
        }
        return this.createFilterTransform(transform, JAIUtilities.createSequence(lower, upper - 1));
    }

    public MathTransform createSubTransform(MathTransform transform, IntegerSequence inputDimensions, IntegerSequence outputDimensions) throws FactoryException {
        int dimSource = transform.getDimSource();
        int dimTarget = transform.getDimTarget();
        int dimInput = inputDimensions.getNumElements();
        int lower = JAIUtilities.getMinimum(inputDimensions);
        int upper = JAIUtilities.getMaximum(inputDimensions) + 1;
        if (lower < 0 || lower >= upper) {
            throw new IllegalArgumentException(Resources.format(50, "minimum(inputDimensions)", new Integer(lower)));
        }
        if (upper > dimSource) {
            throw new IllegalArgumentException(Resources.format(50, "maximum(inputDimensions)", new Integer(upper - 1)));
        }
        if (dimInput == dimSource) {
            if (!($assertionsDisabled || lower == 0 && upper == dimSource)) {
                throw new AssertionError();
            }
            JAIUtilities.fill(outputDimensions, 0, dimTarget);
            return transform;
        }
        if (transform.isIdentity()) {
            JAIUtilities.add(outputDimensions, inputDimensions, 0);
            return this.createIdentityTransform(dimInput);
        }
        if (transform instanceof ConcatenatedTransform) {
            ConcatenatedTransform ctr = (ConcatenatedTransform)transform;
            IntegerSequence trans = new IntegerSequence();
            MathTransform step1 = this.createSubTransform(ctr.transform1, inputDimensions, trans);
            MathTransform step2 = this.createSubTransform(ctr.transform2, trans, outputDimensions);
            return this.createConcatenatedTransform(step1, step2);
        }
        if (transform instanceof PassThroughTransform) {
            PassThroughTransform passThrough = (PassThroughTransform)transform;
            int dimPass = passThrough.transform.getDimSource();
            int dimDiff = passThrough.transform.getDimTarget() - dimPass;
            int subLower = passThrough.firstAffectedOrdinate;
            int subUpper = subLower + dimPass;
            IntegerSequence subInputs = new IntegerSequence();
            inputDimensions.startEnumeration();
            while (inputDimensions.hasMoreElements()) {
                int n = inputDimensions.nextElement();
                if (n >= subLower && n < subUpper) {
                    subInputs.insert(n - subLower);
                    continue;
                }
                if (outputDimensions == null) continue;
                if (n >= subUpper) {
                    n += dimDiff;
                }
                outputDimensions.insert(n);
            }
            if (subInputs.getNumElements() == 0) {
                return this.createIdentityTransform(dimInput);
            }
            IntegerSequence subOutputs = outputDimensions != null ? new IntegerSequence() : null;
            MathTransform subTransform = this.createSubTransform(passThrough.transform, subInputs, subOutputs);
            JAIUtilities.add(outputDimensions, subOutputs, subLower);
            if (JAIUtilities.containsAll(inputDimensions, lower, subLower) && JAIUtilities.containsAll(inputDimensions, subUpper, upper)) {
                int firstAffectedOrdinate = Math.max(0, subLower - lower);
                int numTrailingOrdinates = Math.max(0, upper - subUpper);
                return this.createPassThroughTransform(firstAffectedOrdinate, subTransform, numTrailingOrdinates);
            }
        }
        if (transform instanceof LinearTransform) {
            int nRows = 0;
            boolean hasLastRow = false;
            double[][] rows = ((LinearTransform)transform).getMatrix().getElements();
            if (!$assertionsDisabled && rows.length - 1 != dimTarget) {
                throw new AssertionError();
            }
            block1: for (int j = 0; j < rows.length; ++j) {
                double[] row = rows[j];
                if (!$assertionsDisabled && row.length - 1 != dimSource) {
                    throw new AssertionError(row.length);
                }
                int nCols = 0;
                for (int i = 0; i < dimSource; ++i) {
                    if (JAIUtilities.contains(inputDimensions, i)) {
                        row[nCols++] = row[i];
                        continue;
                    }
                    if (row[i] != 0.0) continue block1;
                }
                if (j == dimTarget) {
                    hasLastRow = true;
                } else if (outputDimensions != null) {
                    outputDimensions.insert(j);
                }
                if (!$assertionsDisabled && nCols != dimInput) {
                    throw new AssertionError(nCols);
                }
                row[nCols++] = row[dimSource];
                rows[nRows++] = XArray.resize((double[])row, (int)nCols);
            }
            rows = (double[][])XArray.resize((Object[])rows, (int)nRows);
            if (hasLastRow) {
                return this.createAffineTransform(new Matrix(rows));
            }
        }
        throw new FactoryException(Resources.format(92));
    }

    public MathTransform createFilterTransform(MathTransform transform, IntegerSequence outputDimensions) {
        int dimSource = transform.getDimSource();
        int dimTarget = transform.getDimTarget();
        int dimOutput = outputDimensions.getNumElements();
        int lower = JAIUtilities.getMinimum(outputDimensions);
        int upper = JAIUtilities.getMaximum(outputDimensions) + 1;
        if (lower < 0 || lower >= upper) {
            throw new IllegalArgumentException(Resources.format(50, "minimum(outputDimensions)", new Integer(lower)));
        }
        if (upper > dimTarget) {
            throw new IllegalArgumentException(Resources.format(50, "maximum(outputDimensions)", new Integer(upper)));
        }
        if (dimOutput == dimTarget) {
            if (!($assertionsDisabled || lower == 0 && upper == dimTarget)) {
                throw new AssertionError();
            }
            return transform;
        }
        int dimPass = 0;
        int dimDiff = 0;
        int dimStep = dimTarget;
        if (transform instanceof PassThroughTransform) {
            PassThroughTransform passThrough = (PassThroughTransform)transform;
            int subLower = passThrough.firstAffectedOrdinate;
            int subUpper = subLower + passThrough.transform.getDimTarget();
            if (!JAIUtilities.containsAny(outputDimensions, subLower, subUpper)) {
                transform = null;
                dimStep = dimSource;
                dimPass = subLower;
                dimDiff = subLower + passThrough.transform.getDimSource() - subUpper;
            }
        }
        Matrix matrix = new Matrix(dimOutput + 1, dimStep + 1);
        matrix.setZero();
        int j = 0;
        outputDimensions.startEnumeration();
        while (outputDimensions.hasMoreElements()) {
            int i = outputDimensions.nextElement();
            if (i >= dimPass) {
                i += dimDiff;
            }
            matrix.setElement(j, i, 1.0);
            ++j;
        }
        matrix.setElement(dimOutput, dimStep, 1.0);
        MathTransform filtered = this.createAffineTransform(matrix);
        if (transform != null) {
            filtered = this.createConcatenatedTransform(transform, filtered);
        }
        return filtered;
    }

    public MathTransform createParameterizedTransform(String classification, ParameterList parameters) throws MissingParameterException, FactoryException {
        if ((classification = classification.trim()).equalsIgnoreCase("Affine")) {
            return this.createAffineTransform(MatrixParameters.getMatrix(parameters));
        }
        MathTransform transform = this.getMathTransformProvider(classification).create(parameters);
        return (MathTransform)pool.canonicalize((Object)transform);
    }

    public MathTransform createParameterizedTransform(Projection projection) throws MissingParameterException, FactoryException {
        MathTransform transform = this.getMathTransformProvider(projection.getClassName()).create(projection);
        return (MathTransform)pool.canonicalize((Object)transform);
    }

    public String[] getAvailableTransforms() {
        String[] names = new String[this.providers.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.providers[i].getClassName();
        }
        return names;
    }

    public MathTransformProvider getMathTransformProvider(String classification) throws NoSuchClassificationException {
        classification = classification.trim();
        for (int i = 0; i < this.providers.length; ++i) {
            if (!classification.equalsIgnoreCase(this.providers[i].getClassName().trim())) continue;
            return this.providers[i];
        }
        throw new NoSuchClassificationException(null, classification);
    }

    public MathTransformProvider getAffineTransformProvider(int numRow, int numCol) throws IllegalArgumentException, FactoryException {
        return new MatrixTransform.Provider();
    }

    public Unit getParameterUnit(String parameter) {
        return DescriptorNaming.getParameterUnit(parameter);
    }

    public MathTransform createFromWKT(String text) throws FactoryException {
        if (this.parser == null) {
            this.parser = new WKTParser(Locale.US, this);
        }
        try {
            return this.parser.parseMathTransform(text);
        }
        catch (ParseException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new FactoryException(exception.getLocalizedMessage(), exception);
        }
    }

    final synchronized Object toOpenGIS(Object adapters) throws RemoteException {
        if (this.proxy != null) {
            if (this.proxy instanceof Reference) {
                Object ref = ((Reference)this.proxy).get();
                if (ref != null) {
                    return ref;
                }
            } else {
                return this.proxy;
            }
        }
        Export opengis = new Export(adapters);
        this.proxy = new WeakReference<Export>(opengis);
        return opengis;
    }

    static {
        $assertionsDisabled = !MathTransformFactory.class.desiredAssertionStatus();
        pool = new WeakHashSet();
        identities = new MathTransform[8];
    }

    private final class Export
    extends UnicastRemoteObject
    implements CT_MathTransformFactory {
        protected final Adapters adapters;

        protected Export(Object adapters) throws RemoteException {
            this.adapters = (Adapters)adapters;
        }

        public CT_MathTransform createAffineTransform(PT_Matrix matrix) throws RemoteException {
            return this.adapters.export(MathTransformFactory.this.createAffineTransform(this.adapters.wrap(matrix)));
        }

        public CT_MathTransform createConcatenatedTransform(CT_MathTransform transform1, CT_MathTransform transform2) throws RemoteException {
            return this.adapters.export(MathTransformFactory.this.createConcatenatedTransform(this.adapters.wrap(transform1), this.adapters.wrap(transform2)));
        }

        public CT_MathTransform createPassThroughTransform(int firstAffectedOrdinate, CT_MathTransform subTransform) throws RemoteException {
            return this.adapters.export(MathTransformFactory.this.createPassThroughTransform(firstAffectedOrdinate, this.adapters.wrap(subTransform), 0));
        }

        public CT_MathTransform createParameterizedTransform(String classification, CT_Parameter[] parameters) throws RemoteException {
            try {
                return this.adapters.export(MathTransformFactory.this.createParameterizedTransform(classification, this.adapters.wrap(parameters)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CT_MathTransform createFromWKT(String text) throws RemoteException {
            try {
                return this.adapters.export(MathTransformFactory.this.createFromWKT(text));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CT_MathTransform createFromXML(String xml) throws RemoteException {
            throw new UnsupportedOperationException("XML parsing not yet implemented");
        }

        public boolean isParameterAngular(String parameterName) throws RemoteException {
            Unit unit = MathTransformFactory.this.getParameterUnit(parameterName);
            return unit != null && Unit.DEGREE.canConvert(unit);
        }

        public boolean isParameterLinear(String parameterName) throws RemoteException {
            Unit unit = MathTransformFactory.this.getParameterUnit(parameterName);
            return unit != null && Unit.METRE.canConvert(unit);
        }
    }
}

