/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import org.geotools.ct.Adapters;
import org.geotools.ct.MathTransform;
import org.geotools.ct.NoninvertibleTransformException;
import org.geotools.ct.TransformException;
import org.geotools.resources.cts.Resources;
import org.opengis.ct.CT_DomainFlags;
import org.opengis.ct.CT_MathTransform;
import org.opengis.pt.PT_CoordinatePoint;
import org.opengis.pt.PT_Matrix;

final class MathTransformExport
extends UnicastRemoteObject
implements CT_MathTransform {
    protected final Adapters adapters;
    protected final MathTransform transform;

    protected MathTransformExport(Object adapters, MathTransform transform) throws RemoteException {
        this.adapters = (Adapters)adapters;
        this.transform = transform;
    }

    public static Object unwrap(Object object) {
        return object instanceof MathTransformExport ? ((MathTransformExport)object).transform : object;
    }

    public CT_DomainFlags getDomainFlags(double[] ord) throws RemoteException {
        throw new UnsupportedOperationException("Convex hull not yet implemented");
    }

    public double[] getCodomainConvexHull(double[] ord) throws RemoteException {
        throw new UnsupportedOperationException("Convex hull not yet implemented");
    }

    public String getWKT() throws RemoteException {
        throw new UnsupportedOperationException("WKT formating not yet implemented");
    }

    public String getXML() throws RemoteException {
        throw new UnsupportedOperationException("XML formating not yet implemented");
    }

    public int getDimSource() throws RemoteException {
        return this.transform.getDimSource();
    }

    public int getDimTarget() throws RemoteException {
        return this.transform.getDimTarget();
    }

    public boolean isIdentity() throws RemoteException {
        return this.transform.isIdentity();
    }

    public PT_CoordinatePoint transform(PT_CoordinatePoint cp) throws RemoteException {
        try {
            PT_CoordinatePoint point = new PT_CoordinatePoint();
            point.ord = new double[this.transform.getDimTarget()];
            this.transform.transform(cp.ord, 0, point.ord, 0, 1);
            return point;
        }
        catch (TransformException exception) {
            throw new ServerException(exception.getLocalizedMessage(), exception);
        }
    }

    public double[] transformList(double[] ord) throws RemoteException {
        int dimSource = this.transform.getDimSource();
        int dimTarget = this.transform.getDimTarget();
        if (ord.length % dimSource != 0) {
            throw new IllegalArgumentException(Resources.format(51, new Integer(dimSource)));
        }
        int count = ord.length / dimSource;
        double[] dest = dimSource == dimTarget ? ord : new double[count * dimTarget];
        try {
            this.transform.transform(ord, 0, dest, 0, count);
            return dest;
        }
        catch (TransformException exception) {
            throw new ServerException(exception.getLocalizedMessage(), exception);
        }
    }

    public PT_Matrix derivative(PT_CoordinatePoint cp) throws RemoteException {
        try {
            return this.adapters.export(this.transform.derivative(this.adapters.wrap(cp)));
        }
        catch (TransformException exception) {
            throw new ServerException(exception.getLocalizedMessage(), exception);
        }
    }

    public CT_MathTransform inverse() throws RemoteException {
        try {
            return this.adapters.export(this.transform.inverse());
        }
        catch (NoninvertibleTransformException exception) {
            throw new ServerException(exception.getLocalizedMessage(), exception);
        }
    }
}

