/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.awt.geom.Point2D;
import java.rmi.RemoteException;
import org.geotools.ct.MathTransform2D;
import org.geotools.ct.MathTransformAdapter;
import org.geotools.ct.TransformException;
import org.geotools.pt.Matrix;
import org.opengis.ct.CT_MathTransform;
import org.opengis.pt.PT_CoordinatePoint;

final class MathTransformAdapter2D
extends MathTransformAdapter
implements MathTransform2D {
    private static final long serialVersionUID = 2870952997133267365L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MathTransformAdapter2D(CT_MathTransform transform) throws RemoteException {
        super(transform);
        if (this.getDimSource() != 2 || this.getDimTarget() != 2) {
            throw new IllegalArgumentException();
        }
    }

    public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
        if (!($assertionsDisabled || this.getDimSource() == 2 && this.getDimTarget() == 2)) {
            throw new AssertionError();
        }
        try {
            double[] array = this.transform.transformList(new double[]{ptSrc.getX(), ptSrc.getY()});
            if (ptDst != null) {
                ptDst.setLocation(array[0], array[1]);
                return ptDst;
            }
            return new Point2D.Double(array[0], array[1]);
        }
        catch (RemoteException exception) {
            Throwable cause = exception.detail;
            if (cause instanceof TransformException) {
                throw (TransformException)cause;
            }
            throw new TransformException(exception.getLocalizedMessage(), exception);
        }
    }

    public Matrix derivative(Point2D point) throws TransformException {
        try {
            PT_CoordinatePoint ogPoint = point != null ? new PT_CoordinatePoint(point.getX(), point.getY()) : null;
            return new Matrix(this.transform.derivative((PT_CoordinatePoint)ogPoint).elt);
        }
        catch (RemoteException exception) {
            Throwable cause = exception.detail;
            if (cause instanceof TransformException) {
                throw (TransformException)cause;
            }
            throw new TransformException(exception.getLocalizedMessage(), exception);
        }
    }

    static {
        $assertionsDisabled = !MathTransformAdapter2D.class.desiredAssertionStatus();
    }
}

