/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Arrays;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.MathTransform;
import org.geotools.ct.NoninvertibleTransformException;
import org.geotools.ct.TransformException;
import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Matrix;
import org.geotools.resources.Utilities;
import org.opengis.ct.CT_MathTransform;
import org.opengis.pt.PT_CoordinatePoint;

class MathTransformAdapter
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 4497134108375420674L;
    protected final CT_MathTransform transform;
    private final int dimSource;
    private final int dimTarget;
    private final boolean isIdentity;
    protected transient MathTransformAdapter inverse;

    public MathTransformAdapter(CT_MathTransform transform) throws RemoteException {
        super(transform);
        this.transform = transform;
        this.dimSource = transform.getDimSource();
        this.dimTarget = transform.getDimTarget();
        this.isIdentity = transform.isIdentity();
    }

    public final void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        try {
            if (srcOff == 0 && dstOff == 0 && srcPts == dstPts && this.dimSource == this.dimTarget && numPts * this.dimSource == srcPts.length) {
                double[] array = this.transform.transformList(srcPts);
                if (array != dstPts) {
                    System.arraycopy(array, 0, dstPts, 0, array.length);
                    Arrays.fill(dstPts, array.length, dstPts.length, Double.NaN);
                }
            } else {
                double[] array = new double[numPts * Math.max(this.dimSource, this.dimTarget)];
                System.arraycopy(srcPts, srcOff, array, 0, numPts * this.dimSource);
                array = this.transform.transformList(array);
                System.arraycopy(array, 0, dstPts, dstOff, array.length);
                Arrays.fill(dstPts, array.length, numPts * this.dimTarget, Double.NaN);
            }
        }
        catch (RemoteException exception) {
            Throwable cause = exception.detail;
            if (cause instanceof TransformException) {
                throw (TransformException)cause;
            }
            throw new TransformException(exception.getLocalizedMessage(), exception);
        }
    }

    public final void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        try {
            double[] array = new double[numPts * Math.max(this.dimSource, this.dimTarget)];
            int i = numPts * this.dimSource;
            while (--i >= 0) {
                array[i] = srcPts[i + srcOff];
            }
            array = this.transform.transformList(array);
            i = array.length;
            while (--i >= 0) {
                dstPts[i + dstOff] = (float)array[i];
            }
            Arrays.fill(dstPts, array.length, numPts * this.dimTarget, Float.NaN);
        }
        catch (RemoteException exception) {
            Throwable cause = exception.detail;
            if (cause instanceof TransformException) {
                throw (TransformException)cause;
            }
            throw new TransformException(exception.getLocalizedMessage(), exception);
        }
    }

    public Matrix derivative(CoordinatePoint point) throws TransformException {
        try {
            PT_CoordinatePoint ogPoint;
            if (point != null) {
                ogPoint = new PT_CoordinatePoint();
                ogPoint.ord = point.ord;
            } else {
                ogPoint = null;
            }
            return new Matrix(this.transform.derivative((PT_CoordinatePoint)ogPoint).elt);
        }
        catch (RemoteException exception) {
            Throwable cause = exception.detail;
            if (cause instanceof TransformException) {
                throw (TransformException)cause;
            }
            throw new TransformException(exception.getLocalizedMessage(), exception);
        }
    }

    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            try {
                this.inverse = new MathTransformAdapter(this.transform.inverse());
                this.inverse.inverse = this;
            }
            catch (RemoteException exception) {
                Throwable cause = exception.detail;
                if (cause instanceof NoninvertibleTransformException) {
                    throw (NoninvertibleTransformException)cause;
                }
                throw new NoninvertibleTransformException(exception.getLocalizedMessage(), exception);
            }
        }
        return this.inverse;
    }

    public final int getDimSource() {
        return this.dimSource;
    }

    public final int getDimTarget() {
        return this.dimTarget;
    }

    public final boolean isIdentity() {
        return this.isIdentity;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            return Utilities.equals((Object)((MathTransformAdapter)object).transform, (Object)this.transform);
        }
        return false;
    }
}

