/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.io.Serializable;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.ExponentialTransform1D;
import org.geotools.ct.LinearTransform;
import org.geotools.ct.LinearTransform1D;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransform1D;

final class LogarithmicTransform1D
extends AbstractMathTransform
implements MathTransform1D,
Serializable {
    private static final long serialVersionUID = 1402978401206564931L;
    public final double base;
    final double lnBase;
    public final double offset;
    private transient MathTransform inverse;

    LogarithmicTransform1D(ExponentialTransform1D inverse) {
        this.base = inverse.base;
        this.lnBase = inverse.lnBase;
        this.offset = -Math.log(inverse.scale) / this.lnBase;
        this.inverse = inverse;
    }

    protected LogarithmicTransform1D(double base, double offset) {
        this.base = base;
        this.offset = offset;
        this.lnBase = Math.log(base);
    }

    public int getDimSource() {
        return 1;
    }

    public int getDimTarget() {
        return 1;
    }

    public MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new ExponentialTransform1D(this);
        }
        return this.inverse;
    }

    public double derivative(double value) {
        return 1.0 / (this.lnBase * value);
    }

    public double transform(double value) {
        return Math.log(value) / this.lnBase + this.offset;
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = (float)(Math.log(srcPts[srcOff++]) / this.lnBase + this.offset);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = (float)(Math.log(srcPts[srcOff++]) / this.lnBase + this.offset);
            }
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = Math.log(srcPts[srcOff++]) / this.lnBase + this.offset;
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = Math.log(srcPts[srcOff++]) / this.lnBase + this.offset;
            }
        }
    }

    MathTransform concatenate(MathTransform other, boolean applyOtherFirst) {
        if (other instanceof LinearTransform) {
            LinearTransform1D linear = (LinearTransform1D)other;
            if (applyOtherFirst) {
                if (linear.offset == 0.0 && linear.scale > 0.0) {
                    return new LogarithmicTransform1D(this.base, Math.log(linear.scale) / this.lnBase + this.offset);
                }
            } else {
                double newBase = Math.pow(this.base, 1.0 / linear.scale);
                if (!Double.isNaN(newBase)) {
                    return new LogarithmicTransform1D(newBase, linear.scale * this.offset + linear.offset);
                }
            }
        } else if (other instanceof ExponentialTransform1D) {
            return ((ExponentialTransform1D)other).concatenateLog(this, !applyOtherFirst);
        }
        return super.concatenate(other, applyOtherFirst);
    }

    public int hashCode() {
        long code = 75493004L + Double.doubleToLongBits(this.base);
        code = code * 37L + Double.doubleToLongBits(this.offset);
        return (int)(code >>> 32) ^ (int)code;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            LogarithmicTransform1D that = (LogarithmicTransform1D)object;
            return Double.doubleToLongBits(this.base) == Double.doubleToLongBits(that.base) && Double.doubleToLongBits(this.offset) == Double.doubleToLongBits(that.offset);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = LogarithmicTransform1D.paramMT("Logarithmic");
        LogarithmicTransform1D.addParameter(buffer, "base", this.base);
        if (this.offset != 0.0) {
            LogarithmicTransform1D.addParameter(buffer, "offset", this.offset);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

