/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.io.Serializable;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.LinearTransform;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MatrixTransform;
import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Matrix;

final class IdentityTransform
extends AbstractMathTransform
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -5339040282922138164L;
    private final int dimension;

    protected IdentityTransform(int dimension) {
        this.dimension = dimension;
    }

    public boolean isIdentity() {
        return true;
    }

    public int getDimSource() {
        return this.dimension;
    }

    public int getDimTarget() {
        return this.dimension;
    }

    public Matrix getMatrix() {
        return new Matrix(this.dimension + 1);
    }

    public Matrix derivative(CoordinatePoint point) {
        return new Matrix(this.dimension);
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * this.dimension);
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * this.dimension);
    }

    public MathTransform inverse() {
        return this;
    }

    public int hashCode() {
        return 78215634 + this.dimension;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            IdentityTransform that = (IdentityTransform)object;
            return this.dimension == that.dimension;
        }
        return false;
    }

    public String toString() {
        return MatrixTransform.toString(this.getMatrix());
    }
}

