/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.media.jai.ParameterList;
import org.geotools.cs.Ellipsoid;
import org.geotools.ct.AbridgedMolodenskiTransform;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransformProvider;
import org.geotools.ct.TransformException;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;

final class GeocentricTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -3352045463953828140L;
    private static final double MAX_ERROR = 0.01;
    private static final double COS_67P5 = 0.3826834323650898;
    private static final double AD_C = 1.0026;
    private final double a;
    private final double b;
    private final double a2;
    private final double b2;
    private final double e2;
    private final double ep2;
    private final boolean hasHeight;
    private transient MathTransform inverse;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected GeocentricTransform(Ellipsoid ellipsoid, boolean hasHeight) {
        this(ellipsoid.getSemiMajorAxis(), ellipsoid.getSemiMinorAxis(), ellipsoid.getAxisUnit(), hasHeight);
    }

    protected GeocentricTransform(double semiMajor, double semiMinor, Unit units, boolean hasHeight) {
        this.hasHeight = hasHeight;
        this.a = Unit.METRE.convert(semiMajor, units);
        this.b = Unit.METRE.convert(semiMinor, units);
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
        this.e2 = (this.a2 - this.b2) / this.a2;
        this.ep2 = (this.a2 - this.b2) / this.b2;
        GeocentricTransform.checkArgument("a", this.a, Double.MAX_VALUE);
        GeocentricTransform.checkArgument("b", this.b, this.a);
    }

    private static void checkArgument(String name, double value, double max) throws IllegalArgumentException {
        if (!(value >= 0.0) || !(value <= max)) {
            throw new IllegalArgumentException(Resources.format(50, name, new Double(value)));
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        this.transform(srcPts, srcOff, dstPts, dstOff, numPts, false);
    }

    private void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts, boolean hasHeight) {
        int step = 0;
        int dimSource = this.getDimSource();
        hasHeight |= dimSource >= 3;
        if (srcPts == dstPts && srcOff < dstOff && srcOff + numPts * dimSource > dstOff) {
            step = -dimSource;
            srcOff -= (numPts - 1) * step;
            dstOff -= (numPts - 1) * step;
        }
        while (--numPts >= 0) {
            double L = Math.toRadians(srcPts[srcOff++]);
            double P = Math.toRadians(srcPts[srcOff++]);
            double h = hasHeight ? srcPts[srcOff++] : 0.0;
            double cosLat = Math.cos(P);
            double sinLat = Math.sin(P);
            double rn = this.a / Math.sqrt(1.0 - this.e2 * (sinLat * sinLat));
            dstPts[dstOff++] = (rn + h) * cosLat * Math.cos(L);
            dstPts[dstOff++] = (rn + h) * cosLat * Math.sin(L);
            dstPts[dstOff++] = (rn * (1.0 - this.e2) + h) * sinLat;
            srcOff += step;
            dstOff += step;
        }
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        boolean hasHeight;
        int step = 0;
        int dimSource = this.getDimSource();
        boolean bl = hasHeight = dimSource >= 3;
        if (srcPts == dstPts && srcOff < dstOff && srcOff + numPts * dimSource > dstOff) {
            step = -dimSource;
            srcOff -= (numPts - 1) * step;
            dstOff -= (numPts - 1) * step;
        }
        while (--numPts >= 0) {
            double L = Math.toRadians(srcPts[srcOff++]);
            double P = Math.toRadians(srcPts[srcOff++]);
            double h = hasHeight ? (double)srcPts[srcOff++] : 0.0;
            double cosLat = Math.cos(P);
            double sinLat = Math.sin(P);
            double rn = this.a / Math.sqrt(1.0 - this.e2 * (sinLat * sinLat));
            dstPts[dstOff++] = (float)((rn + h) * cosLat * Math.cos(L));
            dstPts[dstOff++] = (float)((rn + h) * cosLat * Math.sin(L));
            dstPts[dstOff++] = (float)((rn * (1.0 - this.e2) + h) * sinLat);
            srcOff += step;
            dstOff += step;
        }
    }

    protected final void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        boolean hasHeight;
        int step = 0;
        int dimSource = this.getDimSource();
        boolean computeHeight = hasHeight = dimSource >= 3;
        if (!$assertionsDisabled) {
            computeHeight = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (srcPts == dstPts && srcOff < dstOff && srcOff + numPts * dimSource > dstOff) {
            step = -dimSource;
            srcOff -= (numPts - 1) * step;
            dstOff -= (numPts - 1) * step;
        }
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            double z = srcPts[srcOff++];
            double W2 = x * x + y * y;
            double W = Math.sqrt(W2);
            double T0 = z * 1.0026;
            double S0 = Math.sqrt(T0 * T0 + W2);
            double sin_B0 = T0 / S0;
            double cos_B0 = W / S0;
            double sin3_B0 = sin_B0 * sin_B0 * sin_B0;
            double T1 = z + this.b * this.ep2 * sin3_B0;
            double sum = W - this.a * this.e2 * (cos_B0 * cos_B0 * cos_B0);
            double S1 = Math.sqrt(T1 * T1 + sum * sum);
            double sin_p1 = T1 / S1;
            double cos_p1 = sum / S1;
            double longitude = Math.toDegrees(Math.atan2(y, x));
            double latitude = Math.toDegrees(Math.atan(sin_p1 / cos_p1));
            dstPts[dstOff++] = longitude;
            dstPts[dstOff++] = latitude;
            if (computeHeight) {
                double distance;
                double rn = this.a / Math.sqrt(1.0 - this.e2 * (sin_p1 * sin_p1));
                double height = cos_p1 >= 0.3826834323650898 ? W / cos_p1 - rn : (cos_p1 <= -0.3826834323650898 ? W / -cos_p1 - rn : z / sin_p1 + rn * (this.e2 - 1.0));
                if (hasHeight) {
                    dstPts[dstOff++] = height;
                }
                if (!$assertionsDisabled && !(0.01 > (distance = this.checkTransform(new double[]{x, y, z, longitude, latitude, height})))) {
                    throw new AssertionError(distance);
                }
            }
            srcOff += step;
            dstOff += step;
        }
    }

    protected final void inverseTransform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        boolean hasHeight;
        int step = 0;
        int dimSource = this.getDimSource();
        boolean computeHeight = hasHeight = dimSource >= 3;
        if (!$assertionsDisabled) {
            computeHeight = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (srcPts == dstPts && srcOff < dstOff && srcOff + numPts * dimSource > dstOff) {
            step = -dimSource;
            srcOff -= (numPts - 1) * step;
            dstOff -= (numPts - 1) * step;
        }
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            double z = srcPts[srcOff++];
            double W2 = x * x + y * y;
            double W = Math.sqrt(W2);
            double T0 = z * 1.0026;
            double S0 = Math.sqrt(T0 * T0 + W2);
            double sin_B0 = T0 / S0;
            double cos_B0 = W / S0;
            double sin3_B0 = sin_B0 * sin_B0 * sin_B0;
            double T1 = z + this.b * this.ep2 * sin3_B0;
            double sum = W - this.a * this.e2 * (cos_B0 * cos_B0 * cos_B0);
            double S1 = Math.sqrt(T1 * T1 + sum * sum);
            double sin_p1 = T1 / S1;
            double cos_p1 = sum / S1;
            double longitude = Math.toDegrees(Math.atan2(y, x));
            double latitude = Math.toDegrees(Math.atan(sin_p1 / cos_p1));
            dstPts[dstOff++] = (float)longitude;
            dstPts[dstOff++] = (float)latitude;
            if (computeHeight) {
                double distance;
                double rn = this.a / Math.sqrt(1.0 - this.e2 * (sin_p1 * sin_p1));
                double height = cos_p1 >= 0.3826834323650898 ? W / cos_p1 - rn : (cos_p1 <= -0.3826834323650898 ? W / -cos_p1 - rn : z / sin_p1 + rn * (this.e2 - 1.0));
                if (hasHeight) {
                    dstPts[dstOff++] = (float)height;
                }
                if (!$assertionsDisabled && !(0.01 > (distance = this.checkTransform(new double[]{x, y, z, longitude, latitude, height})))) {
                    throw new AssertionError(distance);
                }
            }
            srcOff += step;
            dstOff += step;
        }
    }

    private double checkTransform(double[] points) {
        this.transform(points, 3, points, 3, 1, true);
        double dx = points[0] - points[3];
        double dy = points[1] - points[4];
        double dz = points[2] - points[5];
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public int getDimSource() {
        return this.hasHeight ? 3 : 2;
    }

    public final int getDimTarget() {
        return 3;
    }

    public synchronized MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    public final int hashCode() {
        long code = Double.doubleToLongBits(this.a) + 37L * (Double.doubleToLongBits(this.b) + 37L * (Double.doubleToLongBits(this.a2) + 37L * (Double.doubleToLongBits(this.b2) + 37L * (Double.doubleToLongBits(this.e2) + 37L * Double.doubleToLongBits(this.ep2)))));
        return (int)code ^ (int)(code >>> 32);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            GeocentricTransform that = (GeocentricTransform)object;
            return Double.doubleToLongBits(this.a) == Double.doubleToLongBits(that.a) && Double.doubleToLongBits(this.b) == Double.doubleToLongBits(that.b) && Double.doubleToLongBits(this.a2) == Double.doubleToLongBits(that.a2) && Double.doubleToLongBits(this.b2) == Double.doubleToLongBits(that.b2) && Double.doubleToLongBits(this.e2) == Double.doubleToLongBits(that.e2) && Double.doubleToLongBits(this.ep2) == Double.doubleToLongBits(that.ep2) && this.hasHeight == that.hasHeight;
        }
        return false;
    }

    public final String toString() {
        return this.toString("Ellipsoid_To_Geocentric");
    }

    final String toString(String classification) {
        StringBuffer buffer = GeocentricTransform.paramMT(classification);
        GeocentricTransform.addParameter(buffer, "semi_major", this.a);
        GeocentricTransform.addParameter(buffer, "semi_minor", this.b);
        buffer.append(']');
        return buffer.toString();
    }

    static {
        $assertionsDisabled = !GeocentricTransform.class.desiredAssertionStatus();
    }

    static final class Provider
    extends MathTransformProvider {
        private final boolean inverse;

        public Provider(boolean inverse) {
            super(inverse ? "Geocentric_To_Ellipsoid" : "Ellipsoid_To_Geocentric", 84, null);
            this.put("semi_major", Double.NaN, POSITIVE_RANGE);
            this.put("semi_minor", Double.NaN, POSITIVE_RANGE);
            this.putInt("dim_geoCS", 3, AbridgedMolodenskiTransform.Provider.DIM_RANGE);
            this.inverse = inverse;
        }

        public MathTransform create(ParameterList parameters) {
            double semiMajor = parameters.getDoubleParameter("semi_major");
            double semiMinor = parameters.getDoubleParameter("semi_minor");
            int dimGeographic = 3;
            try {
                dimGeographic = parameters.getIntParameter("dim_geoCS");
            }
            catch (IllegalArgumentException exception) {
                // empty catch block
            }
            GeocentricTransform transform = new GeocentricTransform(semiMajor, semiMinor, Unit.METRE, dimGeographic != 2);
            return this.inverse ? transform.inverse() : transform;
        }
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = 6942084702259211803L;

        public void transform(double[] source, int srcOffset, double[] dest, int dstOffset, int length) throws TransformException {
            GeocentricTransform.this.inverseTransform(source, srcOffset, dest, dstOffset, length);
        }

        public void transform(float[] source, int srcOffset, float[] dest, int dstOffset, int length) throws TransformException {
            GeocentricTransform.this.inverseTransform(source, srcOffset, dest, dstOffset, length);
        }

        public final String toString() {
            return GeocentricTransform.this.toString("Geocentric_To_Ellipsoid");
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            GeocentricTransform.this.inverse = this;
        }
    }
}

