/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.io.Serializable;
import javax.media.jai.ParameterList;
import javax.media.jai.util.Range;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.LinearTransform;
import org.geotools.ct.LinearTransform1D;
import org.geotools.ct.LogarithmicTransform1D;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransform1D;
import org.geotools.ct.MathTransformProvider;

final class ExponentialTransform1D
extends AbstractMathTransform
implements MathTransform1D,
Serializable {
    private static final long serialVersionUID = -6793025722241238043L;
    public final double base;
    final double lnBase;
    public final double scale;
    private transient MathTransform inverse;
    static /* synthetic */ Class class$java$lang$Integer;

    ExponentialTransform1D(LogarithmicTransform1D inverse) {
        this.base = inverse.base;
        this.lnBase = inverse.lnBase;
        this.scale = Math.pow(this.base, -inverse.offset);
        this.inverse = inverse;
    }

    protected ExponentialTransform1D(double base, double scale) {
        this.base = base;
        this.scale = scale;
        this.lnBase = Math.log(base);
    }

    public static MathTransform1D create(double base, double scale) {
        if (base == 0.0 || scale == 0.0) {
            return LinearTransform1D.create(0.0, 0.0);
        }
        if (base == 1.0) {
            return LinearTransform1D.create(0.0, scale);
        }
        return new ExponentialTransform1D(base, scale);
    }

    public int getDimSource() {
        return 1;
    }

    public int getDimTarget() {
        return 1;
    }

    public MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new LogarithmicTransform1D(this);
        }
        return this.inverse;
    }

    public double derivative(double value) {
        return this.lnBase * this.transform(value);
    }

    public double transform(double value) {
        return this.scale * Math.pow(this.base, value);
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = (float)(this.scale * Math.pow(this.base, srcPts[srcOff++]));
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = (float)(this.scale * Math.pow(this.base, srcPts[--srcOff]));
            }
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = this.scale * Math.pow(this.base, srcPts[srcOff++]);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = this.scale * Math.pow(this.base, srcPts[--srcOff]);
            }
        }
    }

    MathTransform concatenate(MathTransform other, boolean applyOtherFirst) {
        if (other instanceof LinearTransform) {
            LinearTransform1D linear = (LinearTransform1D)other;
            if (applyOtherFirst) {
                double newBase = Math.pow(this.base, linear.scale);
                double newScale = Math.pow(this.base, linear.offset) * this.scale;
                if (!Double.isNaN(newBase) && !Double.isNaN(newScale)) {
                    return ExponentialTransform1D.create(newBase, newScale);
                }
            } else if (linear.offset == 0.0) {
                return ExponentialTransform1D.create(this.base, this.scale * linear.scale);
            }
        } else if (other instanceof LogarithmicTransform1D) {
            return this.concatenateLog((LogarithmicTransform1D)other, applyOtherFirst);
        }
        return super.concatenate(other, applyOtherFirst);
    }

    MathTransform concatenateLog(LogarithmicTransform1D other, boolean applyOtherFirst) {
        if (applyOtherFirst) {
            double newScale = this.scale * Math.pow(this.base, other.offset);
            double newPower = this.lnBase / other.lnBase;
            if (!Double.isNaN(newScale) && newPower == 1.0) {
                return LinearTransform1D.create(newScale, 0.0);
            }
        } else if (this.scale > 0.0) {
            return LinearTransform1D.create(this.lnBase / other.lnBase, Math.log(this.scale) / other.lnBase + other.offset);
        }
        return null;
    }

    public int hashCode() {
        long code = 16427632L + Double.doubleToLongBits(this.base);
        code = code * 37L + Double.doubleToLongBits(this.scale);
        return (int)(code >>> 32) ^ (int)code;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ExponentialTransform1D that = (ExponentialTransform1D)object;
            return Double.doubleToLongBits(this.base) == Double.doubleToLongBits(that.base) && Double.doubleToLongBits(this.scale) == Double.doubleToLongBits(that.scale);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = ExponentialTransform1D.paramMT("Exponential");
        ExponentialTransform1D.addParameter(buffer, "base", this.base);
        if (this.scale != 1.0) {
            ExponentialTransform1D.addParameter(buffer, "scale", this.scale);
        }
        buffer.append(']');
        return buffer.toString();
    }

    static final class Provider
    extends MathTransformProvider {
        private static final Range DIMENSION_RANGE;
        private final boolean logarithm;

        public Provider(boolean logarithm) {
            super(logarithm ? "Logarithmic" : "Exponential", logarithm ? 81 : 80, null);
            this.logarithm = logarithm;
            this.put("base", 10.0, POSITIVE_RANGE);
            this.putInt("dimension", 1, DIMENSION_RANGE);
        }

        public MathTransform create(ParameterList parameters) {
            double base = parameters.getDoubleParameter("base");
            int dimension = parameters.getIntParameter("dimension");
            if (dimension == 1) {
                if (this.logarithm) {
                    return new LogarithmicTransform1D(base, 0.0);
                }
                return ExponentialTransform1D.create(base, 1.0);
            }
            throw new UnsupportedOperationException("Only 1D transforms are currently supported.");
        }

        static {
            Integer ONE = new Integer(1);
            DIMENSION_RANGE = new Range(class$java$lang$Integer == null ? (class$java$lang$Integer = ExponentialTransform1D.class$("java.lang.Integer")) : class$java$lang$Integer, (Comparable)ONE, true, (Comparable)ONE, true);
        }
    }
}

