/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import javax.media.jai.IntegerSequence;
import javax.media.jai.ParameterList;
import javax.vecmath.SingularMatrixException;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.AxisOrientation;
import org.geotools.cs.CompoundCoordinateSystem;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.Ellipsoid;
import org.geotools.cs.FactoryException;
import org.geotools.cs.FittedCoordinateSystem;
import org.geotools.cs.GeocentricCoordinateSystem;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.HorizontalCoordinateSystem;
import org.geotools.cs.HorizontalDatum;
import org.geotools.cs.PrimeMeridian;
import org.geotools.cs.ProjectedCoordinateSystem;
import org.geotools.cs.Projection;
import org.geotools.cs.TemporalCoordinateSystem;
import org.geotools.cs.VerticalCoordinateSystem;
import org.geotools.cs.WGS84ConversionInfo;
import org.geotools.ct.Adapters;
import org.geotools.ct.CannotCreateTransformException;
import org.geotools.ct.CoordinateTransformation;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransformFactory;
import org.geotools.ct.NoSuchClassificationException;
import org.geotools.ct.NoninvertibleTransformException;
import org.geotools.ct.TransformType;
import org.geotools.pt.Dimensioned;
import org.geotools.pt.Matrix;
import org.geotools.resources.CTSUtilities;
import org.geotools.resources.JAIUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.geotools.units.UnitException;
import org.opengis.cs.CS_CoordinateSystem;
import org.opengis.ct.CT_CoordinateTransformation;
import org.opengis.ct.CT_CoordinateTransformationFactory;

public class CoordinateTransformationFactory {
    private static CoordinateTransformationFactory DEFAULT;
    private static volatile int temporaryID;
    private final MathTransformFactory factory;
    private transient Object proxy;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CoordinateTransformationFactory(MathTransformFactory factory) {
        this.factory = factory;
    }

    public static synchronized CoordinateTransformationFactory getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new CoordinateTransformationFactory(MathTransformFactory.getDefault());
        }
        return DEFAULT;
    }

    public final MathTransformFactory getMathTransformFactory() {
        return this.factory;
    }

    public CoordinateTransformation createFromCoordinateSystems(CoordinateSystem sourceCS, CoordinateSystem targetCS) throws CannotCreateTransformException {
        return this.createFromCoordinateSystems(sourceCS, targetCS, true);
    }

    private CoordinateTransformation createFromCoordinateSystems(CoordinateSystem sourceCS, CoordinateSystem targetCS, boolean splitHVCS) throws CannotCreateTransformException {
        VerticalCoordinateSystem vCS;
        HorizontalCoordinateSystem hCS;
        CoordinateSystem source;
        if (sourceCS.equals(targetCS, false)) {
            int dim = sourceCS.getDimension();
            if (!$assertionsDisabled && dim != targetCS.getDimension()) {
                throw new AssertionError(dim);
            }
            return CoordinateTransformationFactory.createFromMathTransform(sourceCS, targetCS, this.factory.createIdentityTransform(dim));
        }
        if (sourceCS instanceof FittedCoordinateSystem) {
            FittedCoordinateSystem source2 = (FittedCoordinateSystem)sourceCS;
            CoordinateSystem base = source2.getBaseCoordinateSystem();
            CoordinateTransformation step1 = CoordinateTransformationFactory.createFromMathTransform(sourceCS, base, source2.getToBase());
            CoordinateTransformation step2 = this.createFromCoordinateSystems(base, targetCS);
            return this.concatenate(step1, step2);
        }
        if (targetCS instanceof FittedCoordinateSystem) {
            CoordinateTransformation step2;
            CoordinateTransformation step1;
            FittedCoordinateSystem target = (FittedCoordinateSystem)targetCS;
            CoordinateSystem base = target.getBaseCoordinateSystem();
            try {
                step1 = this.createFromCoordinateSystems(sourceCS, base);
                step2 = CoordinateTransformationFactory.createFromMathTransform(base, targetCS, target.getToBase().inverse());
            }
            catch (NoninvertibleTransformException exception) {
                throw new CannotCreateTransformException(sourceCS, targetCS, exception);
            }
            return this.concatenate(step1, step2);
        }
        if (sourceCS instanceof GeographicCoordinateSystem) {
            source = (GeographicCoordinateSystem)sourceCS;
            if (targetCS instanceof GeographicCoordinateSystem) {
                return this.createTransformationStep((GeographicCoordinateSystem)source, null, (GeographicCoordinateSystem)targetCS, null);
            }
            if (targetCS instanceof ProjectedCoordinateSystem) {
                return this.createTransformationStep((GeographicCoordinateSystem)source, null, (ProjectedCoordinateSystem)targetCS, null);
            }
            if (targetCS instanceof GeocentricCoordinateSystem) {
                return this.createTransformationStep((GeographicCoordinateSystem)source, null, (GeocentricCoordinateSystem)targetCS);
            }
        }
        if (sourceCS instanceof ProjectedCoordinateSystem) {
            source = (ProjectedCoordinateSystem)sourceCS;
            if (targetCS instanceof ProjectedCoordinateSystem) {
                return this.createTransformationStep((ProjectedCoordinateSystem)source, null, (ProjectedCoordinateSystem)targetCS, null);
            }
            if (targetCS instanceof GeographicCoordinateSystem) {
                return this.createTransformationStep((ProjectedCoordinateSystem)source, null, (GeographicCoordinateSystem)targetCS, null);
            }
            if (targetCS instanceof GeocentricCoordinateSystem) {
                return this.createTransformationStep((ProjectedCoordinateSystem)source, null, (GeocentricCoordinateSystem)targetCS);
            }
        }
        if (sourceCS instanceof GeocentricCoordinateSystem) {
            source = (GeocentricCoordinateSystem)sourceCS;
            if (targetCS instanceof GeocentricCoordinateSystem) {
                return this.createTransformationStep((GeocentricCoordinateSystem)source, (GeocentricCoordinateSystem)targetCS);
            }
            hCS = CTSUtilities.getHorizontalCS(targetCS);
            vCS = CTSUtilities.getVerticalCS(targetCS);
            if (hCS instanceof GeographicCoordinateSystem) {
                return this.concatenate(null, this.createTransformationStep((GeocentricCoordinateSystem)source, (GeographicCoordinateSystem)hCS, vCS), targetCS);
            }
            if (hCS instanceof ProjectedCoordinateSystem) {
                return this.concatenate(null, this.createTransformationStep((GeocentricCoordinateSystem)source, (ProjectedCoordinateSystem)hCS, vCS), targetCS);
            }
        }
        if (sourceCS instanceof VerticalCoordinateSystem) {
            source = (VerticalCoordinateSystem)sourceCS;
            if (targetCS instanceof VerticalCoordinateSystem) {
                return this.createTransformationStep((VerticalCoordinateSystem)source, (VerticalCoordinateSystem)targetCS);
            }
        }
        if (sourceCS instanceof TemporalCoordinateSystem) {
            source = (TemporalCoordinateSystem)sourceCS;
            if (targetCS instanceof TemporalCoordinateSystem) {
                return this.createTransformationStep((TemporalCoordinateSystem)source, (TemporalCoordinateSystem)targetCS);
            }
        }
        if (splitHVCS) {
            CoordinateTransformation step = null;
            HorizontalCoordinateSystem sourceHCS = CTSUtilities.getHorizontalCS(sourceCS);
            VerticalCoordinateSystem sourceVCS = CTSUtilities.getVerticalCS(sourceCS);
            HorizontalCoordinateSystem targetHCS = CTSUtilities.getHorizontalCS(targetCS);
            VerticalCoordinateSystem targetVCS = CTSUtilities.getVerticalCS(targetCS);
            if (CoordinateTransformationFactory.getDimension(sourceHCS) + CoordinateTransformationFactory.getDimension(sourceVCS) == CoordinateTransformationFactory.getDimension(sourceCS) && CoordinateTransformationFactory.getDimension(targetHCS) + CoordinateTransformationFactory.getDimension(targetVCS) == CoordinateTransformationFactory.getDimension(targetCS)) {
                ProjectedCoordinateSystem targetPCS;
                GeographicCoordinateSystem targetGCS;
                if (sourceHCS instanceof GeographicCoordinateSystem) {
                    GeographicCoordinateSystem sourceGCS = (GeographicCoordinateSystem)sourceHCS;
                    if (targetHCS instanceof GeographicCoordinateSystem) {
                        targetGCS = (GeographicCoordinateSystem)targetHCS;
                        step = this.createTransformationStep(sourceGCS, sourceVCS, targetGCS, targetVCS);
                    } else if (targetHCS instanceof ProjectedCoordinateSystem) {
                        targetPCS = (ProjectedCoordinateSystem)targetHCS;
                        step = this.createTransformationStep(sourceGCS, sourceVCS, targetPCS, targetVCS);
                    }
                } else if (sourceHCS instanceof ProjectedCoordinateSystem) {
                    ProjectedCoordinateSystem sourcePCS = (ProjectedCoordinateSystem)sourceHCS;
                    if (targetHCS instanceof GeographicCoordinateSystem) {
                        targetGCS = (GeographicCoordinateSystem)targetHCS;
                        step = this.createTransformationStep(sourcePCS, sourceVCS, targetGCS, targetVCS);
                    } else if (targetHCS instanceof ProjectedCoordinateSystem) {
                        targetPCS = (ProjectedCoordinateSystem)targetHCS;
                        step = this.createTransformationStep(sourcePCS, sourceVCS, targetPCS, targetVCS);
                    }
                }
            }
            if (step != null) {
                return this.concatenate(sourceCS, step, targetCS);
            }
        }
        if (sourceCS instanceof CompoundCoordinateSystem) {
            CoordinateTransformation step2;
            int upper;
            int lower;
            if (targetCS instanceof GeocentricCoordinateSystem) {
                GeocentricCoordinateSystem target = (GeocentricCoordinateSystem)targetCS;
                hCS = CTSUtilities.getHorizontalCS(sourceCS);
                vCS = CTSUtilities.getVerticalCS(sourceCS);
                if (hCS instanceof GeographicCoordinateSystem) {
                    return this.concatenate(sourceCS, this.createTransformationStep((GeographicCoordinateSystem)hCS, vCS, target), null);
                }
                if (hCS instanceof ProjectedCoordinateSystem) {
                    return this.concatenate(sourceCS, this.createTransformationStep((ProjectedCoordinateSystem)hCS, vCS, target), null);
                }
            }
            source = (CompoundCoordinateSystem)sourceCS;
            if (targetCS instanceof CompoundCoordinateSystem) {
                return this.createTransformationStep((CompoundCoordinateSystem)source, (CompoundCoordinateSystem)targetCS);
            }
            CoordinateSystem headSourceCS = ((CompoundCoordinateSystem)source).getHeadCS();
            CoordinateSystem tailSourceCS = ((CompoundCoordinateSystem)source).getTailCS();
            int dimHeadCS = headSourceCS.getDimension();
            int dimSource = ((CompoundCoordinateSystem)source).getDimension();
            if (!$assertionsDisabled && dimHeadCS >= dimSource) {
                throw new AssertionError(dimHeadCS);
            }
            try {
                lower = 0;
                upper = dimHeadCS;
                step2 = this.createFromCoordinateSystems(headSourceCS, targetCS);
            }
            catch (CannotCreateTransformException exception) {
                try {
                    lower = dimHeadCS;
                    upper = dimSource;
                    step2 = this.createFromCoordinateSystems(tailSourceCS, targetCS);
                }
                catch (CannotCreateTransformException ignore) {
                    CannotCreateTransformException e = new CannotCreateTransformException(sourceCS, targetCS);
                    e.initCause(exception);
                    throw e;
                }
            }
            MathTransform step = this.factory.createIdentityTransform(dimSource);
            step = this.factory.createFilterTransform(step, JAIUtilities.createSequence(lower, upper - 1));
            step = this.factory.createConcatenatedTransform(step, step2.getMathTransform());
            return CoordinateTransformationFactory.createFromMathTransform(sourceCS, targetCS, step, step2.getTransformType());
        }
        throw new CannotCreateTransformException(sourceCS, targetCS);
    }

    private static CoordinateSystem compound(CoordinateSystem head, CoordinateSystem tail) {
        if (head == null) {
            return tail;
        }
        if (tail == null) {
            return head;
        }
        return new CompoundCoordinateSystem(CoordinateTransformationFactory.getTemporaryName(head), head, tail);
    }

    private CoordinateTransformation concatenate(CoordinateTransformation step1, CoordinateTransformation step2) {
        if (step1 == null) {
            return step2;
        }
        if (step2 == null) {
            return step1;
        }
        if (!$assertionsDisabled && !step1.getTargetCS().equals(step2.getSourceCS(), false)) {
            throw new AssertionError((Object)("CS1=" + step1.getTargetCS() + '\n' + "CS2=" + step2.getSourceCS()));
        }
        MathTransform mt1 = step1.getMathTransform();
        if (mt1.isIdentity() && step1.getSourceCS().equals(step2.getSourceCS(), false)) {
            return step2;
        }
        MathTransform mt2 = step2.getMathTransform();
        if (mt2.isIdentity() && step1.getTargetCS().equals(step2.getTargetCS(), false)) {
            return step1;
        }
        MathTransform step = this.factory.createConcatenatedTransform(mt1, mt2);
        TransformType type = step1.getTransformType().concatenate(step2.getTransformType());
        return CoordinateTransformationFactory.createFromMathTransform(step1.getSourceCS(), step2.getTargetCS(), step, type);
    }

    private CoordinateTransformation concatenate(CoordinateTransformation step1, CoordinateTransformation step2, CoordinateTransformation step3) {
        if (step1 == null) {
            return this.concatenate(step2, step3);
        }
        if (step2 == null) {
            return this.concatenate(step1, step3);
        }
        if (step3 == null) {
            return this.concatenate(step1, step2);
        }
        if (!$assertionsDisabled && !step1.getTargetCS().equals(step2.getSourceCS(), false)) {
            throw new AssertionError(step1);
        }
        if (!$assertionsDisabled && !step2.getTargetCS().equals(step3.getSourceCS(), false)) {
            throw new AssertionError(step3);
        }
        MathTransform mt1 = step1.getMathTransform();
        if (mt1.isIdentity() && step1.getSourceCS().equals(step2.getSourceCS(), false)) {
            return this.concatenate(step2, step3);
        }
        MathTransform mt2 = step2.getMathTransform();
        if (mt2.isIdentity()) {
            return this.concatenate(step1, step3);
        }
        MathTransform mt3 = step3.getMathTransform();
        if (mt3.isIdentity() && step2.getTargetCS().equals(step3.getTargetCS(), false)) {
            return this.concatenate(step1, step2);
        }
        MathTransform step = this.factory.createConcatenatedTransform(mt1, this.factory.createConcatenatedTransform(mt2, mt3));
        TransformType type = step1.getTransformType().concatenate(step2.getTransformType().concatenate(step3.getTransformType()));
        return CoordinateTransformationFactory.createFromMathTransform(step1.getSourceCS(), step3.getTargetCS(), step, type);
    }

    private CoordinateTransformation concatenate(CoordinateSystem sourceCS, CoordinateTransformation transform, CoordinateSystem targetCS) throws CannotCreateTransformException {
        CoordinateTransformation step1 = sourceCS != null ? this.createFromCoordinateSystems(sourceCS, transform.getSourceCS(), false) : null;
        CoordinateTransformation step3 = targetCS != null ? this.createFromCoordinateSystems(transform.getTargetCS(), targetCS, false) : null;
        return this.concatenate(step1, transform, step3);
    }

    private static CoordinateTransformation createFromMathTransform(CoordinateSystem sourceCS, CoordinateSystem targetCS, MathTransform transform, TransformType type) {
        CoordinateTransformation ct;
        if (transform instanceof CoordinateTransformation && Utilities.equals((Object)(ct = (CoordinateTransformation)((Object)transform)).getSourceCS(), (Object)sourceCS) && Utilities.equals((Object)ct.getTargetCS(), (Object)targetCS)) {
            return ct;
        }
        return (CoordinateTransformation)MathTransformFactory.pool.canonicalize((Object)new CoordinateTransformation(null, sourceCS, targetCS, type, transform));
    }

    private static CoordinateTransformation createFromMathTransform(CoordinateSystem sourceCS, CoordinateSystem targetCS, MathTransform transform) {
        return CoordinateTransformationFactory.createFromMathTransform(sourceCS, targetCS, transform, TransformType.CONVERSION);
    }

    private static boolean hasStandardAxis(HorizontalCoordinateSystem cs, Unit unit) {
        return cs.getDimension() == 2 && unit.equals((Object)cs.getUnits(0)) && unit.equals((Object)cs.getUnits(1)) && AxisOrientation.EAST.equals(cs.getAxis((int)0).orientation) && AxisOrientation.NORTH.equals(cs.getAxis((int)1).orientation);
    }

    private static AxisOrientation[] getAxisOrientations(CoordinateSystem cs, Dimensioned dimension) {
        AxisOrientation[] axis;
        if (cs != null) {
            axis = new AxisOrientation[cs.getDimension()];
            for (int i = 0; i < axis.length; ++i) {
                axis[i] = cs.getAxis((int)i).orientation;
            }
        } else {
            axis = new AxisOrientation[dimension.getDimension()];
            switch (axis.length) {
                default: {
                    int i = axis.length;
                    while (--i >= 4) {
                        axis[i] = AxisOrientation.OTHER;
                    }
                }
                case 4: {
                    axis[3] = AxisOrientation.FUTURE;
                }
                case 3: {
                    axis[2] = AxisOrientation.UP;
                }
                case 2: {
                    axis[1] = AxisOrientation.NORTH;
                }
                case 1: {
                    axis[0] = AxisOrientation.EAST;
                }
                case 0: 
            }
        }
        if (!$assertionsDisabled && axis.length != dimension.getDimension()) {
            throw new AssertionError(dimension);
        }
        return axis;
    }

    private Matrix swapAndScaleAxis(CoordinateSystem sourceCS, CoordinateSystem targetCS) throws CannotCreateTransformException {
        Matrix matrix;
        Object[] sourceAxis = CoordinateTransformationFactory.getAxisOrientations(sourceCS, targetCS);
        Object[] targetAxis = CoordinateTransformationFactory.getAxisOrientations(targetCS, sourceCS);
        try {
            matrix = Matrix.createAffineTransform((AxisOrientation[])sourceAxis, (AxisOrientation[])targetAxis);
        }
        catch (RuntimeException exception) {
            CannotCreateTransformException e = new CannotCreateTransformException(sourceCS, targetCS);
            e.initCause(exception);
            throw e;
        }
        if (!$assertionsDisabled && Arrays.equals(sourceAxis, targetAxis) != matrix.isIdentity()) {
            throw new AssertionError((Object)matrix);
        }
        int sourceDim = matrix.getNumCol() - 1;
        int targetDim = matrix.getNumRow() - 1;
        if (!$assertionsDisabled && sourceDim != sourceCS.getDimension()) {
            throw new AssertionError(sourceCS);
        }
        if (!$assertionsDisabled && targetDim != targetCS.getDimension()) {
            throw new AssertionError(targetCS);
        }
        for (int j = 0; j < targetDim; ++j) {
            Unit targetUnit = targetCS.getUnits(j);
            for (int i = 0; i < sourceDim; ++i) {
                Unit sourceUnit;
                double element = matrix.getElement(j, i);
                if (element == 0.0 || Utilities.equals((Object)(sourceUnit = sourceCS.getUnits(i)), (Object)targetUnit)) continue;
                if (sourceUnit == Unit.DMS || targetUnit == Unit.DMS) {
                    throw new UnitException("Not implemented");
                }
                double offset = targetUnit.convert(0.0, sourceUnit);
                double scale = targetUnit.convert(1.0, sourceUnit) - offset;
                matrix.setElement(j, i, scale * element);
                matrix.setElement(j, sourceDim, matrix.getElement(j, sourceDim) + element * offset);
            }
        }
        return matrix;
    }

    private Matrix swapAndScaleGeoAxis(GeographicCoordinateSystem sourceCS, GeographicCoordinateSystem targetCS) throws CannotCreateTransformException {
        Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS);
        int i = targetCS.getDimension();
        while (--i >= 0) {
            AxisOrientation orientation = targetCS.getAxis((int)i).orientation;
            if (!AxisOrientation.EAST.equals(orientation.absolute())) continue;
            Unit unit = targetCS.getUnits(i);
            double sourceLongitude = sourceCS.getPrimeMeridian().getLongitude(unit);
            double targetLongitude = targetCS.getPrimeMeridian().getLongitude(unit);
            int lastMatrixColumn = matrix.getNumCol() - 1;
            double rotate = sourceLongitude - targetLongitude;
            if (AxisOrientation.WEST.equals(orientation)) {
                rotate = -rotate;
            }
            matrix.setElement(i, lastMatrixColumn, rotate += matrix.getElement(i, lastMatrixColumn));
        }
        return matrix;
    }

    protected CoordinateTransformation createTransformationStep(TemporalCoordinateSystem sourceCS, TemporalCoordinateSystem targetCS) throws CannotCreateTransformException {
        if (!sourceCS.getTemporalDatum().equals(targetCS.getTemporalDatum(), false)) {
            throw new CannotCreateTransformException(sourceCS, targetCS);
        }
        double epochShift = sourceCS.getEpoch().getTime() - targetCS.getEpoch().getTime();
        epochShift = targetCS.getUnits(0).convert(epochShift / 8.64E7, Unit.DAY);
        Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS);
        int translationColumn = matrix.getNumCol() - 1;
        if (translationColumn >= 0) {
            double translation = matrix.getElement(0, translationColumn);
            matrix.setElement(0, translationColumn, translation + epochShift);
        }
        MathTransform transform = this.factory.createAffineTransform(matrix);
        return CoordinateTransformationFactory.createFromMathTransform(sourceCS, targetCS, transform);
    }

    protected CoordinateTransformation createTransformationStep(VerticalCoordinateSystem sourceCS, VerticalCoordinateSystem targetCS) throws CannotCreateTransformException {
        if (!sourceCS.getVerticalDatum().equals(targetCS.getVerticalDatum(), false)) {
            throw new CannotCreateTransformException(sourceCS, targetCS);
        }
        Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS);
        MathTransform transform = this.factory.createAffineTransform(matrix);
        return CoordinateTransformationFactory.createFromMathTransform(sourceCS, targetCS, transform);
    }

    private CoordinateTransformation createCompoundStep(CoordinateTransformation transform, CoordinateSystem sourceCS, CoordinateSystem targetCS) throws CannotCreateTransformException {
        TransformType type;
        MathTransform step;
        if (sourceCS == null) {
            if (targetCS != null) {
                throw new CannotCreateTransformException(transform.getSourceCS(), targetCS);
            }
            return transform;
        }
        CoordinateSystem sourceCCS = CoordinateTransformationFactory.compound(transform.getSourceCS(), sourceCS);
        CoordinateSystem targetCCS = CoordinateTransformationFactory.compound(transform.getTargetCS(), targetCS);
        if (targetCS == null) {
            IntegerSequence outDim = JAIUtilities.createSequence(0, targetCCS.getDimension() - 1);
            step = this.factory.createIdentityTransform(sourceCCS.getDimension());
            step = this.factory.createFilterTransform(step, outDim);
            step = this.factory.createConcatenatedTransform(step, transform.getMathTransform());
            type = transform.getTransformType();
        } else {
            CoordinateTransformation toAppend = this.createFromCoordinateSystems(sourceCS, targetCS);
            MathTransform transform1 = transform.getMathTransform();
            MathTransform transform2 = toAppend.getMathTransform();
            step = this.factory.createConcatenatedTransform(this.factory.createPassThroughTransform(0, transform1, transform2.getDimSource()), this.factory.createPassThroughTransform(transform1.getDimTarget(), transform2, 0));
            type = transform.getTransformType().concatenate(toAppend.getTransformType());
        }
        return CoordinateTransformationFactory.createFromMathTransform(sourceCCS, targetCCS, step, type);
    }

    protected CoordinateTransformation createTransformationStep(GeographicCoordinateSystem sourceCS, VerticalCoordinateSystem sourceVCS, GeographicCoordinateSystem targetCS, VerticalCoordinateSystem targetVCS) throws CannotCreateTransformException {
        HorizontalDatum targetDatum;
        HorizontalDatum sourceDatum = sourceCS.getHorizontalDatum();
        if (sourceDatum.equals(targetDatum = targetCS.getHorizontalDatum(), false)) {
            Matrix matrix = this.swapAndScaleGeoAxis(sourceCS, targetCS);
            MathTransform transform = this.factory.createAffineTransform(matrix);
            CoordinateTransformation horizontalStep = CoordinateTransformationFactory.createFromMathTransform(sourceCS, targetCS, transform);
            return this.createCompoundStep(horizontalStep, sourceVCS, targetVCS);
        }
        String name = CoordinateTransformationFactory.getTemporaryName(sourceCS);
        GeocentricCoordinateSystem gcs1 = new GeocentricCoordinateSystem(name, sourceDatum);
        GeocentricCoordinateSystem gcs3 = new GeocentricCoordinateSystem(name, targetDatum);
        CoordinateTransformation step1 = this.createTransformationStep(sourceCS, sourceVCS, gcs1);
        CoordinateTransformation step2 = this.createTransformationStep(gcs1, gcs3);
        CoordinateTransformation step3 = this.createTransformationStep(gcs3, targetCS, targetVCS);
        return this.concatenate(step1, step2, step3);
    }

    protected CoordinateTransformation createTransformationStep(ProjectedCoordinateSystem sourceCS, VerticalCoordinateSystem sourceVCS, ProjectedCoordinateSystem targetCS, VerticalCoordinateSystem targetVCS) throws CannotCreateTransformException {
        if (sourceCS.getProjection().equals(targetCS.getProjection(), false) && sourceCS.getHorizontalDatum().equals(targetCS.getHorizontalDatum(), false) && sourceCS.getGeographicCoordinateSystem().getPrimeMeridian().equals(targetCS.getGeographicCoordinateSystem().getPrimeMeridian(), false)) {
            Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS);
            MathTransform transform = this.factory.createAffineTransform(matrix);
            CoordinateTransformation horizontalStep = CoordinateTransformationFactory.createFromMathTransform(sourceCS, targetCS, transform);
            return this.createCompoundStep(horizontalStep, sourceVCS, targetVCS);
        }
        GeographicCoordinateSystem sourceGeo = sourceCS.getGeographicCoordinateSystem();
        GeographicCoordinateSystem targetGeo = targetCS.getGeographicCoordinateSystem();
        CoordinateTransformation step1 = this.createTransformationStep(sourceCS, sourceVCS, sourceGeo, sourceVCS);
        CoordinateTransformation step2 = this.createTransformationStep(sourceGeo, sourceVCS, targetGeo, targetVCS);
        CoordinateTransformation step3 = this.createTransformationStep(targetGeo, targetVCS, targetCS, targetVCS);
        return this.concatenate(step1, step2, step3);
    }

    private static GeographicCoordinateSystem normalize(GeographicCoordinateSystem cs, PrimeMeridian meridian, Projection projection) {
        HorizontalDatum datum = cs.getHorizontalDatum();
        String name = null;
        if (projection != null) {
            Ellipsoid ellipsoid = datum.getEllipsoid();
            double semiMajorEll = ellipsoid.getSemiMajorAxis();
            double semiMinorEll = ellipsoid.getSemiMinorAxis();
            double semiMajorPrj = projection.getValue("semi_major", semiMajorEll);
            double semiMinorPrj = projection.getValue("semi_minor", semiMinorEll);
            if (semiMajorEll != semiMajorPrj || semiMinorEll != semiMinorPrj) {
                name = CoordinateTransformationFactory.getTemporaryName(cs);
                ellipsoid = Ellipsoid.createEllipsoid(name, semiMajorPrj, semiMinorPrj, Unit.METRE);
                datum = new HorizontalDatum((CharSequence)name, ellipsoid);
                cs = null;
            }
        }
        if (cs == null || !CoordinateTransformationFactory.hasStandardAxis(cs, Unit.DEGREE) || !meridian.equals(cs.getPrimeMeridian(), false)) {
            if (name == null) {
                name = CoordinateTransformationFactory.getTemporaryName(cs);
            }
            cs = new GeographicCoordinateSystem(name, Unit.DEGREE, datum, meridian, AxisInfo.LONGITUDE, AxisInfo.LATITUDE);
        }
        return cs;
    }

    private static ProjectedCoordinateSystem normalize(ProjectedCoordinateSystem cs) {
        Projection projection = cs.getProjection();
        GeographicCoordinateSystem geoCS = cs.getGeographicCoordinateSystem();
        PrimeMeridian meridian = geoCS.getPrimeMeridian();
        GeographicCoordinateSystem normalizedGeoCS = CoordinateTransformationFactory.normalize(geoCS, meridian, projection);
        if (!$assertionsDisabled && CoordinateTransformationFactory.normalize(normalizedGeoCS, meridian, projection) != normalizedGeoCS) {
            throw new AssertionError(normalizedGeoCS);
        }
        if (normalizedGeoCS == geoCS && CoordinateTransformationFactory.hasStandardAxis(cs, Unit.METRE)) {
            return cs;
        }
        String name = CoordinateTransformationFactory.getTemporaryName(cs, normalizedGeoCS);
        return new ProjectedCoordinateSystem(name, normalizedGeoCS, projection);
    }

    protected CoordinateTransformation createTransformationStep(GeographicCoordinateSystem sourceCS, VerticalCoordinateSystem sourceVCS, ProjectedCoordinateSystem targetCS, VerticalCoordinateSystem targetVCS) throws CannotCreateTransformException {
        MathTransform mapProjection;
        ProjectedCoordinateSystem stepProjCS = CoordinateTransformationFactory.normalize(targetCS);
        GeographicCoordinateSystem stepGeoCS = stepProjCS.getGeographicCoordinateSystem();
        Projection projection = stepProjCS.getProjection();
        if (!$assertionsDisabled && CoordinateTransformationFactory.normalize(stepProjCS) != stepProjCS) {
            throw new AssertionError(stepProjCS);
        }
        if (!$assertionsDisabled && CoordinateTransformationFactory.normalize(stepGeoCS, stepGeoCS.getPrimeMeridian(), projection) != stepGeoCS) {
            throw new AssertionError(stepGeoCS);
        }
        if (!$assertionsDisabled && !projection.equals(targetCS.getProjection(), false)) {
            throw new AssertionError(projection);
        }
        try {
            mapProjection = this.factory.createParameterizedTransform(projection);
        }
        catch (FactoryException exception) {
            throw new CannotCreateTransformException(sourceCS, targetCS, exception);
        }
        CoordinateTransformation step1 = this.createTransformationStep(sourceCS, sourceVCS, stepGeoCS, targetVCS);
        CoordinateTransformation step3 = this.createTransformationStep(stepProjCS, targetVCS, targetCS, targetVCS);
        int verticalDim = step1.getTargetCS().getDimension() - mapProjection.getDimSource();
        if (!$assertionsDisabled && verticalDim != step3.getSourceCS().getDimension() - mapProjection.getDimTarget()) {
            throw new AssertionError();
        }
        mapProjection = this.factory.createPassThroughTransform(0, mapProjection, verticalDim);
        CoordinateTransformation step2 = CoordinateTransformationFactory.createFromMathTransform(step1.getTargetCS(), step3.getSourceCS(), mapProjection);
        return this.concatenate(step1, step2, step3);
    }

    protected CoordinateTransformation createTransformationStep(ProjectedCoordinateSystem sourceCS, VerticalCoordinateSystem sourceVCS, GeographicCoordinateSystem targetCS, VerticalCoordinateSystem targetVCS) throws CannotCreateTransformException {
        try {
            return this.createTransformationStep(targetCS, targetVCS, sourceCS, sourceVCS).inverse();
        }
        catch (NoninvertibleTransformException exception) {
            throw new CannotCreateTransformException(sourceCS, targetCS, exception);
        }
    }

    protected CoordinateTransformation createTransformationStep(GeocentricCoordinateSystem sourceCS, GeocentricCoordinateSystem targetCS) throws CannotCreateTransformException {
        HorizontalDatum targetHD;
        HorizontalDatum sourceHD = sourceCS.getHorizontalDatum();
        if (sourceHD.equals(targetHD = targetCS.getHorizontalDatum(), false) && sourceCS.getPrimeMeridian().equals(targetCS.getPrimeMeridian(), false)) {
            Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS);
            MathTransform transform = this.factory.createAffineTransform(matrix);
            return CoordinateTransformationFactory.createFromMathTransform(sourceCS, targetCS, transform);
        }
        if (!PrimeMeridian.GREENWICH.equals(sourceCS.getPrimeMeridian()) || !PrimeMeridian.GREENWICH.equals(targetCS.getPrimeMeridian())) {
            throw new CannotCreateTransformException("Rotation of prime meridian not yet implemented");
        }
        Matrix step1 = this.swapAndScaleAxis(sourceCS, GeocentricCoordinateSystem.DEFAULT);
        Matrix step2 = CoordinateTransformationFactory.getWGS84Parameters(sourceHD);
        Matrix step3 = CoordinateTransformationFactory.getWGS84Parameters(targetHD);
        Matrix step4 = this.swapAndScaleAxis(GeocentricCoordinateSystem.DEFAULT, targetCS);
        if (step2 == null || step3 == null) {
            throw new CannotCreateTransformException(Resources.format(4));
        }
        try {
            step3.invert();
            step4.mul(step3);
            step4.mul(step2);
            step4.mul(step1);
        }
        catch (SingularMatrixException exception) {
            throw new CannotCreateTransformException(sourceCS, targetCS, exception);
        }
        MathTransform transform = this.factory.createAffineTransform(step4);
        return CoordinateTransformationFactory.createFromMathTransform(sourceCS, targetCS, transform);
    }

    protected CoordinateTransformation createTransformationStep(GeographicCoordinateSystem sourceCS, VerticalCoordinateSystem verticalCS, GeocentricCoordinateSystem targetCS) throws CannotCreateTransformException {
        MathTransform transform;
        ParameterList param;
        CoordinateTransformation step1;
        GeocentricCoordinateSystem stepCS2;
        block6: {
            HorizontalDatum datum = sourceCS.getHorizontalDatum();
            GeographicCoordinateSystem stepCS1 = CoordinateTransformationFactory.normalize(sourceCS, PrimeMeridian.GREENWICH, null);
            stepCS2 = new GeocentricCoordinateSystem(CoordinateTransformationFactory.getTemporaryName(sourceCS, stepCS1), datum);
            step1 = this.createTransformationStep(sourceCS, verticalCS, stepCS1, verticalCS != null ? VerticalCoordinateSystem.ELLIPSOIDAL : null);
            String classification = "Ellipsoid_To_Geocentric";
            Ellipsoid ellipsoid = datum.getEllipsoid();
            Unit unit = ellipsoid.getAxisUnit();
            int sourceDimension = step1.getTargetCS().getDimension();
            try {
                param = this.factory.getMathTransformProvider("Ellipsoid_To_Geocentric").getParameterList();
            }
            catch (NoSuchClassificationException exception) {
                throw new CannotCreateTransformException(sourceCS, targetCS, exception);
            }
            param = param.setParameter("semi_major", Unit.METRE.convert(ellipsoid.getSemiMajorAxis(), unit));
            param = param.setParameter("semi_minor", Unit.METRE.convert(ellipsoid.getSemiMinorAxis(), unit));
            try {
                param = param.setParameter("dim_geoCS", sourceDimension);
            }
            catch (IllegalArgumentException exception) {
                if (sourceDimension == 3) break block6;
                throw exception;
            }
        }
        try {
            transform = this.factory.createParameterizedTransform("Ellipsoid_To_Geocentric", param);
        }
        catch (FactoryException exception) {
            throw new CannotCreateTransformException(sourceCS, targetCS, exception);
        }
        CoordinateTransformation step2 = CoordinateTransformationFactory.createFromMathTransform(step1.getTargetCS(), stepCS2, transform);
        CoordinateTransformation step3 = this.createTransformationStep(stepCS2, targetCS);
        return this.concatenate(step1, step2, step3);
    }

    protected CoordinateTransformation createTransformationStep(GeocentricCoordinateSystem sourceCS, GeographicCoordinateSystem targetCS, VerticalCoordinateSystem verticalCS) throws CannotCreateTransformException {
        try {
            return this.createTransformationStep(targetCS, verticalCS, sourceCS).inverse();
        }
        catch (NoninvertibleTransformException exception) {
            throw new CannotCreateTransformException(sourceCS, targetCS, exception);
        }
    }

    protected CoordinateTransformation createTransformationStep(ProjectedCoordinateSystem sourceCS, VerticalCoordinateSystem verticalCS, GeocentricCoordinateSystem targetCS) throws CannotCreateTransformException {
        GeographicCoordinateSystem sourceGCS = sourceCS.getGeographicCoordinateSystem();
        CoordinateTransformation step1 = this.createTransformationStep(sourceCS, verticalCS, sourceGCS, verticalCS);
        CoordinateTransformation step2 = this.createTransformationStep(sourceGCS, verticalCS, targetCS);
        return this.concatenate(step1, step2);
    }

    protected CoordinateTransformation createTransformationStep(GeocentricCoordinateSystem sourceCS, ProjectedCoordinateSystem targetCS, VerticalCoordinateSystem verticalCS) throws CannotCreateTransformException {
        GeographicCoordinateSystem targetGCS = targetCS.getGeographicCoordinateSystem();
        CoordinateTransformation step1 = this.createTransformationStep(sourceCS, targetGCS, verticalCS);
        CoordinateTransformation step2 = this.createTransformationStep(targetGCS, verticalCS, targetCS, verticalCS);
        return this.concatenate(step1, step2);
    }

    protected CoordinateTransformation createTransformationStep(CompoundCoordinateSystem sourceCS, CompoundCoordinateSystem targetCS) throws CannotCreateTransformException {
        CoordinateSystem headSourceCS = sourceCS.getHeadCS();
        CoordinateSystem tailSourceCS = sourceCS.getTailCS();
        CoordinateSystem headTargetCS = targetCS.getHeadCS();
        CoordinateSystem tailTargetCS = targetCS.getTailCS();
        if (tailSourceCS.equals(tailTargetCS, false)) {
            CoordinateTransformation tr = this.createFromCoordinateSystems(headSourceCS, headTargetCS);
            MathTransform transform = this.factory.createPassThroughTransform(0, tr.getMathTransform(), tailSourceCS.getDimension());
            return CoordinateTransformationFactory.createFromMathTransform(sourceCS, targetCS, transform, tr.getTransformType());
        }
        if (headSourceCS.equals(headTargetCS, false)) {
            CoordinateTransformation tr = this.createFromCoordinateSystems(tailSourceCS, tailTargetCS);
            MathTransform transform = this.factory.createPassThroughTransform(headSourceCS.getDimension(), tr.getMathTransform(), 0);
            return CoordinateTransformationFactory.createFromMathTransform(sourceCS, targetCS, transform, tr.getTransformType());
        }
        throw new CannotCreateTransformException(sourceCS, targetCS);
    }

    private static Matrix getWGS84Parameters(HorizontalDatum datum) {
        WGS84ConversionInfo info = datum.getWGS84Parameters();
        if (info != null) {
            return info.getAffineTransform();
        }
        if (HorizontalDatum.WGS84.equals(datum, false)) {
            return new Matrix(4);
        }
        return null;
    }

    private static int getDimension(CoordinateSystem cs) {
        return cs != null ? cs.getDimension() : 0;
    }

    private static String getTemporaryName(CoordinateSystem source) {
        StringBuffer buffer = new StringBuffer("Temporary-");
        buffer.append(++temporaryID);
        String name = source.getName(null);
        if (name != null) {
            String suffix = " derived from ";
            int index = (name = name.trim()).indexOf(" derived from ");
            if (index >= 0) {
                name = name.substring(index + " derived from ".length()).trim();
            }
            if (name.length() > 0) {
                buffer.append(" derived from ");
                buffer.append(name);
            }
        }
        return buffer.toString();
    }

    private static String getTemporaryName(CoordinateSystem source, CoordinateSystem existing) {
        return source != existing ? existing.getName(null) : CoordinateTransformationFactory.getTemporaryName(source);
    }

    final synchronized Object toOpenGIS(Object adapters) throws RemoteException {
        if (this.proxy != null) {
            if (this.proxy instanceof Reference) {
                Object ref = ((Reference)this.proxy).get();
                if (ref != null) {
                    return ref;
                }
            } else {
                return this.proxy;
            }
        }
        Export opengis = new Export(adapters);
        this.proxy = new WeakReference<Export>(opengis);
        return opengis;
    }

    static {
        $assertionsDisabled = !CoordinateTransformationFactory.class.desiredAssertionStatus();
    }

    private final class Export
    extends UnicastRemoteObject
    implements CT_CoordinateTransformationFactory {
        protected final Adapters adapters;

        protected Export(Object adapters) throws RemoteException {
            this.adapters = (Adapters)adapters;
        }

        public CT_CoordinateTransformation createFromCoordinateSystems(CS_CoordinateSystem sourceCS, CS_CoordinateSystem targetCS) throws RemoteException {
            try {
                return this.adapters.export(CoordinateTransformationFactory.this.createFromCoordinateSystems(this.adapters.wrap(sourceCS), this.adapters.wrap(targetCS)));
            }
            catch (CannotCreateTransformException exception) {
                throw new ServerException(exception.getLocalizedMessage(), exception);
            }
        }
    }
}

