/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Locale;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.Info;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.Adapters;
import org.geotools.ct.MathTransform;
import org.geotools.ct.NoninvertibleTransformException;
import org.geotools.ct.TransformType;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.opengis.cs.CS_CoordinateSystem;
import org.opengis.ct.CT_CoordinateTransformation;
import org.opengis.ct.CT_MathTransform;
import org.opengis.ct.CT_TransformType;

public class CoordinateTransformation
extends Info {
    private static final long serialVersionUID = -1850470924499685544L;
    private transient Object proxy;
    private final CoordinateSystem sourceCS;
    private final CoordinateSystem targetCS;
    private final TransformType type;
    protected MathTransform transform;
    transient CoordinateTransformation inverse;

    public CoordinateTransformation(String name, CoordinateSystem sourceCS, CoordinateSystem targetCS, TransformType type, MathTransform transform) {
        super(name != null ? name : "");
        this.sourceCS = sourceCS;
        this.targetCS = targetCS;
        this.type = type;
        this.transform = transform;
        CoordinateTransformation.ensureNonNull("sourceCS", sourceCS);
        CoordinateTransformation.ensureNonNull("targetCS", targetCS);
        CoordinateTransformation.ensureNonNull("type", (Object)type);
        if (this.getClass().equals(CoordinateTransformation.class)) {
            CoordinateTransformation.ensureNonNull("transform", transform);
        }
        CoordinateTransformation.checkDimension("sourceCS", sourceCS.getDimension(), transform.getDimSource());
        CoordinateTransformation.checkDimension("targetCS", targetCS.getDimension(), transform.getDimTarget());
    }

    private static void checkDimension(String name, int actual, int expected) {
        if (actual != expected) {
            throw new IllegalArgumentException(Resources.format(89, name, new Integer(actual), new Integer(expected)));
        }
    }

    public String getName(Locale locale) {
        String name = super.getName(locale);
        if (name.length() != 0) {
            return name;
        }
        if (this.transform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)this.transform).getName(locale);
        }
        return this.sourceCS.getName(locale) + "\u00a0\u21e8\u00a0" + this.targetCS.getName(locale);
    }

    public CoordinateSystem getSourceCS() {
        return this.sourceCS;
    }

    public CoordinateSystem getTargetCS() {
        return this.targetCS;
    }

    public TransformType getTransformType() {
        return this.type;
    }

    public MathTransform getMathTransform() {
        if (this.transform != null) {
            return this.transform;
        }
        throw new IllegalStateException();
    }

    public synchronized CoordinateTransformation inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = new Inverse(this);
        }
        return this.inverse;
    }

    public int hashCode() {
        int code = 7851236;
        CoordinateSystem cs = this.getSourceCS();
        if (cs != null) {
            code = code * 37 + cs.hashCode();
        }
        if ((cs = this.getTargetCS()) != null) {
            code = code * 37 + cs.hashCode();
        }
        return code;
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            CoordinateTransformation that = (CoordinateTransformation)object;
            return Utilities.equals((Object)((Object)this.getTransformType()), (Object)((Object)that.getTransformType())) && CoordinateTransformation.equals(this.getSourceCS(), that.getSourceCS(), compareNames) && CoordinateTransformation.equals(this.getTargetCS(), that.getTargetCS(), compareNames);
        }
        return false;
    }

    private static boolean equals(Info object1, Info object2, boolean compareNames) {
        return object1 == object2 || object1 != null && object1.equals(object2, compareNames);
    }

    Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    final synchronized Object cachedOpenGIS(Object adapters) throws RemoteException {
        if (this.proxy != null) {
            if (this.proxy instanceof Reference) {
                Object ref = ((Reference)this.proxy).get();
                if (ref != null) {
                    return ref;
                }
            } else {
                return this.proxy;
            }
        }
        Object opengis = this.toOpenGIS(adapters);
        this.proxy = new WeakReference<Object>(opengis);
        return opengis;
    }

    final class Export
    extends UnicastRemoteObject
    implements CT_CoordinateTransformation {
        protected final Adapters adapters;

        protected Export(Object adapters) throws RemoteException {
            this.adapters = (Adapters)adapters;
        }

        public final CoordinateTransformation unwrap() {
            return CoordinateTransformation.this;
        }

        public String getName() throws RemoteException {
            return CoordinateTransformation.this.getName(null);
        }

        public String getAuthority() throws RemoteException {
            return CoordinateTransformation.this.getAuthority(null);
        }

        public String getAuthorityCode() throws RemoteException {
            return CoordinateTransformation.this.getAuthorityCode(null);
        }

        public String getRemarks() throws RemoteException {
            return CoordinateTransformation.this.getRemarks(null);
        }

        public String getAreaOfUse() throws RemoteException {
            throw new UnsupportedOperationException("Area of use not yet implemented");
        }

        public CT_TransformType getTransformType() throws RemoteException {
            return this.adapters.export(CoordinateTransformation.this.getTransformType());
        }

        public CS_CoordinateSystem getSourceCS() throws RemoteException {
            return this.adapters.export(CoordinateTransformation.this.getSourceCS());
        }

        public CS_CoordinateSystem getTargetCS() throws RemoteException {
            return this.adapters.export(CoordinateTransformation.this.getTargetCS());
        }

        public CT_MathTransform getMathTransform() throws RemoteException {
            return this.adapters.export(CoordinateTransformation.this.getMathTransform());
        }
    }

    private static final class Inverse
    extends CoordinateTransformation {
        public Inverse(CoordinateTransformation transform) throws NoninvertibleTransformException {
            super(null, transform.getTargetCS(), transform.getSourceCS(), transform.getTransformType(), transform.getMathTransform().inverse());
            this.inverse = transform;
        }

        public String getName(Locale locale) {
            return Resources.getResources(locale).getString(20, this.inverse.getName(locale));
        }
    }
}

