/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import org.geotools.ct.ConcatenatedTransformDirect;
import org.geotools.ct.MathTransform1D;
import org.geotools.ct.MathTransformFactory;
import org.geotools.ct.TransformException;

final class ConcatenatedTransformDirect1D
extends ConcatenatedTransformDirect
implements MathTransform1D {
    private static final long serialVersionUID = 1064398659892864966L;
    private final MathTransform1D transform1;
    private final MathTransform1D transform2;

    public ConcatenatedTransformDirect1D(MathTransformFactory provider, MathTransform1D transform1, MathTransform1D transform2) {
        super(provider, transform1, transform2);
        this.transform1 = transform1;
        this.transform2 = transform2;
    }

    protected boolean isValid() {
        return super.isValid() && this.getDimSource() == 1 && this.getDimTarget() == 1;
    }

    public double transform(double value) throws TransformException {
        return this.transform2.transform(this.transform1.transform(value));
    }

    public double derivative(double value) throws TransformException {
        double value1 = this.transform1.derivative(value);
        double value2 = this.transform2.derivative(this.transform1.transform(value));
        return value2 * value1;
    }
}

