/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import org.geotools.ct.ConcatenatedTransform;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransform1D;
import org.geotools.ct.MathTransformFactory;
import org.geotools.ct.TransformException;
import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Matrix;

final class ConcatenatedTransform1D
extends ConcatenatedTransform
implements MathTransform1D {
    private static final long serialVersionUID = 8150427971141078395L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConcatenatedTransform1D(MathTransformFactory provider, MathTransform transform1, MathTransform transform2) {
        super(provider, transform1, transform2);
    }

    protected boolean isValid() {
        return super.isValid() && this.getDimSource() == 1 && this.getDimTarget() == 1;
    }

    public double transform(double value) throws TransformException {
        double[] values = new double[]{value};
        double[] buffer = new double[]{this.transform1.getDimTarget()};
        this.transform1.transform(values, 0, buffer, 0, 1);
        this.transform2.transform(buffer, 0, values, 0, 1);
        return values[0];
    }

    public double derivative(double value) throws TransformException {
        CoordinatePoint p = new CoordinatePoint(1);
        p.ord[0] = value;
        Matrix m = this.derivative(p);
        if (!($assertionsDisabled || m.getNumRow() == 1 && m.getNumCol() == 1)) {
            throw new AssertionError();
        }
        return m.getElement(0, 0);
    }

    static {
        $assertionsDisabled = !ConcatenatedTransform1D.class.desiredAssertionStatus();
    }
}

