/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.awt.geom.Point2D;
import java.io.Serializable;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.ConcatenatedTransform1D;
import org.geotools.ct.ConcatenatedTransform2D;
import org.geotools.ct.ConcatenatedTransformDirect;
import org.geotools.ct.ConcatenatedTransformDirect1D;
import org.geotools.ct.ConcatenatedTransformDirect2D;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransform1D;
import org.geotools.ct.MathTransform2D;
import org.geotools.ct.MathTransformFactory;
import org.geotools.ct.NoninvertibleTransformException;
import org.geotools.ct.TransformException;
import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Matrix;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;

class ConcatenatedTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 5772066656987558634L;
    private transient MathTransformFactory provider;
    protected final MathTransform transform1;
    protected final MathTransform transform2;
    private transient MathTransform inverse;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ConcatenatedTransform(MathTransformFactory provider, MathTransform transform1, MathTransform transform2) {
        this.provider = provider;
        this.transform1 = transform1;
        this.transform2 = transform2;
        if (!this.isValid()) {
            throw new IllegalArgumentException(Resources.format(45, ConcatenatedTransform.getName(transform1), ConcatenatedTransform.getName(transform2)));
        }
    }

    public static ConcatenatedTransform create(MathTransformFactory provider, MathTransform tr1, MathTransform tr2) {
        int dimSource = tr1.getDimSource();
        int dimTarget = tr2.getDimTarget();
        if (dimSource == 1 && dimTarget == 1) {
            if (tr1 instanceof MathTransform1D && tr2 instanceof MathTransform1D) {
                return new ConcatenatedTransformDirect1D(provider, (MathTransform1D)tr1, (MathTransform1D)tr2);
            }
            return new ConcatenatedTransform1D(provider, tr1, tr2);
        }
        if (dimSource == 2 && dimTarget == 2) {
            if (tr1 instanceof MathTransform2D && tr2 instanceof MathTransform2D) {
                return new ConcatenatedTransformDirect2D(provider, (MathTransform2D)tr1, (MathTransform2D)tr2);
            }
            return new ConcatenatedTransform2D(provider, tr1, tr2);
        }
        if (dimSource == tr1.getDimTarget() && tr2.getDimSource() == dimTarget) {
            return new ConcatenatedTransformDirect(provider, tr1, tr2);
        }
        return new ConcatenatedTransform(provider, tr1, tr2);
    }

    private static final String getName(MathTransform transform) {
        String name;
        if (transform instanceof AbstractMathTransform && (name = ((AbstractMathTransform)transform).getName(null)) != null && (name = name.trim()).length() != 0) {
            return name;
        }
        return Utilities.getShortClassName((Object)transform);
    }

    protected boolean isValid() {
        return this.transform1.getDimTarget() == this.transform2.getDimSource();
    }

    public final int getDimSource() {
        return this.transform1.getDimSource();
    }

    public final int getDimTarget() {
        return this.transform2.getDimTarget();
    }

    public CoordinatePoint transform(CoordinatePoint ptSrc, CoordinatePoint ptDst) throws TransformException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        return this.transform2.transform(this.transform1.transform(ptSrc, null), ptDst);
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        double[] tmp = new double[numPts * this.transform1.getDimTarget()];
        this.transform1.transform(srcPts, srcOff, tmp, 0, numPts);
        this.transform2.transform(tmp, 0, dstPts, dstOff, numPts);
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        float[] tmp = new float[numPts * this.transform1.getDimTarget()];
        this.transform1.transform(srcPts, srcOff, tmp, 0, numPts);
        this.transform2.transform(tmp, 0, dstPts, dstOff, numPts);
    }

    public final synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        if (this.inverse == null) {
            if (this.provider == null) {
                this.provider = MathTransformFactory.getDefault();
            }
            this.inverse = this.provider.createConcatenatedTransform(this.transform2.inverse(), this.transform1.inverse());
            if (this.inverse instanceof ConcatenatedTransform) {
                ((ConcatenatedTransform)this.inverse).inverse = this;
            }
        }
        return this.inverse;
    }

    public Matrix derivative(Point2D point) throws TransformException {
        return this.derivative(new CoordinatePoint(point));
    }

    public Matrix derivative(CoordinatePoint point) throws TransformException {
        Matrix matrix;
        Matrix matrix1 = this.transform1.derivative(point);
        Matrix matrix2 = this.transform2.derivative(this.transform1.transform(point, null));
        int numRow = matrix2.getNumRow();
        int numCol = matrix1.getNumCol();
        if (numCol == matrix2.getNumCol()) {
            matrix = matrix2;
            matrix2.mul(matrix1);
        } else {
            matrix = new Matrix(numRow, numCol);
            matrix.mul(matrix2, matrix1);
        }
        return matrix;
    }

    public final boolean isIdentity() {
        return this.transform1.isIdentity() && this.transform2.isIdentity();
    }

    public final int hashCode() {
        return this.transform1.hashCode() + 37 * this.transform2.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ConcatenatedTransform that = (ConcatenatedTransform)object;
            return Utilities.equals((Object)this.transform1, (Object)that.transform1) && Utilities.equals((Object)this.transform2, (Object)that.transform2);
        }
        return false;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer("CONCAT_MT[");
        ConcatenatedTransform.addWKT(buffer, this, true);
        buffer.append(']');
        return buffer.toString();
    }

    private static void addWKT(StringBuffer buffer, MathTransform transform, boolean first) {
        if (transform instanceof ConcatenatedTransform) {
            ConcatenatedTransform concat = (ConcatenatedTransform)transform;
            ConcatenatedTransform.addWKT(buffer, concat.transform1, first);
            ConcatenatedTransform.addWKT(buffer, concat.transform2, false);
        } else {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(transform);
        }
    }

    static {
        $assertionsDisabled = !ConcatenatedTransform.class.desiredAssertionStatus();
    }
}

