/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.geotools.ct.LinearTransform;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransform2D;
import org.geotools.ct.MatrixTransform;
import org.geotools.ct.NoninvertibleTransformException;
import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Matrix;
import org.geotools.resources.XAffineTransform;
import org.geotools.resources.cts.Resources;

final class AffineTransform2D
extends XAffineTransform
implements MathTransform2D,
LinearTransform {
    private static final long serialVersionUID = -5299837898367149069L;
    private transient AffineTransform2D inverse;

    protected AffineTransform2D(AffineTransform transform) {
        super(transform);
    }

    protected void checkPermission() {
        throw new UnsupportedOperationException(Resources.format(78));
    }

    public int getDimSource() {
        return 2;
    }

    public int getDimTarget() {
        return 2;
    }

    public CoordinatePoint transform(CoordinatePoint ptSrc, CoordinatePoint ptDst) {
        if (ptDst == null) {
            ptDst = new CoordinatePoint(2);
        }
        this.transform(ptSrc.ord, 0, ptDst.ord, 0, 1);
        return ptDst;
    }

    public Matrix getMatrix() {
        return new Matrix((AffineTransform)((Object)this));
    }

    public Matrix derivative(Point2D point) {
        Matrix matrix = new Matrix(2);
        matrix.setElement(0, 0, this.getScaleX());
        matrix.setElement(1, 1, this.getScaleY());
        matrix.setElement(0, 1, this.getShearX());
        matrix.setElement(1, 0, this.getShearY());
        return matrix;
    }

    public Matrix derivative(CoordinatePoint point) {
        return this.derivative((Point2D)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.isIdentity()) {
                this.inverse = this;
            } else {
                try {
                    AffineTransform2D affineTransform2D = this;
                    synchronized (affineTransform2D) {
                        this.inverse = new AffineTransform2D(this.createInverse());
                        this.inverse.inverse = this;
                    }
                }
                catch (java.awt.geom.NoninvertibleTransformException exception) {
                    throw new NoninvertibleTransformException(exception.getLocalizedMessage(), exception);
                }
            }
        }
        return this.inverse;
    }

    public String toString() {
        return MatrixTransform.toString(new Matrix((AffineTransform)((Object)this)));
    }
}

