/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.ParameterListDescriptorImpl;
import javax.media.jai.ParameterListImpl;
import org.geotools.cs.FactoryException;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.CoordinateTransformation;
import org.geotools.ct.CoordinateTransformationFactory;
import org.geotools.ct.DomainFlags;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransformAdapter;
import org.geotools.ct.MathTransformAdapter2D;
import org.geotools.ct.MathTransformExport;
import org.geotools.ct.MathTransformFactory;
import org.geotools.ct.TransformType;
import org.geotools.resources.XArray;
import org.opengis.ct.CT_CoordinateTransformation;
import org.opengis.ct.CT_CoordinateTransformationFactory;
import org.opengis.ct.CT_DomainFlags;
import org.opengis.ct.CT_MathTransform;
import org.opengis.ct.CT_MathTransformFactory;
import org.opengis.ct.CT_Parameter;
import org.opengis.ct.CT_TransformType;

public class Adapters
extends org.geotools.cs.Adapters {
    private static Adapters DEFAULT;
    static /* synthetic */ Class class$java$lang$Double;

    protected Adapters() {
    }

    public static synchronized Adapters getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new Adapters();
        }
        return DEFAULT;
    }

    public CT_MathTransform export(MathTransform transform) throws RemoteException {
        if (transform == null) {
            return null;
        }
        if (transform instanceof AbstractMathTransform) {
            AbstractMathTransform atr = (AbstractMathTransform)transform;
            return (CT_MathTransform)atr.cachedOpenGIS(this);
        }
        return new MathTransformExport(this, transform);
    }

    public CT_CoordinateTransformation export(CoordinateTransformation transform) throws RemoteException {
        return transform != null ? (CT_CoordinateTransformation)transform.cachedOpenGIS(this) : null;
    }

    public CT_MathTransformFactory export(MathTransformFactory factory) throws RemoteException {
        return factory != null ? (CT_MathTransformFactory)factory.toOpenGIS(this) : null;
    }

    public CT_CoordinateTransformationFactory export(CoordinateTransformationFactory factory) throws RemoteException {
        return factory != null ? (CT_CoordinateTransformationFactory)factory.toOpenGIS(this) : null;
    }

    public CT_Parameter[] export(ParameterList parameters) {
        if (parameters == null) {
            return null;
        }
        String[] names = parameters.getParameterListDescriptor().getParamNames();
        Object[] param = new CT_Parameter[names != null ? names.length : 0];
        int count = 0;
        for (int i = 0; i < param.length; ++i) {
            Object value;
            String name = names[i];
            try {
                value = parameters.getObjectParameter(name);
            }
            catch (IllegalStateException exception) {
                continue;
            }
            if (!(value instanceof Number)) continue;
            param[count++] = new CT_Parameter(name, ((Number)value).doubleValue());
        }
        return (CT_Parameter[])XArray.resize((Object[])param, (int)count);
    }

    public CT_TransformType export(TransformType type) {
        return type != null ? new CT_TransformType(type.getValue()) : null;
    }

    public CT_DomainFlags export(DomainFlags flags) {
        return flags != null ? new CT_DomainFlags(flags.getValue()) : null;
    }

    public MathTransform wrap(CT_MathTransform transform) throws RemoteException {
        if (transform == null) {
            return null;
        }
        if (transform instanceof MathTransformExport) {
            return ((MathTransformExport)transform).transform;
        }
        if (transform.getDimSource() == 2 && transform.getDimTarget() == 2) {
            return new MathTransformAdapter2D(transform);
        }
        return new MathTransformAdapter(transform);
    }

    public CoordinateTransformation wrap(CT_CoordinateTransformation transform) throws RemoteException {
        if (transform == null) {
            return null;
        }
        if (transform instanceof CoordinateTransformation.Export) {
            return ((CoordinateTransformation.Export)transform).unwrap();
        }
        return new CoordinateTransformation(null, this.wrap(transform.getSourceCS()), this.wrap(transform.getTargetCS()), this.wrap(transform.getTransformType()), this.wrap(transform.getMathTransform()));
    }

    public ParameterList wrap(CT_Parameter[] parameters) {
        if (parameters == null) {
            return null;
        }
        int count = 0;
        Object[] paramNames = new String[parameters.length];
        Object[] paramClasses = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            CT_Parameter param = parameters[i];
            if (param == null) continue;
            paramNames[count] = param.name;
            paramClasses[count] = class$java$lang$Double == null ? Adapters.class$("java.lang.Double") : class$java$lang$Double;
            ++count;
        }
        paramNames = (String[])XArray.resize((Object[])paramNames, (int)count);
        paramClasses = (Class[])XArray.resize((Object[])paramClasses, (int)count);
        ParameterListImpl list = new ParameterListImpl((ParameterListDescriptor)new ParameterListDescriptorImpl(null, (String[])paramNames, (Class[])paramClasses, null, null));
        for (int i = 0; i < paramNames.length; ++i) {
            list.setParameter((String)paramNames[i], parameters[i].value);
        }
        return list;
    }

    public TransformType wrap(CT_TransformType type) {
        return type != null ? TransformType.getEnum(type.value) : null;
    }

    public DomainFlags wrap(CT_DomainFlags flags) {
        return flags != null ? DomainFlags.getEnum(flags.value) : null;
    }

    static RemoteException serverException(FactoryException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof RemoteException) {
            return (RemoteException)cause;
        }
        return new ServerException("Can't create object", exception);
    }
}

