/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.Locale;
import javax.vecmath.SingularMatrixException;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransform1D;
import org.geotools.ct.MathTransformExport;
import org.geotools.ct.NoninvertibleTransformException;
import org.geotools.ct.TransformException;
import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Matrix;
import org.geotools.pt.MismatchedDimensionException;
import org.geotools.resources.Geometry;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;

public abstract class AbstractMathTransform
implements MathTransform {
    private transient Object proxy;

    AbstractMathTransform(Object opengis) {
        this.proxy = opengis;
    }

    public AbstractMathTransform() {
    }

    protected String getName(Locale locale) {
        return null;
    }

    public boolean isIdentity() {
        return false;
    }

    public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
        if (this.getDimSource() != 2 || this.getDimTarget() != 2) {
            throw new MismatchedDimensionException();
        }
        double[] ord = new double[]{ptSrc.getX(), ptSrc.getY()};
        this.transform(ord, 0, ord, 0, 1);
        if (ptDst != null) {
            ptDst.setLocation(ord[0], ord[1]);
            return ptDst;
        }
        return new Point2D.Double(ord[0], ord[1]);
    }

    public CoordinatePoint transform(CoordinatePoint ptSrc, CoordinatePoint ptDst) throws TransformException {
        int dimPoint = ptSrc.getDimension();
        int dimSource = this.getDimSource();
        int dimTarget = this.getDimTarget();
        if (dimPoint != dimSource) {
            throw new MismatchedDimensionException(dimPoint, dimSource);
        }
        if (ptDst == null) {
            ptDst = new CoordinatePoint(dimTarget);
        } else if (ptDst.getDimension() != dimTarget) {
            throw new MismatchedDimensionException(ptDst.getDimension(), dimTarget);
        }
        this.transform(ptSrc.ord, 0, ptDst.ord, 0, 1);
        return ptDst;
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int dimSource = this.getDimSource();
        int dimTarget = this.getDimTarget();
        double[] tmpPts = new double[numPts * Math.max(dimSource, dimTarget)];
        int i = numPts * dimSource;
        while (--i >= 0) {
            tmpPts[i] = srcPts[srcOff + i];
        }
        this.transform(tmpPts, 0, tmpPts, 0, numPts);
        i = numPts * dimTarget;
        while (--i >= 0) {
            dstPts[dstOff + i] = (float)tmpPts[i];
        }
    }

    public Shape createTransformedShape(Shape shape) throws TransformException {
        return this.isIdentity() ? shape : this.createTransformedShape(shape, null, null, 0);
    }

    final Shape createTransformedShape(Shape shape, AffineTransform preTr, AffineTransform postTr, int quadDir) throws TransformException {
        if (this.getDimSource() != 2 || this.getDimTarget() != 2) {
            throw new MismatchedDimensionException();
        }
        PathIterator it = shape.getPathIterator(preTr);
        GeneralPath path = new GeneralPath(it.getWindingRule());
        Point2D.Float ctrl = new Point2D.Float();
        double[] buffer = new double[6];
        double ax = 0.0;
        double ay = 0.0;
        double px = 0.0;
        double py = 0.0;
        int indexCtrlPt = 0;
        int indexLastPt = 0;
        while (!it.isDone()) {
            block12: {
                switch (it.currentSegment(buffer)) {
                    default: {
                        throw new IllegalPathStateException();
                    }
                    case 4: {
                        path.closePath();
                        break block12;
                    }
                    case 0: {
                        ax = buffer[0];
                        ay = buffer[1];
                        this.transform(buffer, 0, buffer, 0, 1);
                        px = buffer[0];
                        py = buffer[1];
                        path.moveTo((float)px, (float)py);
                        break block12;
                    }
                    case 1: {
                        indexLastPt = 0;
                        indexCtrlPt = 2;
                        double d = ax;
                        ax = buffer[0];
                        buffer[2] = 0.5 * (d + ax);
                        double d2 = ay;
                        ay = buffer[1];
                        buffer[3] = 0.5 * (d2 + ay);
                        break;
                    }
                    case 2: {
                        indexLastPt = 2;
                        indexCtrlPt = 0;
                        double d = ax;
                        ax = buffer[2];
                        buffer[0] = 0.5 * (buffer[0] + 0.5 * (d + ax));
                        double d3 = ay;
                        ay = buffer[3];
                        buffer[1] = 0.5 * (buffer[1] + 0.5 * (d3 + ay));
                        break;
                    }
                    case 3: {
                        indexLastPt = 4;
                        indexCtrlPt = 0;
                        double d = ax;
                        ax = buffer[4];
                        buffer[0] = 0.25 * (1.5 * (buffer[0] + buffer[2]) + 0.5 * (d + ax));
                        double d4 = ay;
                        ay = buffer[5];
                        buffer[1] = 0.25 * (1.5 * (buffer[1] + buffer[3]) + 0.5 * (d4 + ay));
                    }
                }
                this.transform(buffer, 0, buffer, 0, 2);
                if (Geometry.parabolicControlPoint((double)px, (double)py, (double)buffer[indexCtrlPt], (double)buffer[indexCtrlPt + 1], (double)buffer[indexLastPt], (double)buffer[indexLastPt + 1], (int)quadDir, (Point2D)ctrl) != null) {
                    px = buffer[indexLastPt + 0];
                    py = buffer[indexLastPt + 1];
                    path.quadTo(ctrl.x, ctrl.y, (float)px, (float)py);
                } else {
                    px = buffer[indexLastPt + 0];
                    py = buffer[indexLastPt + 1];
                    path.lineTo((float)px, (float)py);
                }
            }
            it.next();
        }
        if (postTr != null) {
            path.transform(postTr);
        }
        return Geometry.toPrimitive((Shape)path);
    }

    public Matrix derivative(Point2D point) throws TransformException {
        int dimSource = this.getDimSource();
        if (dimSource != 2) {
            throw new MismatchedDimensionException(2, dimSource);
        }
        throw new TransformException(Resources.format(85));
    }

    public Matrix derivative(CoordinatePoint point) throws TransformException {
        int dimSource = this.getDimSource();
        if (point != null) {
            int dimPoint = point.getDimension();
            if (dimPoint != dimSource) {
                throw new MismatchedDimensionException(dimPoint, dimSource);
            }
            if (dimSource == 2) {
                return this.derivative(point.toPoint2D());
            }
        } else if (dimSource == 2) {
            return this.derivative((Point2D)null);
        }
        if (this instanceof MathTransform1D) {
            return new Matrix(1, 1, new double[]{((MathTransform1D)((Object)this)).derivative(point.ord[0])});
        }
        throw new TransformException(Resources.format(85));
    }

    public MathTransform inverse() throws NoninvertibleTransformException {
        if (this.isIdentity()) {
            return this;
        }
        throw new NoninvertibleTransformException(Resources.format(62));
    }

    MathTransform concatenate(MathTransform other, boolean applyOtherFirst) {
        return null;
    }

    public int hashCode() {
        return this.getDimSource() + 37 * this.getDimTarget();
    }

    public boolean equals(Object object) {
        return object != null && this.getClass().equals(object.getClass());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName((Object)this));
        buffer.append('[');
        String name = this.getName(null);
        if (name != null) {
            buffer.append('\"');
            buffer.append(name);
            buffer.append("\": ");
        }
        buffer.append(this.getDimSource());
        buffer.append("D \u2192 ");
        buffer.append(this.getDimTarget());
        buffer.append("D]");
        return buffer.toString();
    }

    static StringBuffer paramMT(String classification) {
        StringBuffer buffer = new StringBuffer("PARAM_MT[\"");
        buffer.append(classification);
        buffer.append('\"');
        return buffer;
    }

    static void addParameter(StringBuffer buffer, String key, double value) {
        buffer.append(", PARAMETER[\"");
        buffer.append(key);
        buffer.append("\",");
        buffer.append(value);
        buffer.append(']');
    }

    static void addParameter(StringBuffer buffer, String key, int value) {
        buffer.append(", PARAMETER[\"");
        buffer.append(key);
        buffer.append("\",");
        buffer.append(value);
        buffer.append(']');
    }

    final Object cachedOpenGIS(Object adapters) throws RemoteException {
        if (this.proxy != null) {
            if (this.proxy instanceof Reference) {
                Object ref = ((Reference)this.proxy).get();
                if (ref != null) {
                    return ref;
                }
            } else {
                return this.proxy;
            }
        }
        MathTransformExport opengis = new MathTransformExport(adapters, this);
        this.proxy = new WeakReference<MathTransformExport>(opengis);
        return opengis;
    }

    private static Matrix invert(Matrix matrix) throws NoninvertibleTransformException {
        try {
            matrix.invert();
            return matrix;
        }
        catch (SingularMatrixException exception) {
            NoninvertibleTransformException e = new NoninvertibleTransformException(Resources.format(62));
            e.initCause(exception);
            throw e;
        }
    }

    protected abstract class Inverse
    extends AbstractMathTransform
    implements Serializable {
        private static final long serialVersionUID = -864892964444937416L;

        public int getDimSource() {
            return AbstractMathTransform.this.getDimTarget();
        }

        public int getDimTarget() {
            return AbstractMathTransform.this.getDimSource();
        }

        public Matrix derivative(Point2D point) throws TransformException {
            return AbstractMathTransform.invert(AbstractMathTransform.this.derivative(this.transform(point, null)));
        }

        public Matrix derivative(CoordinatePoint point) throws TransformException {
            return AbstractMathTransform.invert(AbstractMathTransform.this.derivative(this.transform(point, null)));
        }

        public final MathTransform inverse() {
            return AbstractMathTransform.this;
        }

        public boolean isIdentity() {
            return AbstractMathTransform.this.isIdentity();
        }

        public int hashCode() {
            return ~AbstractMathTransform.this.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Inverse) {
                Inverse that = (Inverse)object;
                return Utilities.equals((Object)this.inverse(), (Object)that.inverse());
            }
            return false;
        }

        public String toString() {
            return "INVERSE_MT[" + AbstractMathTransform.this + ']';
        }
    }
}

