/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct;

import java.io.Serializable;
import javax.media.jai.ParameterList;
import javax.media.jai.util.Range;
import org.geotools.cs.Ellipsoid;
import org.geotools.cs.HorizontalDatum;
import org.geotools.cs.WGS84ConversionInfo;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransformProvider;
import org.geotools.ct.TransformException;
import org.geotools.resources.cts.Resources;

class AbridgedMolodenskiTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 1759367353860977791L;
    private final boolean source3D;
    private final boolean target3D;
    private final double dx;
    private final double dy;
    private final double dz;
    private final double a;
    private final double b;
    private final double da;
    private final double db;
    private final double e2;
    private final double adf;
    static /* synthetic */ Class class$java$lang$Integer;

    protected AbridgedMolodenskiTransform(HorizontalDatum source, HorizontalDatum target, boolean source3D, boolean target3D) {
        WGS84ConversionInfo srcInfo = source.getWGS84Parameters();
        WGS84ConversionInfo tgtInfo = target.getWGS84Parameters();
        Ellipsoid srcEllipsoid = source.getEllipsoid();
        Ellipsoid tgtEllipsoid = target.getEllipsoid();
        this.dx = srcInfo.dx - tgtInfo.dx;
        this.dy = srcInfo.dy - tgtInfo.dy;
        this.dz = srcInfo.dz - tgtInfo.dz;
        this.a = srcEllipsoid.getSemiMajorAxis();
        this.b = srcEllipsoid.getSemiMinorAxis();
        double f = 1.0 / srcEllipsoid.getInverseFlattening();
        this.da = this.a - tgtEllipsoid.getSemiMajorAxis();
        this.db = this.b - tgtEllipsoid.getSemiMinorAxis();
        double df = f - 1.0 / tgtEllipsoid.getInverseFlattening();
        this.e2 = 1.0 - this.b * this.b / (this.a * this.a);
        this.adf = this.a * df + f * this.da;
        this.source3D = source3D;
        this.target3D = target3D;
    }

    protected AbridgedMolodenskiTransform(ParameterList parameters) {
        int dim = parameters.getIntParameter("dim");
        switch (dim) {
            case 2: {
                this.target3D = false;
                this.source3D = false;
                break;
            }
            case 3: {
                this.target3D = true;
                this.source3D = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(Resources.format(50, "dim", new Integer(dim)));
            }
        }
        this.dx = parameters.getDoubleParameter("dx");
        this.dy = parameters.getDoubleParameter("dy");
        this.dz = parameters.getDoubleParameter("dz");
        this.a = parameters.getDoubleParameter("src_semi_major");
        this.b = parameters.getDoubleParameter("src_semi_minor");
        double ta = parameters.getDoubleParameter("tgt_semi_major");
        double tb = parameters.getDoubleParameter("tgt_semi_minor");
        this.da = this.a - ta;
        this.db = this.b - tb;
        double f = (this.a - this.b) / this.a;
        double df = f - (ta - tb) / ta;
        this.e2 = 1.0 - this.b * this.b / (this.a * this.a);
        this.adf = this.a * df + f * this.da;
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int step = 0;
        if (srcPts == dstPts && srcOff < dstOff && srcOff + numPts * this.getDimSource() > dstOff) {
            if (this.source3D != this.target3D) {
                throw new UnsupportedOperationException();
            }
            step = -this.getDimSource();
            srcOff -= (numPts - 1) * step;
            dstOff -= (numPts - 1) * step;
        }
        while (--numPts >= 0) {
            double x = Math.toRadians(srcPts[srcOff++]);
            double y = Math.toRadians(srcPts[srcOff++]);
            double z = this.source3D ? srcPts[srcOff++] : 0.0;
            double sinX = Math.sin(x);
            double cosX = Math.cos(x);
            double sinY = Math.sin(y);
            double cosY = Math.cos(y);
            double sin2Y = sinY * sinY;
            double nu = this.a / Math.sqrt(1.0 - this.e2 * sin2Y);
            double rho = nu * (1.0 - this.e2) / (1.0 - this.e2 * sin2Y);
            y += (this.dz * cosY - sinY * (this.dy * sinX + this.dx * cosX) + this.adf * Math.sin(2.0 * y)) / rho;
            dstPts[dstOff++] = Math.toDegrees(x += (this.dy * cosX - this.dx * sinX) / (nu * cosY));
            dstPts[dstOff++] = Math.toDegrees(y);
            if (this.target3D) {
                dstPts[dstOff++] = z += this.dx * cosY * cosX + this.dy * cosY * sinX + this.dz * sinY + this.adf * sin2Y - this.da;
            }
            srcOff += step;
            dstOff += step;
        }
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        try {
            super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
        }
        catch (TransformException exception) {
            // empty catch block
        }
    }

    public int getDimSource() {
        return this.source3D ? 3 : 2;
    }

    public final int getDimTarget() {
        return this.target3D ? 3 : 2;
    }

    public final int hashCode() {
        long code = Double.doubleToLongBits(this.dx) + 37L * (Double.doubleToLongBits(this.dy) + 37L * (Double.doubleToLongBits(this.dz) + 37L * (Double.doubleToLongBits(this.a) + 37L * (Double.doubleToLongBits(this.b) + 37L * (Double.doubleToLongBits(this.da) + 37L * Double.doubleToLongBits(this.db))))));
        return (int)code ^ (int)(code >>> 32);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            AbridgedMolodenskiTransform that = (AbridgedMolodenskiTransform)object;
            return Double.doubleToLongBits(this.dx) == Double.doubleToLongBits(that.dx) && Double.doubleToLongBits(this.dy) == Double.doubleToLongBits(that.dy) && Double.doubleToLongBits(this.dz) == Double.doubleToLongBits(that.dz) && Double.doubleToLongBits(this.a) == Double.doubleToLongBits(that.a) && Double.doubleToLongBits(this.b) == Double.doubleToLongBits(that.b) && Double.doubleToLongBits(this.da) == Double.doubleToLongBits(that.da) && Double.doubleToLongBits(this.db) == Double.doubleToLongBits(that.db) && this.source3D == that.source3D && this.target3D == that.target3D;
        }
        return false;
    }

    public final String toString() {
        StringBuffer buffer = AbridgedMolodenskiTransform.paramMT("Abridged_Molodenski");
        AbridgedMolodenskiTransform.addParameter(buffer, "dim", this.getDimSource());
        AbridgedMolodenskiTransform.addParameter(buffer, "dx", this.dx);
        AbridgedMolodenskiTransform.addParameter(buffer, "dy", this.dy);
        AbridgedMolodenskiTransform.addParameter(buffer, "dz", this.dz);
        AbridgedMolodenskiTransform.addParameter(buffer, "src_semi_major", this.a);
        AbridgedMolodenskiTransform.addParameter(buffer, "src_semi_minor", this.b);
        AbridgedMolodenskiTransform.addParameter(buffer, "tgt_semi_major", this.a - this.da);
        AbridgedMolodenskiTransform.addParameter(buffer, "tgt_semi_minor", this.b - this.db);
        buffer.append(']');
        return buffer.toString();
    }

    static final class Provider
    extends MathTransformProvider {
        static final Range DIM_RANGE = new Range(class$java$lang$Integer == null ? (class$java$lang$Integer = AbridgedMolodenskiTransform.class$("java.lang.Integer")) : class$java$lang$Integer, (Comparable)new Integer(2), (Comparable)new Integer(3));

        public Provider() {
            super("Abridged_Molodenski", 0, null);
            this.putInt("dim", 3, DIM_RANGE);
            this.put("dx", Double.NaN, null);
            this.put("dy", Double.NaN, null);
            this.put("dz", 0.0, null);
            this.put("src_semi_major", Double.NaN, POSITIVE_RANGE);
            this.put("src_semi_minor", Double.NaN, POSITIVE_RANGE);
            this.put("tgt_semi_major", Double.NaN, POSITIVE_RANGE);
            this.put("tgt_semi_minor", Double.NaN, POSITIVE_RANGE);
        }

        public MathTransform create(ParameterList parameters) {
            return new AbridgedMolodenskiTransform(parameters);
        }
    }
}

