/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.media.jai.ParameterList;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.AxisOrientation;
import org.geotools.cs.CompoundCoordinateSystem;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.CoordinateSystemFactory;
import org.geotools.cs.DatumType;
import org.geotools.cs.Ellipsoid;
import org.geotools.cs.FactoryException;
import org.geotools.cs.GeocentricCoordinateSystem;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.HorizontalDatum;
import org.geotools.cs.InfoProperties;
import org.geotools.cs.LocalCoordinateSystem;
import org.geotools.cs.LocalDatum;
import org.geotools.cs.PrimeMeridian;
import org.geotools.cs.ProjectedCoordinateSystem;
import org.geotools.cs.Projection;
import org.geotools.cs.VerticalCoordinateSystem;
import org.geotools.cs.VerticalDatum;
import org.geotools.cs.WGS84ConversionInfo;
import org.geotools.resources.DescriptorNaming;
import org.geotools.resources.WKTElement;
import org.geotools.resources.WKTFormat;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;

final class WKTParser
extends WKTFormat {
    private CoordinateSystemFactory factory;

    public WKTParser(Locale locale, CoordinateSystemFactory factory) {
        super(locale);
        this.factory = factory;
    }

    private static CharSequence parseAuthority(WKTElement parent, CharSequence parentName) throws ParseException {
        WKTElement element = parent.pullOptionalElement("AUTHORITY");
        if (element == null) {
            return parentName;
        }
        String name = element.pullString("name");
        String code = element.pullString("code");
        InfoProperties.Named info = new InfoProperties.Named(((Object)parentName).toString());
        info.put("authority", name);
        info.put("authorityCode", code);
        element.close();
        return info;
    }

    private static Unit parseUnit(WKTElement parent, Unit unit) throws ParseException {
        WKTElement element = parent.pullElement("UNIT");
        CharSequence name = element.pullString("name");
        double factor = element.pullDouble("factor");
        name = WKTParser.parseAuthority(element, name);
        element.close();
        return unit.scale(factor);
    }

    private AxisInfo parseAxis(WKTElement parent, boolean required) throws ParseException {
        WKTElement element;
        if (required) {
            element = parent.pullElement("AXIS");
        } else {
            element = parent.pullOptionalElement("AXIS");
            if (element == null) {
                return null;
            }
        }
        String name = element.pullString("name");
        WKTElement orientation = element.pullVoidElement("orientation");
        element.close();
        try {
            return new AxisInfo(name, AxisOrientation.getEnum(orientation.keyword, this.locale));
        }
        catch (NoSuchElementException exception) {
            throw element.parseFailed(exception, Resources.format(77, orientation));
        }
    }

    private PrimeMeridian parsePrimem(WKTElement parent, Unit unit) throws ParseException {
        WKTElement element = parent.pullElement("PRIMEM");
        CharSequence name = element.pullString("name");
        double longitude = element.pullDouble("longitude");
        name = WKTParser.parseAuthority(element, name);
        element.close();
        try {
            return this.factory.createPrimeMeridian(name, unit, longitude);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private static WGS84ConversionInfo parseToWGS84(WKTElement parent) throws ParseException {
        WKTElement element = parent.pullOptionalElement("TOWGS84");
        if (element == null) {
            return null;
        }
        WGS84ConversionInfo info = new WGS84ConversionInfo();
        info.dx = element.pullDouble("dx");
        info.dy = element.pullDouble("dy");
        info.dz = element.pullDouble("dz");
        info.ex = element.pullDouble("ex");
        info.ey = element.pullDouble("ey");
        info.ez = element.pullDouble("ez");
        info.ppm = element.pullDouble("ppm");
        element.close();
        return info;
    }

    private Ellipsoid parseSpheroid(WKTElement parent) throws ParseException {
        WKTElement element = parent.pullElement("SPHEROID");
        CharSequence name = element.pullString("name");
        double semiMajorAxis = element.pullDouble("semiMajorAxis");
        double inverseFlattening = element.pullDouble("inverseFlattening");
        name = WKTParser.parseAuthority(element, name);
        element.close();
        if (inverseFlattening == 0.0) {
            inverseFlattening = Double.POSITIVE_INFINITY;
        }
        try {
            return this.factory.createFlattenedSphere(name, semiMajorAxis, inverseFlattening, Unit.METRE);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private Projection parseProjection(WKTElement parent, Ellipsoid ellipsoid, Unit unit) throws ParseException {
        WKTElement param;
        WKTElement element = parent.pullElement("PROJECTION");
        String classname = element.pullString("name");
        CharSequence name = WKTParser.parseAuthority(element, classname);
        element.close();
        ParameterList parameters = this.factory.createProjectionParameterList(classname);
        while ((param = parent.pullOptionalElement("PARAMETER")) != null) {
            String paramName = param.pullString("name");
            double paramValue = param.pullDouble("value");
            Unit paramUnit = DescriptorNaming.getParameterUnit(paramName);
            if (unit != null && paramUnit != null && paramUnit.canConvert(unit)) {
                paramValue = paramUnit.convert(paramValue, unit);
            }
            parameters.setParameter(paramName, paramValue);
        }
        if (ellipsoid != null) {
            Unit axisUnit = ellipsoid.getAxisUnit();
            parameters.setParameter("semi_major", Unit.METRE.convert(ellipsoid.getSemiMajorAxis(), axisUnit));
            parameters.setParameter("semi_minor", Unit.METRE.convert(ellipsoid.getSemiMinorAxis(), axisUnit));
        }
        try {
            return this.factory.createProjection(name, classname, parameters);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private HorizontalDatum parseDatum(WKTElement parent) throws ParseException {
        WKTElement element = parent.pullElement("DATUM");
        CharSequence name = element.pullString("name");
        Ellipsoid ellipsoid = this.parseSpheroid(element);
        WGS84ConversionInfo toWGS84 = WKTParser.parseToWGS84(element);
        name = WKTParser.parseAuthority(element, name);
        element.close();
        try {
            return this.factory.createHorizontalDatum(name, DatumType.GEOCENTRIC, ellipsoid, toWGS84);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private VerticalDatum parseVertDatum(WKTElement parent) throws ParseException {
        DatumType.Vertical type;
        WKTElement element = parent.pullElement("VERT_DATUM");
        CharSequence name = element.pullString("name");
        int datum = element.pullInteger("datum");
        name = WKTParser.parseAuthority(element, name);
        element.close();
        try {
            type = (DatumType.Vertical)DatumType.getEnum(datum);
        }
        catch (RuntimeException exception) {
            throw element.parseFailed(exception, Resources.format(77, new Integer(datum)));
        }
        try {
            return this.factory.createVerticalDatum(name, type);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private LocalDatum parseLocalDatum(WKTElement parent) throws ParseException {
        DatumType.Local type;
        WKTElement element = parent.pullElement("LOCAL_DATUM");
        CharSequence name = element.pullString("name");
        int datum = element.pullInteger("datum");
        name = WKTParser.parseAuthority(element, name);
        element.close();
        try {
            type = (DatumType.Local)DatumType.getEnum(datum);
        }
        catch (RuntimeException exception) {
            throw element.parseFailed(exception, Resources.format(77, new Integer(datum)));
        }
        try {
            return this.factory.createLocalDatum(name, type);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private LocalCoordinateSystem parseLocalCS(WKTElement parent) throws ParseException {
        WKTElement element = parent.pullElement("LOCAL_CS");
        CharSequence name = element.pullString("name");
        LocalDatum datum = this.parseLocalDatum(element);
        Unit unit = WKTParser.parseUnit(element, Unit.METRE);
        AxisInfo axis = this.parseAxis(element, true);
        ArrayList<AxisInfo> list = new ArrayList<AxisInfo>();
        do {
            list.add(axis);
        } while ((axis = this.parseAxis(element, false)) != null);
        name = WKTParser.parseAuthority(element, name);
        element.close();
        AxisInfo[] array = list.toArray(new AxisInfo[list.size()]);
        try {
            return this.factory.createLocalCoordinateSystem(name, datum, unit, array);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private GeocentricCoordinateSystem parseGeoCCS(WKTElement parent) throws ParseException {
        WKTElement element = parent.pullElement("GEOCCS");
        CharSequence name = element.pullString("name");
        HorizontalDatum datum = this.parseDatum(element);
        PrimeMeridian meridian = this.parsePrimem(element, Unit.DEGREE);
        Unit unit = WKTParser.parseUnit(element, Unit.METRE);
        AxisInfo[] axes = new AxisInfo[3];
        axes[0] = this.parseAxis(element, false);
        if (axes[0] != null) {
            axes[1] = this.parseAxis(element, true);
            axes[2] = this.parseAxis(element, true);
        } else {
            axes = GeocentricCoordinateSystem.DEFAULT_AXIS;
        }
        name = WKTParser.parseAuthority(element, name);
        element.close();
        try {
            return this.factory.createGeocentricCoordinateSystem(name, unit, datum, meridian, axes);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private VerticalCoordinateSystem parseVertCS(WKTElement parent) throws ParseException {
        WKTElement element = parent.pullElement("VERT_CS");
        if (element == null) {
            return null;
        }
        CharSequence name = element.pullString("name");
        VerticalDatum datum = this.parseVertDatum(element);
        Unit unit = WKTParser.parseUnit(element, Unit.METRE);
        AxisInfo axis = this.parseAxis(element, false);
        name = WKTParser.parseAuthority(element, name);
        element.close();
        if (axis == null) {
            axis = AxisInfo.ALTITUDE;
        }
        try {
            return this.factory.createVerticalCoordinateSystem(name, datum, unit, axis);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private GeographicCoordinateSystem parseGeoGCS(WKTElement parent) throws ParseException {
        AxisInfo axis1;
        WKTElement element = parent.pullElement("GEOGCS");
        CharSequence name = element.pullString("name");
        HorizontalDatum datum = this.parseDatum(element);
        Unit unit = WKTParser.parseUnit(element, Unit.RADIAN);
        PrimeMeridian meridian = this.parsePrimem(element, unit);
        AxisInfo axis0 = this.parseAxis(element, false);
        if (axis0 != null) {
            axis1 = this.parseAxis(element, true);
        } else {
            axis0 = AxisInfo.LONGITUDE;
            axis1 = AxisInfo.LATITUDE;
        }
        name = WKTParser.parseAuthority(element, name);
        element.close();
        try {
            return this.factory.createGeographicCoordinateSystem(name, unit, datum, meridian, axis0, axis1);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private ProjectedCoordinateSystem parseProjCS(WKTElement parent) throws ParseException {
        AxisInfo axis1;
        WKTElement element = parent.pullElement("PROJCS");
        CharSequence name = element.pullString("name");
        GeographicCoordinateSystem gcs = this.parseGeoGCS(element);
        Ellipsoid ellipsoid = gcs.getHorizontalDatum().getEllipsoid();
        Unit unit = WKTParser.parseUnit(element, Unit.METRE);
        Projection projection = this.parseProjection(element, ellipsoid, unit);
        AxisInfo axis0 = this.parseAxis(element, false);
        if (axis0 != null) {
            axis1 = this.parseAxis(element, true);
        } else {
            axis0 = AxisInfo.X;
            axis1 = AxisInfo.Y;
        }
        name = WKTParser.parseAuthority(element, name);
        element.close();
        try {
            return this.factory.createProjectedCoordinateSystem(name, gcs, projection, unit, axis0, axis1);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private CompoundCoordinateSystem parseCompdCS(WKTElement parent) throws ParseException {
        WKTElement element = parent.pullElement("COMPD_CS");
        CharSequence name = element.pullString("name");
        CoordinateSystem headCS = this.parseCoordinateSystem(element);
        CoordinateSystem tailCS = this.parseCoordinateSystem(element);
        name = WKTParser.parseAuthority(element, name);
        element.close();
        try {
            return this.factory.createCompoundCoordinateSystem(name, headCS, tailCS);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private CoordinateSystem parseCoordinateSystem(WKTElement element) throws ParseException {
        Object key = element.peek();
        if (key instanceof WKTElement) {
            String keyword = ((WKTElement)key).keyword.trim().toUpperCase(this.locale);
            if ("GEOGCS".equals(keyword)) {
                return this.parseGeoGCS(element);
            }
            if ("PROJCS".equals(keyword)) {
                return this.parseProjCS(element);
            }
            if ("GEOCCS".equals(keyword)) {
                return this.parseGeoCCS(element);
            }
            if ("VERT_CS".equals(keyword)) {
                return this.parseVertCS(element);
            }
            if ("LOCAL_CS".equals(keyword)) {
                return this.parseLocalCS(element);
            }
            if ("COMPD_CS".equals(keyword)) {
                return this.parseCompdCS(element);
            }
        }
        throw element.parseFailed(null, Resources.format(77, key));
    }

    protected Object parse(WKTElement element) throws ParseException {
        Object key = element.peek();
        if (key instanceof WKTElement) {
            String keyword = ((WKTElement)key).keyword.trim().toUpperCase(this.locale);
            if ("AXIS".equals(keyword)) {
                return this.parseAxis(element, true);
            }
            if ("PRIMEM".equals(keyword)) {
                return this.parsePrimem(element, Unit.DEGREE);
            }
            if ("TOWGS84".equals(keyword)) {
                return WKTParser.parseToWGS84(element);
            }
            if ("SPHEROID".equals(keyword)) {
                return this.parseSpheroid(element);
            }
            if ("DATUM".equals(keyword)) {
                return this.parseDatum(element);
            }
            if ("VERT_DATUM".equals(keyword)) {
                return this.parseVertDatum(element);
            }
            if ("LOCAL_DATUM".equals(keyword)) {
                return this.parseLocalDatum(element);
            }
        }
        return this.parseCoordinateSystem(element);
    }

    public CoordinateSystem parseCoordinateSystem(String text) throws ParseException {
        WKTElement element = this.getTree(text, new ParsePosition(0));
        CoordinateSystem cs = this.parseCoordinateSystem(element);
        element.close();
        return cs;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(obj);
    }
}

