/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.io.Serializable;
import org.geotools.pt.Matrix;
import org.geotools.resources.Utilities;
import org.geotools.util.Cloneable;

public class WGS84ConversionInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3427461418504464735L;
    public double dx;
    public double dy;
    public double dz;
    public double ex;
    public double ey;
    public double ez;
    public double ppm;
    public String areaOfUse;

    public Matrix getAffineTransform() {
        double S = 1.0 + this.ppm / 1000000.0;
        double RS = 4.84813681109536E-6 * S;
        return new Matrix(4, 4, new double[]{S, -this.ez * RS, this.ey * RS, this.dx, this.ez * RS, S, -this.ex * RS, this.dy, -this.ey * RS, this.ex * RS, S, this.dz, 0.0, 0.0, 0.0, 1.0});
    }

    public int hashCode() {
        long code = 3427461418504464735L;
        code = code * 37L + Double.doubleToLongBits(this.dx);
        code = code * 37L + Double.doubleToLongBits(this.dy);
        code = code * 37L + Double.doubleToLongBits(this.dz);
        code = code * 37L + Double.doubleToLongBits(this.ex);
        code = code * 37L + Double.doubleToLongBits(this.ey);
        code = code * 37L + Double.doubleToLongBits(this.ez);
        code = code * 37L + Double.doubleToLongBits(this.ppm);
        return (int)(code >>> 32) ^ (int)code;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            InternalError error = new InternalError(exception.getMessage());
            error.initCause(exception);
            throw error;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WGS84ConversionInfo) {
            WGS84ConversionInfo that = (WGS84ConversionInfo)object;
            return Double.doubleToLongBits(this.dx) == Double.doubleToLongBits(that.dx) && Double.doubleToLongBits(this.dy) == Double.doubleToLongBits(that.dy) && Double.doubleToLongBits(this.dz) == Double.doubleToLongBits(that.dz) && Double.doubleToLongBits(this.ex) == Double.doubleToLongBits(that.ex) && Double.doubleToLongBits(this.ey) == Double.doubleToLongBits(that.ey) && Double.doubleToLongBits(this.ez) == Double.doubleToLongBits(that.ez) && Double.doubleToLongBits(this.ppm) == Double.doubleToLongBits(that.ppm) && Utilities.equals((Object)this.areaOfUse, (Object)that.areaOfUse);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("TOWGS84[");
        buffer.append(this.dx);
        buffer.append(", ");
        buffer.append(this.dy);
        buffer.append(", ");
        buffer.append(this.dz);
        buffer.append(", ");
        buffer.append(this.ex);
        buffer.append(", ");
        buffer.append(this.ey);
        buffer.append(", ");
        buffer.append(this.ez);
        buffer.append(", ");
        buffer.append(this.ppm);
        buffer.append(']');
        return buffer.toString();
    }
}

