/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.Datum;
import org.geotools.cs.Info;
import org.geotools.cs.VerticalDatum;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.opengis.cs.CS_LinearUnit;
import org.opengis.cs.CS_VerticalCoordinateSystem;
import org.opengis.cs.CS_VerticalDatum;

public class VerticalCoordinateSystem
extends CoordinateSystem {
    private static final long serialVersionUID = -8629573233560414552L;
    public static final VerticalCoordinateSystem ELLIPSOIDAL = (VerticalCoordinateSystem)pool.canonicalize((Object)new VerticalCoordinateSystem("Ellipsoidal", VerticalDatum.ELLIPSOIDAL));
    private final VerticalDatum datum;
    private final Unit unit;
    private final AxisInfo axis;

    public VerticalCoordinateSystem(CharSequence name, VerticalDatum datum) {
        this(name, datum, Unit.METRE, AxisInfo.ALTITUDE);
    }

    public VerticalCoordinateSystem(CharSequence name, VerticalDatum datum, Unit unit, AxisInfo axis) {
        super(name);
        this.datum = datum;
        this.unit = unit;
        this.axis = axis;
        VerticalCoordinateSystem.ensureNonNull("datum", datum);
        VerticalCoordinateSystem.ensureNonNull("unit", unit);
        VerticalCoordinateSystem.ensureNonNull("axis", axis);
        VerticalCoordinateSystem.ensureLinearUnit(unit);
        this.checkAxis(datum.getDatumType());
    }

    public final int getDimension() {
        return 1;
    }

    final Datum getDatum() {
        return this.getVerticalDatum();
    }

    public VerticalDatum getVerticalDatum() {
        return this.datum;
    }

    public AxisInfo getAxis(int dimension) {
        int maxDim = this.getDimension();
        if (dimension >= 0 && dimension < maxDim) {
            return this.axis;
        }
        throw new IndexOutOfBoundsException(Resources.format(56, new Integer(dimension)));
    }

    public Unit getUnits(int dimension) {
        int maxDim = this.getDimension();
        if (dimension >= 0 && dimension < maxDim) {
            return this.unit;
        }
        throw new IndexOutOfBoundsException(Resources.format(56, new Integer(dimension)));
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            VerticalCoordinateSystem that = (VerticalCoordinateSystem)object;
            return VerticalCoordinateSystem.equals(this.datum, that.datum, compareNames) && VerticalCoordinateSystem.equals(this.unit, that.unit) && VerticalCoordinateSystem.equals(this.axis, that.axis);
        }
        return false;
    }

    public int hashCode() {
        return -1838573912 + 37 * (this.datum.hashCode() + 37 * (this.unit.hashCode() + 37 * this.axis.hashCode()));
    }

    String addString(StringBuffer buffer, Unit context) {
        buffer.append(", ");
        buffer.append(this.datum);
        buffer.append(", ");
        this.addUnit(buffer, this.unit);
        buffer.append(", ");
        buffer.append(this.axis);
        return "VERT_CS";
    }

    final Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    private final class Export
    extends CoordinateSystem.Export
    implements CS_VerticalCoordinateSystem {
        protected Export(Object adapters) throws RemoteException {
            super(VerticalCoordinateSystem.this, adapters);
        }

        public CS_VerticalDatum getVerticalDatum() throws RemoteException {
            return this.adapters.export(VerticalCoordinateSystem.this.getVerticalDatum());
        }

        public CS_LinearUnit getVerticalUnit() throws RemoteException {
            return (CS_LinearUnit)this.adapters.export(VerticalCoordinateSystem.this.getUnits());
        }
    }
}

