/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.util.Date;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.Datum;
import org.geotools.cs.Info;
import org.geotools.cs.TemporalDatum;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;

public class TemporalCoordinateSystem
extends CoordinateSystem {
    private static final long serialVersionUID = 4436983518157910233L;
    private final TemporalDatum datum;
    private final AxisInfo axis;
    private final Unit unit;
    private final long epoch;

    public TemporalCoordinateSystem(CharSequence name, Date epoch) {
        this(name, TemporalDatum.UTC, Unit.DAY, epoch, AxisInfo.TIME);
    }

    public TemporalCoordinateSystem(CharSequence name, TemporalDatum datum, Unit unit, Date epoch, AxisInfo axis) {
        super(name);
        TemporalCoordinateSystem.ensureNonNull("datum", datum);
        TemporalCoordinateSystem.ensureNonNull("unit", unit);
        TemporalCoordinateSystem.ensureNonNull("epoch", epoch);
        TemporalCoordinateSystem.ensureNonNull("axis", axis);
        this.datum = datum;
        this.unit = unit;
        this.epoch = epoch.getTime();
        this.axis = axis;
        TemporalCoordinateSystem.ensureTimeUnit(unit);
        this.checkAxis(datum.getDatumType());
    }

    public final int getDimension() {
        return 1;
    }

    final Datum getDatum() {
        return this.getTemporalDatum();
    }

    public TemporalDatum getTemporalDatum() {
        return this.datum;
    }

    public Date getEpoch() {
        return new Date(this.epoch);
    }

    public AxisInfo getAxis(int dimension) {
        int maxDim = this.getDimension();
        if (dimension >= 0 && dimension < maxDim) {
            return this.axis;
        }
        throw new IndexOutOfBoundsException(Resources.format(56, new Integer(dimension)));
    }

    public Unit getUnits(int dimension) {
        int maxDim = this.getDimension();
        if (dimension >= 0 && dimension < maxDim) {
            return this.unit;
        }
        throw new IndexOutOfBoundsException(Resources.format(56, new Integer(dimension)));
    }

    public Date toDate(double value) {
        return new Date(Math.round(Unit.MILLISECOND.convert(value, this.unit)) + this.epoch);
    }

    public double toValue(Date time) {
        return this.unit.convert((double)(time.getTime() - this.epoch), Unit.MILLISECOND);
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            TemporalCoordinateSystem that = (TemporalCoordinateSystem)object;
            return TemporalCoordinateSystem.equals(this.datum, that.datum, compareNames) && TemporalCoordinateSystem.equals(this.unit, that.unit) && TemporalCoordinateSystem.equals(this.axis, that.axis);
        }
        return false;
    }

    public int hashCode() {
        return 1779478745 + 37 * (this.datum.hashCode() + 37 * (this.unit.hashCode() + 37 * this.axis.hashCode()));
    }

    String addString(StringBuffer buffer, Unit context) {
        buffer.append(", ");
        buffer.append(this.datum);
        buffer.append(", ");
        this.addUnit(buffer, this.unit);
        buffer.append(", ");
        buffer.append(this.axis);
        return "TEMPORAL_CS";
    }
}

