/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import org.geotools.cs.Ellipsoid;
import org.geotools.units.Unit;

final class Spheroid
extends Ellipsoid {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Spheroid(CharSequence name, double radius, boolean ivfDefinitive, Unit unit) {
        super(name, Spheroid.check("radius", radius), radius, Double.POSITIVE_INFINITY, ivfDefinitive, unit);
    }

    public double orthodromicDistance(double x1, double y1, double x2, double y2) {
        y1 = Math.toRadians(y1);
        y2 = Math.toRadians(y2);
        double dx = Math.toRadians(Math.abs(x2 - x1) % 360.0);
        double rho = Math.sin(y1) * Math.sin(y2) + Math.cos(y1) * Math.cos(y2) * Math.cos(dx);
        if (!$assertionsDisabled && !(Math.abs(rho) < 1.0000001)) {
            throw new AssertionError(rho);
        }
        if (rho > 1.0) {
            rho = 1.0;
        }
        if (rho < -1.0) {
            rho = -1.0;
        }
        double distance = Math.acos(rho) * this.getSemiMajorAxis();
        try {
            double delta;
            if (!$assertionsDisabled && !((delta = Math.abs(super.orthodromicDistance(x1, Math.toDegrees(y1), x2, Math.toDegrees(y2)) - distance)) < this.getSemiMajorAxis() / 1.0E9)) {
                throw new AssertionError(delta);
            }
        }
        catch (ArithmeticException exception) {
            // empty catch block
        }
        return distance;
    }

    static {
        $assertionsDisabled = !Spheroid.class.desiredAssertionStatus();
    }
}

