/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.awt.geom.Point2D;
import java.rmi.RemoteException;
import java.util.Locale;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.ParameterListImpl;
import org.geotools.cs.Ellipsoid;
import org.geotools.cs.Info;
import org.geotools.ct.MathTransformProvider;
import org.geotools.ct.MissingParameterException;
import org.geotools.resources.DescriptorNaming;
import org.geotools.resources.Utilities;
import org.geotools.units.Unit;
import org.opengis.cs.CS_Projection;
import org.opengis.cs.CS_ProjectionParameter;

public class Projection
extends Info {
    private static final long serialVersionUID = 2153398430020498215L;
    private final String classification;
    private final ParameterList parameters;

    public Projection(CharSequence name, String classification, Ellipsoid ellipsoid, Point2D centre, Point2D translation) {
        super(name);
        Projection.ensureNonNull("classification", classification);
        this.classification = classification;
        this.parameters = Projection.init(Projection.getParameterList(classification), ellipsoid, centre, translation);
    }

    public Projection(CharSequence name, String classification, ParameterList parameters) {
        super(name);
        Projection.ensureNonNull("classification", classification);
        Projection.ensureNonNull("parameters", parameters);
        this.classification = classification;
        this.parameters = Projection.clone(parameters);
    }

    static ParameterList getParameterList(String classification) {
        return DescriptorNaming.PROJECTIONS.getParameterList(classification, MathTransformProvider.DEFAULT_PROJECTION_DESCRIPTOR);
    }

    static ParameterList init(ParameterList parameters, Ellipsoid ellipsoid, Point2D centre, Point2D translation) {
        if (ellipsoid != null) {
            Unit axisUnit = ellipsoid.getAxisUnit();
            parameters.setParameter("semi_major", Unit.METRE.convert(ellipsoid.getSemiMajorAxis(), axisUnit));
            parameters.setParameter("semi_minor", Unit.METRE.convert(ellipsoid.getSemiMinorAxis(), axisUnit));
        }
        if (centre != null) {
            parameters.setParameter("central_meridian", centre.getX());
            parameters.setParameter("latitude_of_origin", centre.getY());
        }
        if (translation != null) {
            parameters.setParameter("false_easting", translation.getX());
            parameters.setParameter("false_northing", translation.getY());
        }
        return parameters;
    }

    private static ParameterList clone(ParameterList list) {
        if (list == null) {
            return null;
        }
        ParameterListDescriptor descriptor = list.getParameterListDescriptor();
        ParameterListImpl copy = new ParameterListImpl(descriptor);
        String[] names = descriptor.getParamNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                Object value;
                String name = names[i];
                try {
                    value = list.getObjectParameter(name);
                }
                catch (IllegalStateException exception) {
                    continue;
                }
                copy.setParameter(name, value);
            }
        }
        return copy;
    }

    String getWKTName(Locale locale) {
        return this.getClassName();
    }

    public String getClassName() {
        return this.classification;
    }

    public ParameterList getParameters() {
        return Projection.clone(this.parameters);
    }

    public double getValue(String name) throws MissingParameterException {
        return Projection.getValue(this.parameters, name, Double.NaN, true);
    }

    public double getValue(String name, double defaultValue) {
        try {
            return Projection.getValue(this.parameters, name, defaultValue, false);
        }
        catch (MissingParameterException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private static double getValue(ParameterList parameters, String name, double defaultValue, boolean required) throws MissingParameterException {
        name = name.trim();
        RuntimeException cause = null;
        if (parameters != null) {
            try {
                Object value = parameters.getObjectParameter(name);
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                return parameters.getDoubleParameter(name);
            }
            catch (IllegalArgumentException exception) {
                cause = exception;
            }
            catch (IllegalStateException exception) {
                cause = exception;
            }
        }
        if (!required) {
            return defaultValue;
        }
        MissingParameterException exception = new MissingParameterException(null, name);
        if (cause != null) {
            exception.initCause(cause);
        }
        throw exception;
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            Projection that = (Projection)object;
            return Utilities.equals((Object)this.classification, (Object)that.classification) && DescriptorNaming.equals(this.parameters, that.parameters);
        }
        return false;
    }

    public int hashCode() {
        int code = -2126417113;
        if (this.classification != null) {
            code = code * 37 + this.classification.hashCode();
        }
        return code;
    }

    String addString(StringBuffer buffer, Unit context) {
        return "PROJECTION";
    }

    final void addParameters(StringBuffer buffer, Unit context) {
        String[] names = this.parameters.getParameterListDescriptor().getParamNames();
        for (int i = 0; i < names.length; ++i) {
            Unit paramUnit;
            double value;
            String name = names[i];
            try {
                value = this.parameters.getDoubleParameter(name);
            }
            catch (IllegalStateException exception) {
                continue;
            }
            if (context != null && (paramUnit = DescriptorNaming.getParameterUnit(name)) != null && context.canConvert(paramUnit)) {
                value = context.convert(value, paramUnit);
            }
            buffer.append("PARAMETER[\"");
            buffer.append(name);
            buffer.append("\", ");
            buffer.append(value);
            buffer.append("], ");
        }
    }

    final Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    private final class Export
    extends Info.Export
    implements CS_Projection {
        private transient CS_ProjectionParameter[] parameters;

        protected Export(Object adapters) throws RemoteException {
            super(Projection.this, adapters);
        }

        public int getNumParameters() throws RemoteException {
            CS_ProjectionParameter[] parameters = this.getParameters();
            return parameters != null ? parameters.length : 0;
        }

        public CS_ProjectionParameter getParameter(int index) throws RemoteException {
            CS_ProjectionParameter[] parameters = this.getParameters();
            return (CS_ProjectionParameter)parameters[index].clone();
        }

        public String getClassName() throws RemoteException {
            return Projection.this.getClassName();
        }

        private synchronized CS_ProjectionParameter[] getParameters() {
            if (this.parameters == null) {
                this.parameters = this.adapters.exportProjectionParameters(Projection.this.getParameters());
            }
            return this.parameters;
        }
    }
}

