/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import javax.media.jai.ParameterList;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.Ellipsoid;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.HorizontalCoordinateSystem;
import org.geotools.cs.Info;
import org.geotools.cs.Projection;
import org.geotools.ct.MissingParameterException;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.opengis.cs.CS_GeographicCoordinateSystem;
import org.opengis.cs.CS_LinearUnit;
import org.opengis.cs.CS_ProjectedCoordinateSystem;
import org.opengis.cs.CS_Projection;

public class ProjectedCoordinateSystem
extends HorizontalCoordinateSystem {
    private static final long serialVersionUID = 5412822472156531329L;
    private static final double EPS = 1.0E-6;
    private final Unit unit;
    private final GeographicCoordinateSystem gcs;
    private final Projection projection;

    public ProjectedCoordinateSystem(CharSequence name, GeographicCoordinateSystem gcs, Projection projection) {
        this(name, gcs, projection, Unit.METRE, AxisInfo.X, AxisInfo.Y);
    }

    public ProjectedCoordinateSystem(CharSequence name, GeographicCoordinateSystem gcs, Projection projection, Unit unit, AxisInfo axis0, AxisInfo axis1) {
        super(name, gcs.getHorizontalDatum(), axis0, axis1);
        ProjectedCoordinateSystem.ensureNonNull("gcs", gcs);
        ProjectedCoordinateSystem.ensureNonNull("projection", projection);
        ProjectedCoordinateSystem.ensureNonNull("unit", unit);
        ProjectedCoordinateSystem.ensureLinearUnit(unit);
        Ellipsoid ellipsoid = this.getHorizontalDatum().getEllipsoid();
        Unit ellipsoidUnit = ellipsoid.getAxisUnit();
        double semiMajor = Unit.METRE.convert(ellipsoid.getSemiMajorAxis(), ellipsoidUnit);
        double semiMinor = Unit.METRE.convert(ellipsoid.getSemiMinorAxis(), ellipsoidUnit);
        String invalidParameter = null;
        boolean resetAxisLength = false;
        try {
            if (!(Math.abs(semiMinor - projection.getValue("semi_minor")) <= 1.0E-6)) {
                invalidParameter = "semi_minor";
            }
        }
        catch (MissingParameterException exception) {
            resetAxisLength = true;
        }
        try {
            if (!(Math.abs(semiMajor - projection.getValue("semi_major")) <= 1.0E-6)) {
                invalidParameter = "semi_major";
            }
        }
        catch (MissingParameterException exception) {
            resetAxisLength = true;
        }
        if (invalidParameter != null) {
            throw new IllegalArgumentException(Resources.format(55, invalidParameter, ellipsoid.getName(null)));
        }
        if (resetAxisLength) {
            ParameterList parameters = projection.getParameters();
            parameters.setParameter("semi_major", semiMajor);
            parameters.setParameter("semi_minor", semiMinor);
            projection = new Projection(projection.getName(null), projection.getClassName(), parameters);
        }
        this.gcs = gcs;
        this.projection = projection;
        this.unit = unit;
    }

    public GeographicCoordinateSystem getGeographicCoordinateSystem() {
        return this.gcs;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public Unit getUnits(int dimension) {
        if (dimension >= 0 && dimension < this.getDimension()) {
            return this.unit;
        }
        throw new IndexOutOfBoundsException(Resources.format(56, new Integer(dimension)));
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            ProjectedCoordinateSystem that = (ProjectedCoordinateSystem)object;
            return ProjectedCoordinateSystem.equals(this.gcs, that.gcs, compareNames) && ProjectedCoordinateSystem.equals(this.projection, that.projection, compareNames) && ProjectedCoordinateSystem.equals(this.unit, that.unit);
        }
        return false;
    }

    public int hashCode() {
        return 757353089 + 37 * (this.gcs.hashCode() + 37 * (this.projection.hashCode() + 37 * this.unit.hashCode()));
    }

    String addString(StringBuffer buffer, Unit context) {
        buffer.append(", ");
        buffer.append(this.gcs);
        buffer.append(", ");
        buffer.append(this.projection);
        buffer.append(", ");
        this.projection.addParameters(buffer, this.unit);
        this.addUnit(buffer, this.unit);
        buffer.append(", ");
        buffer.append(this.getAxis(0));
        buffer.append(", ");
        buffer.append(this.getAxis(1));
        return "PROJCS";
    }

    final Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    private final class Export
    extends HorizontalCoordinateSystem.Export
    implements CS_ProjectedCoordinateSystem {
        protected Export(Object adapters) throws RemoteException {
            super(adapters);
        }

        public CS_GeographicCoordinateSystem getGeographicCoordinateSystem() throws RemoteException {
            return this.adapters.export(ProjectedCoordinateSystem.this.getGeographicCoordinateSystem());
        }

        public CS_LinearUnit getLinearUnit() throws RemoteException {
            return (CS_LinearUnit)this.adapters.export(ProjectedCoordinateSystem.this.getUnits());
        }

        public CS_Projection getProjection() throws RemoteException {
            return this.adapters.export(ProjectedCoordinateSystem.this.getProjection());
        }
    }
}

