/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import org.geotools.cs.Info;
import org.geotools.resources.Utilities;
import org.geotools.units.Unit;
import org.opengis.cs.CS_AngularUnit;
import org.opengis.cs.CS_PrimeMeridian;

public class PrimeMeridian
extends Info {
    private static final long serialVersionUID = 7570594768127669147L;
    public static final PrimeMeridian GREENWICH = (PrimeMeridian)pool.canonicalize((Object)new PrimeMeridian("Greenwich", Unit.DEGREE, 0.0));
    private final Unit unit;
    private final double longitude;

    public PrimeMeridian(CharSequence name, Unit unit, double longitude) {
        super(name);
        this.unit = unit;
        this.longitude = longitude;
        PrimeMeridian.ensureNonNull("unit", unit);
        PrimeMeridian.ensureAngularUnit(unit);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLongitude(Unit targetUnit) {
        return targetUnit.convert(this.getLongitude(), this.getAngularUnit());
    }

    public Unit getAngularUnit() {
        return this.unit;
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            PrimeMeridian that = (PrimeMeridian)object;
            return Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(that.longitude) && Utilities.equals((Object)this.unit, (Object)that.unit);
        }
        return false;
    }

    public int hashCode() {
        long code = 7570594768127669147L;
        return (int)((code ^= Double.doubleToLongBits(this.longitude)) >>> 32) ^ (int)code;
    }

    String addString(StringBuffer buffer, Unit context) {
        if (context == null) {
            context = Unit.DEGREE;
        }
        buffer.append(", ");
        buffer.append(context.convert(this.longitude, this.unit));
        return "PRIMEM";
    }

    final Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    private final class Export
    extends Info.Export
    implements CS_PrimeMeridian {
        protected Export(Object adapters) throws RemoteException {
            super(adapters);
        }

        public double getLongitude() throws RemoteException {
            return PrimeMeridian.this.getLongitude();
        }

        public CS_AngularUnit getAngularUnit() throws RemoteException {
            return (CS_AngularUnit)this.adapters.export(PrimeMeridian.this.getAngularUnit());
        }
    }
}

