/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Locale;
import javax.vecmath.MismatchedSizeException;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.Datum;
import org.geotools.cs.Info;
import org.geotools.cs.LocalDatum;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.opengis.cs.CS_LocalCoordinateSystem;
import org.opengis.cs.CS_LocalDatum;

public class LocalCoordinateSystem
extends CoordinateSystem {
    private static final long serialVersionUID = -2067954038057402418L;
    public static final LocalCoordinateSystem CARTESIAN = new LocalCoordinateSystem((CharSequence)"Cartesian", LocalDatum.UNKNOW, Unit.METRE, new AxisInfo[]{AxisInfo.X, AxisInfo.Y}){

        public String getName(Locale locale) {
            return Resources.getResources(locale).getString(95);
        }
    };
    private final LocalDatum datum;
    private final Unit[] units;
    private final AxisInfo[] axes;

    static Unit[] expand(Unit unit, int count) {
        Object[] units = new Unit[count];
        Arrays.fill(units, unit);
        return units;
    }

    public LocalCoordinateSystem(CharSequence name, LocalDatum datum, Unit unit, AxisInfo[] axes) {
        this(name, datum, LocalCoordinateSystem.expand(unit, axes.length), axes);
    }

    public LocalCoordinateSystem(CharSequence name, LocalDatum datum, Unit[] units, AxisInfo[] axes) {
        super(name);
        LocalCoordinateSystem.ensureNonNull("datum", datum);
        LocalCoordinateSystem.ensureNonNull("units", units);
        LocalCoordinateSystem.ensureNonNull("axes", axes);
        if (units.length != axes.length) {
            throw new MismatchedSizeException();
        }
        this.datum = datum;
        this.units = (Unit[])units.clone();
        this.axes = (AxisInfo[])axes.clone();
        for (int i = 0; i < this.axes.length; ++i) {
            LocalCoordinateSystem.ensureNonNull("units", this.units, i);
            LocalCoordinateSystem.ensureNonNull("axes", this.axes, i);
        }
        this.checkAxis(datum.getDatumType());
    }

    final Datum getDatum() {
        return this.getLocalDatum();
    }

    public LocalDatum getLocalDatum() {
        return this.datum;
    }

    public int getDimension() {
        return this.axes.length;
    }

    public AxisInfo getAxis(int dimension) {
        return this.axes[dimension];
    }

    public Unit getUnits(int dimension) {
        return this.units[dimension];
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            LocalCoordinateSystem that = (LocalCoordinateSystem)object;
            return LocalCoordinateSystem.equals(this.datum, that.datum, compareNames) && Arrays.equals(this.units, that.units) && Arrays.equals(this.axes, that.axes);
        }
        return false;
    }

    public int hashCode() {
        return 1170276302 + 37 * this.datum.hashCode();
    }

    String addString(StringBuffer buffer, Unit context) {
        buffer.append(", ");
        buffer.append(this.datum);
        buffer.append(", ");
        this.addUnit(buffer, this.getUnits());
        for (int i = 0; i < this.axes.length; ++i) {
            buffer.append(", ");
            buffer.append(this.axes[i]);
        }
        return "LOCAL_CS";
    }

    final Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    private final class Export
    extends CoordinateSystem.Export
    implements CS_LocalCoordinateSystem {
        protected Export(Object adapters) throws RemoteException {
            super(adapters);
        }

        public CS_LocalDatum getLocalDatum() throws RemoteException {
            return this.adapters.export(LocalCoordinateSystem.this.getLocalDatum());
        }
    }
}

