/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.opengis.cs.CS_Info;

class InfoProperties
implements Map,
Serializable {
    private static final long serialVersionUID = 841701484507360819L;
    private static final String[] PROPERTY_KEYS = new String[]{"abbreviation", "alias", "authority", "authorityCode", "proxy", "remarks"};
    private String[] propertyKeys = PROPERTY_KEYS;
    private final Object[] properties = new Object[this.propertyKeys.length];

    public InfoProperties(Map map) {
        this.putAll(map);
        this.put("proxy", (Object)(map instanceof InfoProperties ? map.get("proxy") : null));
    }

    public final int size() {
        int count = 0;
        for (int i = 0; i < this.properties.length; ++i) {
            if (this.properties[i] == null) continue;
            ++count;
        }
        return count;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final boolean containsValue(Object value) {
        if (value != null) {
            for (int i = 0; i < this.properties.length; ++i) {
                if (!value.equals(this.properties[i])) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean containsKey(Object key) {
        return Arrays.binarySearch(this.propertyKeys, key) >= 0;
    }

    public Object get(Object key) {
        int i = Arrays.binarySearch(this.propertyKeys, key);
        return i >= 0 ? this.properties[i] : null;
    }

    public final Object put(Object key, Object value) {
        int i = Arrays.binarySearch(this.propertyKeys, key);
        if (i < 0) {
            throw new IllegalArgumentException(String.valueOf(key));
        }
        Object old = this.properties[i];
        this.properties[i] = value;
        return old;
    }

    public final Object remove(Object key) {
        return this.put(key, (Object)null);
    }

    public final void putAll(Map map) {
        if (map != null) {
            for (int i = 0; i < this.propertyKeys.length; ++i) {
                Object value = map.get(this.propertyKeys[i]);
                if (!(value instanceof String)) continue;
                this.properties[i] = value;
            }
        }
    }

    public final void clear() {
        Arrays.fill(this.properties, null);
    }

    public final Set keySet() {
        throw new UnsupportedOperationException();
    }

    public final Collection values() {
        throw new UnsupportedOperationException();
    }

    public final Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public final boolean equals(Object other) {
        if (other instanceof InfoProperties) {
            InfoProperties that = (InfoProperties)other;
            return Arrays.equals(this.properties, that.properties) && Arrays.equals(this.propertyKeys, that.propertyKeys);
        }
        return false;
    }

    public final int hashCode() {
        int code = 0;
        for (int i = 0; i < this.properties.length; ++i) {
            if (this.properties[i] == null) continue;
            code += this.properties[i].hashCode() ^ this.propertyKeys[i].hashCode();
        }
        return code;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (Arrays.equals(PROPERTY_KEYS, this.propertyKeys)) {
            this.propertyKeys = PROPERTY_KEYS;
        }
    }

    static final class Adapter
    extends Named {
        private static final long serialVersionUID = 7453632109986034253L;

        public Adapter(CS_Info info) throws RemoteException {
            super(info.getName());
            this.put("authority", info.getAuthority());
            this.put("authorityCode", info.getAuthorityCode());
            this.put("alias", info.getAlias());
            this.put("abbreviation", info.getAbbreviation());
            this.put("remarks", info.getRemarks());
            this.put("proxy", info);
        }
    }

    static class Named
    extends InfoProperties
    implements CharSequence {
        private static final long serialVersionUID = 7538378414620363218L;
        private final String name;

        public Named(String name) {
            super(null);
            this.name = name;
        }

        public final int length() {
            return this.name.length();
        }

        public final char charAt(int index) {
            return this.name.charAt(index);
        }

        public final CharSequence subSequence(int start, int end) {
            return this.name.substring(start, end);
        }

        public final String toString() {
            return this.name;
        }
    }
}

