/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Locale;
import java.util.Map;
import org.geotools.cs.Adapters;
import org.geotools.cs.InfoProperties;
import org.geotools.resources.RemoteProxy;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.geotools.util.WeakHashSet;
import org.opengis.cs.CS_AngularUnit;
import org.opengis.cs.CS_Info;
import org.opengis.cs.CS_LinearUnit;
import org.opengis.cs.CS_Unit;

public class Info
implements Serializable {
    private static final long serialVersionUID = -391073894118270236L;
    static final WeakHashSet pool = new WeakHashSet();
    private final String name;
    private final Map properties;
    private transient Object proxy;

    public Info(CharSequence name) {
        Info.ensureNonNull("name", name);
        this.name = ((Object)name).toString();
        if (name instanceof Map) {
            this.properties = new InfoProperties((Map)((Object)name));
            this.proxy = this.properties.get("proxy");
        } else {
            this.properties = null;
        }
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public String getAuthority(Locale locale) {
        return this.getProperty("authority");
    }

    public String getAuthorityCode(Locale locale) {
        return this.getProperty("authorityCode");
    }

    public String getAlias(Locale locale) {
        return this.getProperty("alias");
    }

    public String getAbbreviation(Locale locale) {
        return this.getProperty("abbreviation");
    }

    public String getRemarks(Locale locale) {
        return this.getProperty("remarks");
    }

    private String getProperty(String key) {
        return this.properties != null ? (String)this.properties.get(key) : null;
    }

    static boolean equals(Object object1, Object object2) {
        return Utilities.equals((Object)object1, (Object)object2);
    }

    static boolean equals(Info object1, Info object2, boolean compareNames) {
        return object1 == object2 || object1 != null && object1.equals(object2, compareNames);
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object != null && object.getClass().equals(this.getClass())) {
            if (!compareNames) {
                return true;
            }
            return Info.equals(this.name, object.name) && Info.equals(this.properties, object.properties);
        }
        return false;
    }

    public final boolean equals(Object object) {
        return object instanceof Info && this.equals((Info)object, true);
    }

    public int hashCode() {
        return 0x8426DAE4 ^ this.getClass().hashCode();
    }

    public String toString() {
        String WKT = this.getProperty("WKT");
        return WKT != null ? WKT : this.toString(null);
    }

    final String toString(Unit context) {
        String authority;
        Locale locale = null;
        StringBuffer buffer = new StringBuffer(40);
        buffer.append("[\"");
        buffer.append(this.getWKTName(locale));
        buffer.append('\"');
        buffer.insert(0, this.addString(buffer, context));
        if (this.properties != null && (authority = this.getAuthority(locale)) != null) {
            buffer.append(", AUTHORITY[\"");
            buffer.append(authority);
            String code = this.getAuthorityCode(locale);
            if (code != null) {
                buffer.append("\",\"");
                buffer.append(code);
            }
            buffer.append("\"]");
        }
        buffer.append(']');
        return buffer.toString();
    }

    String getWKTName(Locale locale) {
        return this.getName(locale);
    }

    String addString(StringBuffer buffer, Unit context) {
        return Utilities.getShortClassName((Object)this);
    }

    final void addUnit(StringBuffer buffer, Unit unit) {
        if (unit != null) {
            buffer.append("UNIT[\"");
            buffer.append(unit.getLocalizedName());
            buffer.append('\"');
            Unit base = null;
            if (Unit.METRE.canConvert(unit)) {
                base = Unit.METRE;
            } else if (Unit.RADIAN.canConvert(unit)) {
                base = Unit.RADIAN;
            } else if (Unit.SECOND.canConvert(unit)) {
                base = Unit.SECOND;
            }
            if (unit != null) {
                buffer.append(',');
                buffer.append(base.convert(1.0, unit));
            }
            buffer.append(']');
        }
    }

    protected static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Resources.format(73, name));
        }
    }

    static void ensureNonNull(String name, Object[] array, int index) throws IllegalArgumentException {
        if (array[index] == null) {
            throw new IllegalArgumentException(Resources.format(73, name + '[' + index + ']'));
        }
    }

    static void ensureTimeUnit(Unit unit) throws IllegalArgumentException {
        if (!Unit.SECOND.canConvert(unit)) {
            throw new IllegalArgumentException(Resources.format(65, unit));
        }
    }

    static void ensureLinearUnit(Unit unit) throws IllegalArgumentException {
        if (!Unit.METRE.canConvert(unit)) {
            throw new IllegalArgumentException(Resources.format(64, unit));
        }
    }

    static void ensureAngularUnit(Unit unit) throws IllegalArgumentException {
        if (!Unit.DEGREE.canConvert(unit)) {
            throw new IllegalArgumentException(Resources.format(63, unit));
        }
    }

    Object writeReplace() throws ObjectStreamException {
        return pool.canonicalize((Object)this);
    }

    Object readResolve() throws ObjectStreamException {
        return pool.canonicalize((Object)this);
    }

    Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    final synchronized Object cachedOpenGIS(Object adapters) throws RemoteException {
        if (this.proxy != null) {
            if (this.proxy instanceof Reference) {
                Object ref = ((Reference)this.proxy).get();
                if (ref != null) {
                    return ref;
                }
            } else {
                return this.proxy;
            }
        }
        Object opengis = this.toOpenGIS(adapters);
        this.proxy = new WeakReference<Object>(opengis);
        return opengis;
    }

    final class AngularUnit
    extends AbstractUnit
    implements CS_AngularUnit {
        public AngularUnit(Adapters adapters, double radiansPerUnit) throws RemoteException {
            super(adapters, radiansPerUnit);
        }

        public double getRadiansPerUnit() throws RemoteException {
            return this.scale;
        }
    }

    final class LinearUnit
    extends AbstractUnit
    implements CS_LinearUnit {
        public LinearUnit(Adapters adapters, double metersPerUnit) throws RemoteException {
            super(adapters, metersPerUnit);
        }

        public double getMetersPerUnit() throws RemoteException {
            return this.scale;
        }
    }

    class AbstractUnit
    extends Export
    implements CS_Unit {
        final double scale;

        public AbstractUnit(Adapters adapters, double scale) throws RemoteException {
            super(adapters);
            this.scale = scale;
        }

        public final String toString() {
            return "UNIT[\"" + Info.this.name + "\"," + this.scale + ']';
        }
    }

    class Export
    extends UnicastRemoteObject
    implements RemoteProxy,
    CS_Info {
        protected final Adapters adapters;

        protected Export(Object adapters) throws RemoteException {
            this.adapters = (Adapters)adapters;
        }

        public final Serializable getImplementation() throws RemoteException {
            return Info.this;
        }

        public String getName() throws RemoteException {
            return Info.this.getName(null);
        }

        public String getAuthority() throws RemoteException {
            return Info.this.getAuthority(null);
        }

        public String getAuthorityCode() throws RemoteException {
            return Info.this.getAuthorityCode(null);
        }

        public String getAlias() throws RemoteException {
            return Info.this.getAlias(null);
        }

        public String getAbbreviation() throws RemoteException {
            return Info.this.getAbbreviation(null);
        }

        public String getRemarks() throws RemoteException {
            return Info.this.getRemarks(null);
        }

        public String getWKT() throws RemoteException {
            return Info.this.toString();
        }

        public String getXML() throws RemoteException {
            throw new UnsupportedOperationException("XML formatting not yet implemented");
        }

        public String toString() {
            return Info.this.toString();
        }
    }
}

