/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import org.geotools.cs.Datum;
import org.geotools.cs.DatumType;
import org.geotools.cs.Ellipsoid;
import org.geotools.cs.Info;
import org.geotools.cs.WGS84ConversionInfo;
import org.geotools.units.Unit;
import org.opengis.cs.CS_Ellipsoid;
import org.opengis.cs.CS_HorizontalDatum;
import org.opengis.cs.CS_WGS84ConversionInfo;

public class HorizontalDatum
extends Datum {
    private static final long serialVersionUID = -1424482162002300865L;
    public static final HorizontalDatum WGS84 = (HorizontalDatum)pool.canonicalize((Object)new HorizontalDatum("WGS84", DatumType.GEOCENTRIC, Ellipsoid.WGS84, null));
    private final Ellipsoid ellipsoid;
    private final WGS84ConversionInfo parameters;

    public HorizontalDatum(CharSequence name, Ellipsoid ellipsoid) {
        this(name, DatumType.Horizontal.OTHER, ellipsoid, null);
    }

    public HorizontalDatum(CharSequence name, DatumType.Horizontal type, Ellipsoid ellipsoid, WGS84ConversionInfo toWGS84) {
        super(name, type);
        this.ellipsoid = ellipsoid;
        this.parameters = toWGS84 != null ? (WGS84ConversionInfo)toWGS84.clone() : null;
        HorizontalDatum.ensureNonNull("ellipsoid", ellipsoid);
    }

    public DatumType getDatumType() {
        return (DatumType.Horizontal)super.getDatumType();
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public WGS84ConversionInfo getWGS84Parameters() {
        return this.parameters != null ? (WGS84ConversionInfo)this.parameters.clone() : null;
    }

    String addString(StringBuffer buffer, Unit context) {
        buffer.append(", ");
        buffer.append(this.ellipsoid);
        if (this.parameters != null) {
            buffer.append(", ");
            buffer.append(this.parameters);
        }
        return "DATUM";
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            HorizontalDatum that = (HorizontalDatum)object;
            return HorizontalDatum.equals(this.ellipsoid, that.ellipsoid, compareNames) && HorizontalDatum.equals(this.parameters, that.parameters);
        }
        return false;
    }

    public int hashCode() {
        int code = 1492709439 + 37 * (super.hashCode() + 37 * this.ellipsoid.hashCode());
        if (this.parameters != null) {
            code += this.parameters.hashCode();
        }
        return code;
    }

    final Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    private final class Export
    extends Datum.Export
    implements CS_HorizontalDatum {
        protected Export(Object adapters) throws RemoteException {
            super(HorizontalDatum.this, adapters);
        }

        public CS_Ellipsoid getEllipsoid() throws RemoteException {
            return this.adapters.export(HorizontalDatum.this.getEllipsoid());
        }

        public CS_WGS84ConversionInfo getWGS84Parameters() throws RemoteException {
            return this.adapters.export(HorizontalDatum.this.getWGS84Parameters());
        }
    }
}

