/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.Datum;
import org.geotools.cs.HorizontalDatum;
import org.geotools.cs.Info;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.opengis.cs.CS_HorizontalCoordinateSystem;
import org.opengis.cs.CS_HorizontalDatum;

public abstract class HorizontalCoordinateSystem
extends CoordinateSystem {
    private static final long serialVersionUID = 350661821531782559L;
    private final HorizontalDatum datum;
    private final AxisInfo axis0;
    private final AxisInfo axis1;

    public HorizontalCoordinateSystem(CharSequence name, HorizontalDatum datum, AxisInfo axis0, AxisInfo axis1) {
        super(name);
        this.datum = datum;
        this.axis0 = axis0;
        this.axis1 = axis1;
        HorizontalCoordinateSystem.ensureNonNull("datum", datum);
        HorizontalCoordinateSystem.ensureNonNull("axis0", axis0);
        HorizontalCoordinateSystem.ensureNonNull("axis1", axis1);
        this.checkAxis(datum.getDatumType());
    }

    public final int getDimension() {
        return 2;
    }

    final Datum getDatum() {
        return this.getHorizontalDatum();
    }

    public HorizontalDatum getHorizontalDatum() {
        return this.datum;
    }

    public AxisInfo getAxis(int dimension) {
        switch (dimension) {
            case 0: {
                return this.axis0;
            }
            case 1: {
                return this.axis1;
            }
        }
        throw new IndexOutOfBoundsException(Resources.format(56, new Integer(dimension)));
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            HorizontalCoordinateSystem that = (HorizontalCoordinateSystem)object;
            return HorizontalCoordinateSystem.equals(this.datum, that.datum, compareNames) && HorizontalCoordinateSystem.equals(this.axis0, that.axis0) && HorizontalCoordinateSystem.equals(this.axis1, that.axis1);
        }
        return false;
    }

    public int hashCode() {
        return -1666089569 + 37 * (this.datum.hashCode() + 37 * (this.axis0.hashCode() + 37 * this.axis1.hashCode()));
    }

    String addString(StringBuffer buffer, Unit context) {
        buffer.append(", ");
        buffer.append(this.datum);
        buffer.append(", ");
        buffer.append(this.axis0);
        buffer.append(", ");
        buffer.append(this.axis1);
        return "HORZ_CS";
    }

    Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    class Export
    extends CoordinateSystem.Export
    implements CS_HorizontalCoordinateSystem {
        protected Export(Object adapters) throws RemoteException {
            super(HorizontalCoordinateSystem.this, adapters);
        }

        public CS_HorizontalDatum getHorizontalDatum() throws RemoteException {
            return this.adapters.export(HorizontalCoordinateSystem.this.getHorizontalDatum());
        }
    }
}

