/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Set;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.AxisOrientation;
import org.geotools.cs.HorizontalCoordinateSystem;
import org.geotools.cs.HorizontalDatum;
import org.geotools.cs.Info;
import org.geotools.cs.PrimeMeridian;
import org.geotools.cs.WGS84ConversionInfo;
import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Envelope;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.opengis.cs.CS_AngularUnit;
import org.opengis.cs.CS_GeographicCoordinateSystem;
import org.opengis.cs.CS_PrimeMeridian;
import org.opengis.cs.CS_WGS84ConversionInfo;

public class GeographicCoordinateSystem
extends HorizontalCoordinateSystem {
    private static final long serialVersionUID = -2024367470686889008L;
    public static final GeographicCoordinateSystem WGS84 = (GeographicCoordinateSystem)pool.canonicalize((Object)new GeographicCoordinateSystem("WGS84", HorizontalDatum.WGS84));
    private final Unit unit;
    private final PrimeMeridian meridian;

    public GeographicCoordinateSystem(CharSequence name, HorizontalDatum datum) {
        this(name, Unit.DEGREE, datum, PrimeMeridian.GREENWICH, AxisInfo.LONGITUDE, AxisInfo.LATITUDE);
    }

    public GeographicCoordinateSystem(CharSequence name, Unit unit, HorizontalDatum datum, PrimeMeridian meridian, AxisInfo axis0, AxisInfo axis1) {
        super(name, datum, axis0, axis1);
        GeographicCoordinateSystem.ensureNonNull("unit", unit);
        GeographicCoordinateSystem.ensureNonNull("meridian", meridian);
        GeographicCoordinateSystem.ensureAngularUnit(unit);
        this.unit = unit;
        this.meridian = meridian;
    }

    public Unit getUnits(int dimension) {
        if (dimension >= 0 && dimension < this.getDimension()) {
            return this.unit;
        }
        throw new IndexOutOfBoundsException(Resources.format(56, new Integer(dimension)));
    }

    public PrimeMeridian getPrimeMeridian() {
        return this.meridian;
    }

    public Envelope getDefaultEnvelope() {
        int dimension = this.getDimension();
        CoordinatePoint minCP = new CoordinatePoint(dimension);
        CoordinatePoint maxCP = new CoordinatePoint(dimension);
        for (int i = 0; i < dimension; ++i) {
            double max;
            double min;
            Unit unit = this.getUnits(i);
            AxisOrientation orientation = this.getAxis((int)i).orientation;
            if (AxisOrientation.NORTH.equals(orientation.absolute())) {
                min = -90.0;
                max = 90.0;
            } else if (AxisOrientation.EAST.equals(orientation.absolute())) {
                min = -180.0;
                max = 180.0;
            } else {
                min = Double.NEGATIVE_INFINITY;
                max = Double.POSITIVE_INFINITY;
            }
            min = unit.convert(min, Unit.DEGREE);
            max = unit.convert(max, Unit.DEGREE);
            minCP.ord[i] = Math.min(min, max);
            maxCP.ord[i] = Math.max(min, max);
        }
        return new Envelope(minCP, maxCP);
    }

    public Set getWGS84ConversionInfos() {
        return Collections.EMPTY_SET;
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            GeographicCoordinateSystem that = (GeographicCoordinateSystem)object;
            return GeographicCoordinateSystem.equals(this.unit, that.unit) && GeographicCoordinateSystem.equals(this.meridian, that.meridian, compareNames);
        }
        return false;
    }

    public int hashCode() {
        return -824566832 + 37 * (this.unit.hashCode() + 37 * this.meridian.hashCode());
    }

    String addString(StringBuffer buffer, Unit context) {
        buffer.append(", ");
        buffer.append(this.getHorizontalDatum());
        buffer.append(", ");
        buffer.append(this.meridian.toString(this.unit));
        buffer.append(", ");
        this.addUnit(buffer, this.unit);
        buffer.append(", ");
        buffer.append(this.getAxis(0));
        buffer.append(", ");
        buffer.append(this.getAxis(1));
        return "GEOGCS";
    }

    final Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    private final class Export
    extends HorizontalCoordinateSystem.Export
    implements CS_GeographicCoordinateSystem {
        private transient WGS84ConversionInfo[] infos;

        protected Export(Object adapters) throws RemoteException {
            super(adapters);
        }

        public CS_AngularUnit getAngularUnit() throws RemoteException {
            return (CS_AngularUnit)this.adapters.export(GeographicCoordinateSystem.this.getUnits());
        }

        public CS_PrimeMeridian getPrimeMeridian() throws RemoteException {
            return this.adapters.export(GeographicCoordinateSystem.this.getPrimeMeridian());
        }

        public int getNumConversionToWGS84() throws RemoteException {
            WGS84ConversionInfo[] infos = this.getWGS84ConversionInfos();
            return infos != null ? infos.length : 0;
        }

        public CS_WGS84ConversionInfo getWGS84ConversionInfo(int index) throws RemoteException {
            WGS84ConversionInfo[] infos = this.getWGS84ConversionInfos();
            return infos != null ? this.adapters.export(infos[index]) : null;
        }

        private synchronized WGS84ConversionInfo[] getWGS84ConversionInfos() {
            Set set;
            if (this.infos == null && (set = GeographicCoordinateSystem.this.getWGS84ConversionInfos()) != null) {
                this.infos = set.toArray(new WGS84ConversionInfo[set.size()]);
            }
            return this.infos;
        }
    }
}

