/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import java.util.Arrays;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.AxisOrientation;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.Datum;
import org.geotools.cs.HorizontalDatum;
import org.geotools.cs.Info;
import org.geotools.cs.PrimeMeridian;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.opengis.cs.CS_GeocentricCoordinateSystem;
import org.opengis.cs.CS_HorizontalDatum;
import org.opengis.cs.CS_LinearUnit;
import org.opengis.cs.CS_PrimeMeridian;

public class GeocentricCoordinateSystem
extends CoordinateSystem {
    private static final long serialVersionUID = -6577810243397267703L;
    static final AxisInfo[] DEFAULT_AXIS = new AxisInfo[]{new AxisInfo("x", AxisOrientation.OTHER), new AxisInfo("y", AxisOrientation.EAST), new AxisInfo("z", AxisOrientation.NORTH)};
    public static final GeocentricCoordinateSystem DEFAULT = (GeocentricCoordinateSystem)pool.canonicalize((Object)new GeocentricCoordinateSystem("WGS84", Unit.METRE, HorizontalDatum.WGS84, PrimeMeridian.GREENWICH, DEFAULT_AXIS));
    private final Unit unit;
    private final HorizontalDatum datum;
    private final PrimeMeridian meridian;
    private final AxisInfo[] axis;

    public GeocentricCoordinateSystem(CharSequence name, HorizontalDatum datum) {
        this(name, Unit.METRE, datum, PrimeMeridian.GREENWICH);
    }

    public GeocentricCoordinateSystem(CharSequence name, Unit unit, HorizontalDatum datum, PrimeMeridian meridian) {
        this(name, unit, datum, meridian, DEFAULT_AXIS);
    }

    public GeocentricCoordinateSystem(CharSequence name, Unit unit, HorizontalDatum datum, PrimeMeridian meridian, AxisInfo[] axis) {
        super(name);
        this.unit = unit;
        this.datum = datum;
        this.meridian = meridian;
        GeocentricCoordinateSystem.ensureNonNull("axis", axis);
        GeocentricCoordinateSystem.ensureNonNull("unit", unit);
        GeocentricCoordinateSystem.ensureNonNull("datum", datum);
        GeocentricCoordinateSystem.ensureNonNull("meridian", meridian);
        GeocentricCoordinateSystem.ensureLinearUnit(unit);
        this.axis = GeocentricCoordinateSystem.clone(axis);
    }

    private static AxisInfo[] clone(AxisInfo[] axis) {
        return Arrays.equals(axis, DEFAULT_AXIS) ? DEFAULT_AXIS : (AxisInfo[])axis.clone();
    }

    public int getDimension() {
        return this.axis.length;
    }

    final Datum getDatum() {
        return this.getHorizontalDatum();
    }

    public HorizontalDatum getHorizontalDatum() {
        return this.datum;
    }

    public Unit getUnits(int dimension) {
        if (dimension >= 0 && dimension < this.getDimension()) {
            return this.unit;
        }
        throw new IndexOutOfBoundsException(Resources.format(56, new Integer(dimension)));
    }

    public AxisInfo getAxis(int dimension) {
        return this.axis[dimension];
    }

    public PrimeMeridian getPrimeMeridian() {
        return this.meridian;
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            GeocentricCoordinateSystem that = (GeocentricCoordinateSystem)object;
            return GeocentricCoordinateSystem.equals(this.unit, that.unit) && GeocentricCoordinateSystem.equals(this.datum, that.datum, compareNames) && GeocentricCoordinateSystem.equals(this.meridian, that.meridian, compareNames);
        }
        return false;
    }

    public int hashCode() {
        return 845238025 + 37 * (this.datum.hashCode() + 37 * (this.unit.hashCode() + 37 * this.meridian.hashCode()));
    }

    String addString(StringBuffer buffer, Unit context) {
        buffer.append(", ");
        buffer.append(this.datum);
        buffer.append(", ");
        buffer.append(this.meridian);
        buffer.append(", ");
        this.addUnit(buffer, this.unit);
        for (int i = 0; i < this.axis.length; ++i) {
            buffer.append(", ");
            buffer.append(this.axis[i]);
        }
        return "GEOCCS";
    }

    final Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    private final class Export
    extends CoordinateSystem.Export
    implements CS_GeocentricCoordinateSystem {
        protected Export(Object adapters) throws RemoteException {
            super(GeocentricCoordinateSystem.this, adapters);
        }

        public CS_HorizontalDatum getHorizontalDatum() throws RemoteException {
            return this.adapters.export(GeocentricCoordinateSystem.this.getHorizontalDatum());
        }

        public CS_LinearUnit getLinearUnit() throws RemoteException {
            return (CS_LinearUnit)this.adapters.export(GeocentricCoordinateSystem.this.getUnits());
        }

        public CS_PrimeMeridian getPrimeMeridian() throws RemoteException {
            return this.adapters.export(GeocentricCoordinateSystem.this.getPrimeMeridian());
        }
    }
}

