/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import java.util.Arrays;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.Info;
import org.geotools.ct.MathTransform;
import org.geotools.pt.MismatchedDimensionException;
import org.geotools.units.Unit;
import org.opengis.cs.CS_CoordinateSystem;
import org.opengis.cs.CS_FittedCoordinateSystem;

public class FittedCoordinateSystem
extends CoordinateSystem {
    private static final long serialVersionUID = -3915469486263759761L;
    private final CoordinateSystem base;
    private final MathTransform toBase;
    private final AxisInfo[] axes;

    public FittedCoordinateSystem(CharSequence name, CoordinateSystem base, MathTransform toBase, AxisInfo[] axes) {
        super(name);
        int dim2;
        int i;
        FittedCoordinateSystem.ensureNonNull("base", base);
        FittedCoordinateSystem.ensureNonNull("toBase", toBase);
        this.base = base;
        this.toBase = toBase;
        if (axes != null) {
            axes = (AxisInfo[])axes.clone();
            this.axes = axes;
        } else {
            axes = new AxisInfo[base.getDimension()];
            this.axes = axes;
            for (i = 0; i < axes.length; ++i) {
                axes[i] = base.getAxis(i);
            }
        }
        for (i = 0; i < axes.length; ++i) {
            FittedCoordinateSystem.ensureNonNull("axes", axes, i);
        }
        int dim1 = toBase.getDimTarget();
        if (dim1 != (dim2 = base.getDimension())) {
            throw new MismatchedDimensionException(dim1, dim2);
        }
        dim1 = toBase.getDimSource();
        if (dim1 != (dim2 = axes.length)) {
            throw new MismatchedDimensionException(dim1, dim2);
        }
    }

    public CoordinateSystem getBaseCoordinateSystem() {
        return this.base;
    }

    public MathTransform getToBase() {
        return this.toBase;
    }

    public int getDimension() {
        return this.axes.length;
    }

    public AxisInfo getAxis(int dimension) {
        return this.axes[dimension];
    }

    public Unit getUnits(int dimension) {
        return this.base.getUnits(dimension);
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            FittedCoordinateSystem that = (FittedCoordinateSystem)object;
            return FittedCoordinateSystem.equals(this.base, that.base, compareNames) && FittedCoordinateSystem.equals(this.toBase, that.toBase) && Arrays.equals(this.axes, that.axes);
        }
        return false;
    }

    public int hashCode() {
        return 1314786415 + 37 * (this.base.hashCode() + 37 * this.toBase.hashCode());
    }

    String addString(StringBuffer buffer, Unit context) {
        buffer.append(", ");
        buffer.append(this.toBase);
        buffer.append(", ");
        buffer.append(this.base);
        return "FITTED_CS";
    }

    final Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    private final class Export
    extends CoordinateSystem.Export
    implements CS_FittedCoordinateSystem {
        protected Export(Object adapters) throws RemoteException {
            super(FittedCoordinateSystem.this, adapters);
        }

        public CS_CoordinateSystem getBaseCoordinateSystem() throws RemoteException {
            return this.adapters.export(FittedCoordinateSystem.this.base);
        }

        public String getToBase() throws RemoteException {
            return FittedCoordinateSystem.this.toBase.toString();
        }
    }
}

