/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.awt.geom.Point2D;
import java.rmi.RemoteException;
import org.geotools.cs.Info;
import org.geotools.cs.Spheroid;
import org.geotools.pt.CoordinateFormat;
import org.geotools.pt.CoordinatePoint;
import org.geotools.resources.Utilities;
import org.geotools.resources.XMath;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.opengis.cs.CS_Ellipsoid;
import org.opengis.cs.CS_LinearUnit;

public class Ellipsoid
extends Info {
    private static final long serialVersionUID = -1047804526105439230L;
    public static final Ellipsoid WGS84 = (Ellipsoid)pool.canonicalize((Object)Ellipsoid.createFlattenedSphere("WGS84", 6378137.0, 298.257223563, Unit.METRE));
    private final double semiMajorAxis;
    private final double semiMinorAxis;
    private final double inverseFlattening;
    private final boolean ivfDefinitive;
    private final Unit unit;

    protected Ellipsoid(CharSequence name, double semiMajorAxis, double semiMinorAxis, double inverseFlattening, boolean ivfDefinitive, Unit unit) {
        super(name);
        this.unit = unit;
        this.semiMajorAxis = Ellipsoid.check("semiMajorAxis", semiMajorAxis);
        this.semiMinorAxis = Ellipsoid.check("semiMinorAxis", semiMinorAxis);
        this.inverseFlattening = Ellipsoid.check("inverseFlattening", inverseFlattening);
        this.ivfDefinitive = ivfDefinitive;
        Ellipsoid.ensureNonNull("unit", unit);
        Ellipsoid.ensureLinearUnit(unit);
    }

    public static Ellipsoid createEllipsoid(CharSequence name, double semiMajorAxis, double semiMinorAxis, Unit unit) {
        if (semiMajorAxis == semiMinorAxis) {
            return new Spheroid(name, semiMajorAxis, false, unit);
        }
        return new Ellipsoid(name, semiMajorAxis, semiMinorAxis, semiMajorAxis / (semiMajorAxis - semiMinorAxis), false, unit);
    }

    public static Ellipsoid createFlattenedSphere(CharSequence name, double semiMajorAxis, double inverseFlattening, Unit unit) {
        if (Double.isInfinite(inverseFlattening)) {
            return new Spheroid(name, semiMajorAxis, true, unit);
        }
        return new Ellipsoid(name, semiMajorAxis, semiMajorAxis * (1.0 - 1.0 / inverseFlattening), inverseFlattening, true, unit);
    }

    static double check(String name, double value) throws IllegalArgumentException {
        if (value > 0.0) {
            return value;
        }
        throw new IllegalArgumentException(Resources.format(50, name, new Double(value)));
    }

    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    public double getEccentricity() {
        double f = 1.0 - this.getSemiMinorAxis() / this.getSemiMajorAxis();
        return Math.sqrt(2.0 * f - f * f);
    }

    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    public boolean isIvfDefinitive() {
        return this.ivfDefinitive;
    }

    public double orthodromicDistance(Point2D P1, Point2D P2) {
        return this.orthodromicDistance(P1.getX(), P1.getY(), P2.getX(), P2.getY());
    }

    public double orthodromicDistance(double x1, double y1, double x2, double y2) {
        x1 = Math.toRadians(x1);
        y1 = Math.toRadians(y1);
        x2 = Math.toRadians(x2);
        y2 = Math.toRadians(y2);
        int MAX_ITERATIONS = 100;
        double EPS = 5.0E-14;
        double F = 1.0 / this.getInverseFlattening();
        double R = 1.0 - F;
        double tu1 = R * Math.sin(y1) / Math.cos(y1);
        double tu2 = R * Math.sin(y2) / Math.cos(y2);
        double cu1 = 1.0 / Math.sqrt(tu1 * tu1 + 1.0);
        double cu2 = 1.0 / Math.sqrt(tu2 * tu2 + 1.0);
        double su1 = cu1 * tu1;
        double s = cu1 * cu2;
        double baz = s * tu2;
        double faz = baz * tu1;
        double x = x2 - x1;
        for (int i = 0; i < 100; ++i) {
            double sx = Math.sin(x);
            double cx = Math.cos(x);
            tu1 = cu2 * sx;
            tu2 = baz - su1 * cu2 * cx;
            double sy = XMath.hypot((double)tu1, (double)tu2);
            double cy = s * cx + faz;
            double y = Math.atan2(sy, cy);
            double SA = s * sx / sy;
            double c2a = 1.0 - SA * SA;
            double cz = faz + faz;
            if (c2a > 0.0) {
                cz = -cz / c2a + cy;
            }
            double e = cz * cz * 2.0 - 1.0;
            double c = ((-3.0 * c2a + 4.0) * F + 4.0) * c2a * F / 16.0;
            double d = x;
            x = ((e * cy * c + cz) * sy * c + y) * SA;
            if (!(Math.abs(d - (x = (1.0 - c) * x * F + x2 - x1)) <= 5.0E-14)) continue;
            x = Math.sqrt((1.0 / (R * R) - 1.0) * c2a + 1.0) + 1.0;
            x = (x - 2.0) / x;
            c = 1.0 - x;
            c = (x * x / 4.0 + 1.0) / c;
            d = (0.375 * x * x - 1.0) * x;
            x = e * cy;
            s = 1.0 - 2.0 * e;
            s = ((((sy * sy * 4.0 - 3.0) * s * cz * d / 6.0 - x) * d / 4.0 + cz) * sy * d + y) * c * R * this.getSemiMajorAxis();
            return s;
        }
        double LEPS = 1.0E-10;
        if (Math.abs(x1 - x2) <= 1.0E-10 && Math.abs(y1 - y2) <= 1.0E-10) {
            return 0.0;
        }
        if (Math.abs(y1) <= 1.0E-10 && Math.abs(y2) <= 1.0E-10) {
            return Math.abs(x1 - x2) * this.getSemiMajorAxis();
        }
        CoordinateFormat format = new CoordinateFormat();
        throw new ArithmeticException(Resources.format(90, format.format(new CoordinatePoint(Math.toDegrees(x1), Math.toDegrees(y1))), format.format(new CoordinatePoint(Math.toDegrees(x2), Math.toDegrees(y2)))));
    }

    public Unit getAxisUnit() {
        return this.unit;
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            Ellipsoid that = (Ellipsoid)object;
            return this.ivfDefinitive == that.ivfDefinitive && Double.doubleToLongBits(this.semiMajorAxis) == Double.doubleToLongBits(that.semiMajorAxis) && Double.doubleToLongBits(this.semiMinorAxis) == Double.doubleToLongBits(that.semiMinorAxis) && Double.doubleToLongBits(this.inverseFlattening) == Double.doubleToLongBits(that.inverseFlattening) && Utilities.equals((Object)this.unit, (Object)that.unit);
        }
        return false;
    }

    public int hashCode() {
        long longCode = 37L * Double.doubleToLongBits(this.semiMajorAxis);
        longCode = this.ivfDefinitive ? (long)((double)longCode + this.inverseFlattening) : (long)((double)longCode + this.semiMinorAxis);
        return (int)(longCode >>> 32) ^ (int)longCode;
    }

    String addString(StringBuffer buffer, Unit context) {
        double ivf = this.getInverseFlattening();
        buffer.append(", ");
        buffer.append(this.getSemiMajorAxis());
        buffer.append(", ");
        buffer.append(Double.isInfinite(ivf) ? 0.0 : ivf);
        return "SPHEROID";
    }

    final Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    private final class Export
    extends Info.Export
    implements CS_Ellipsoid {
        protected Export(Object adapters) throws RemoteException {
            super(Ellipsoid.this, adapters);
        }

        public double getSemiMajorAxis() throws RemoteException {
            return Ellipsoid.this.getSemiMajorAxis();
        }

        public double getSemiMinorAxis() throws RemoteException {
            return Ellipsoid.this.getSemiMinorAxis();
        }

        public double getInverseFlattening() throws RemoteException {
            double ivf = Ellipsoid.this.getInverseFlattening();
            return Double.isInfinite(ivf) ? 0.0 : ivf;
        }

        public boolean isIvfDefinitive() throws RemoteException {
            return Ellipsoid.this.isIvfDefinitive();
        }

        public CS_LinearUnit getAxisUnit() throws RemoteException {
            return (CS_LinearUnit)this.adapters.export(Ellipsoid.this.getAxisUnit());
        }
    }
}

