/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.io.ObjectStreamException;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.media.jai.EnumeratedParameter;
import org.geotools.cs.AxisOrientation;
import org.geotools.cs.Info;
import org.geotools.resources.cts.Resources;

public abstract class DatumType
extends EnumeratedParameter {
    private static final long serialVersionUID = 4829955972189625202L;
    public static final Horizontal CLASSIC = new Horizontal("CLASSIC", 1001, 5);
    public static final Horizontal GEOCENTRIC = new Horizontal("GEOCENTRIC", 1002, 15);
    public static final Vertical ORTHOMETRIC = new Vertical("ORTHOMETRIC", 2001, 28);
    public static final Vertical ELLIPSOIDAL = new Vertical("ELLIPSOIDAL", 2002, 13);
    public static final Vertical ALTITUDE_BAROMETRIC = new Vertical("ALTITUDE_BAROMETRIC", 2003, 3);
    public static final Vertical NORMAL = new Vertical("NORMAL", 2004, 26);
    public static final Vertical GEOID_MODEL_DERIVED = new Vertical("GEOID_MODEL_DERIVED", 2005, 16);
    public static final Vertical DEPTH = new Vertical("DEPTH", 2006, 9);
    public static final Temporal UTC = new Temporal("UTC", 3001, 39);
    public static final Temporal GMT = new Temporal("GMT", 3002, 17);
    public static final Local UNKNOW = new Local("UNKNOW", Short.MAX_VALUE, 94);
    private static final DatumType[] ENUMS = new DatumType[]{Horizontal.OTHER, CLASSIC, GEOCENTRIC, Vertical.OTHER, ORTHOMETRIC, ELLIPSOIDAL, ALTITUDE_BAROMETRIC, NORMAL, GEOID_MODEL_DERIVED, DEPTH, UTC, GMT, UNKNOW};
    private final transient int key;

    private DatumType(String name, int value, int key) {
        super(name, value);
        this.key = key;
        if (value < this.getMinimum() || value > this.getMaximum()) {
            throw new IllegalArgumentException(String.valueOf(value));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static DatumType getEnum(int value) {
        void var1_2;
        DatumType datum;
        for (int i = 0; i < ENUMS.length; ++i) {
            if (ENUMS[i].getValue() != value) continue;
            return ENUMS[i];
        }
        if (value >= 1000 && value <= 1999) {
            datum = new Horizontal("Custom", value, -1);
        } else if (value >= 2000 && value <= 2999) {
            datum = new Vertical("Custom", value, -1);
        } else if (value >= 3000 && value <= 3999) {
            datum = new Temporal("Custom", value, -1);
        } else if (value >= 10000 && value <= Short.MAX_VALUE) {
            datum = new Local("Custom", value, -1);
        } else {
            throw new IllegalArgumentException(String.valueOf(value));
        }
        return (DatumType)((Object)Info.pool.canonicalize((Object)var1_2));
    }

    public static DatumType getEnum(String name) {
        name = name.trim().replace(' ', '_');
        for (int i = 0; i < ENUMS.length; ++i) {
            DatumType candidate = ENUMS[i];
            if (!name.equalsIgnoreCase(candidate.getName())) continue;
            return candidate;
        }
        throw new NoSuchElementException(name);
    }

    public static DatumType getEnum(String name, Locale locale) {
        name = name.trim();
        Resources resources = Resources.getResources(locale);
        for (int i = 0; i < ENUMS.length; ++i) {
            DatumType candidate = ENUMS[i];
            if (!name.equalsIgnoreCase(resources.getString(candidate.key))) continue;
            return candidate;
        }
        throw new NoSuchElementException(name);
    }

    abstract boolean isCompatibleOrientation(AxisOrientation var1);

    abstract int getMinimum();

    abstract int getMaximum();

    abstract int getTypeKey();

    public String getType(Locale locale) {
        return Resources.getResources(locale).getString(this.getTypeKey());
    }

    public String getName(Locale locale) {
        return this.key >= 0 ? Resources.getResources(locale).getString(this.key) : this.getName();
    }

    public int hashCode() {
        return -752641166 + 37 * this.getValue();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(((Object)((Object)this)).getClass())) {
            DatumType that = (DatumType)((Object)obj);
            return that.getValue() == this.getValue();
        }
        return false;
    }

    private Object readResolve() throws ObjectStreamException {
        return DatumType.getEnum(this.getValue());
    }

    public static final class Local
    extends DatumType {
        private static final long serialVersionUID = 412409825333947716L;
        public static final int MINIMUM = 10000;
        public static final int MAXIMUM = Short.MAX_VALUE;

        private Local(String name, int value, int key) {
            super(name, value, key);
        }

        boolean isCompatibleOrientation(AxisOrientation orientation) {
            return true;
        }

        final int getMinimum() {
            return 10000;
        }

        final int getMaximum() {
            return Short.MAX_VALUE;
        }

        final int getTypeKey() {
            return 24;
        }
    }

    public static final class Temporal
    extends DatumType {
        private static final long serialVersionUID = 731901694455984836L;
        public static final int MINIMUM = 3000;
        public static final int MAXIMUM = 3999;

        private Temporal(String name, int value, int key) {
            super(name, value, key);
        }

        boolean isCompatibleOrientation(AxisOrientation orientation) {
            return AxisOrientation.FUTURE.equals(orientation) || AxisOrientation.PAST.equals(orientation);
        }

        final int getMinimum() {
            return 3000;
        }

        final int getMaximum() {
            return 3999;
        }

        final int getTypeKey() {
            return 34;
        }
    }

    public static final class Vertical
    extends DatumType {
        private static final long serialVersionUID = -916273252180448822L;
        public static final int MINIMUM = 2000;
        public static final int MAXIMUM = 2999;
        public static final Vertical OTHER = new Vertical("OTHER", 2000, 29);

        private Vertical(String name, int value, int key) {
            super(name, value, key);
        }

        boolean isCompatibleOrientation(AxisOrientation orientation) {
            return AxisOrientation.UP.equals(orientation) || AxisOrientation.DOWN.equals(orientation);
        }

        final int getMinimum() {
            return 2000;
        }

        final int getMaximum() {
            return 2999;
        }

        final int getTypeKey() {
            return 40;
        }
    }

    public static final class Horizontal
    extends DatumType {
        private static final long serialVersionUID = -9026322423891329754L;
        public static final int MINIMUM = 1000;
        public static final int MAXIMUM = 1999;
        public static final Horizontal OTHER = new Horizontal("OTHER", 1000, 29);

        private Horizontal(String name, int value, int key) {
            super(name, value, key);
        }

        boolean isCompatibleOrientation(AxisOrientation orientation) {
            return AxisOrientation.NORTH.equals(orientation) || AxisOrientation.SOUTH.equals(orientation) || AxisOrientation.EAST.equals(orientation) || AxisOrientation.WEST.equals(orientation);
        }

        final int getMinimum() {
            return 1000;
        }

        final int getMaximum() {
            return 1999;
        }

        final int getTypeKey() {
            return 18;
        }
    }
}

