/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import org.geotools.cs.DatumType;
import org.geotools.cs.Info;
import org.geotools.resources.Utilities;
import org.geotools.units.Unit;
import org.opengis.cs.CS_Datum;
import org.opengis.cs.CS_DatumType;

public class Datum
extends Info {
    private static final long serialVersionUID = 2175857309476007487L;
    private final DatumType type;

    public Datum(CharSequence name, DatumType type) {
        super(name);
        this.type = type;
        Datum.ensureNonNull("type", (Object)type);
    }

    public DatumType getDatumType() {
        return this.type;
    }

    public boolean equals(Info object, boolean compareNames) {
        if (super.equals(object, compareNames)) {
            Datum that = (Datum)object;
            return Utilities.equals((Object)((Object)this.type), (Object)((Object)that.type));
        }
        return false;
    }

    public int hashCode() {
        int code = -582930881;
        DatumType type = this.getDatumType();
        if (type != null) {
            code += type.hashCode();
        }
        return code;
    }

    String addString(StringBuffer buffer, Unit context) {
        buffer.append(", ");
        buffer.append(this.type.getValue());
        return "DATUM";
    }

    Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    class Export
    extends Info.Export
    implements CS_Datum {
        protected Export(Object adapters) throws RemoteException {
            super(Datum.this, adapters);
        }

        public CS_DatumType getDatumType() throws RemoteException {
            return this.adapters.export(Datum.this.getDatumType());
        }
    }
}

