/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.awt.geom.Point2D;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.Format;
import java.text.ParseException;
import java.util.Locale;
import javax.media.jai.ParameterList;
import org.geotools.cs.Adapters;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.CompoundCoordinateSystem;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.DatumType;
import org.geotools.cs.Ellipsoid;
import org.geotools.cs.FactoryException;
import org.geotools.cs.FittedCoordinateSystem;
import org.geotools.cs.GeocentricCoordinateSystem;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.HorizontalDatum;
import org.geotools.cs.Info;
import org.geotools.cs.LocalCoordinateSystem;
import org.geotools.cs.LocalDatum;
import org.geotools.cs.PrimeMeridian;
import org.geotools.cs.ProjectedCoordinateSystem;
import org.geotools.cs.Projection;
import org.geotools.cs.VerticalCoordinateSystem;
import org.geotools.cs.VerticalDatum;
import org.geotools.cs.WGS84ConversionInfo;
import org.geotools.cs.WKTParser;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransformFactory;
import org.geotools.units.Unit;
import org.geotools.util.WeakHashSet;
import org.opengis.cs.CS_AngularUnit;
import org.opengis.cs.CS_AxisInfo;
import org.opengis.cs.CS_CompoundCoordinateSystem;
import org.opengis.cs.CS_CoordinateSystem;
import org.opengis.cs.CS_CoordinateSystemFactory;
import org.opengis.cs.CS_DatumType;
import org.opengis.cs.CS_Ellipsoid;
import org.opengis.cs.CS_FittedCoordinateSystem;
import org.opengis.cs.CS_GeographicCoordinateSystem;
import org.opengis.cs.CS_HorizontalDatum;
import org.opengis.cs.CS_LinearUnit;
import org.opengis.cs.CS_LocalCoordinateSystem;
import org.opengis.cs.CS_LocalDatum;
import org.opengis.cs.CS_PrimeMeridian;
import org.opengis.cs.CS_ProjectedCoordinateSystem;
import org.opengis.cs.CS_Projection;
import org.opengis.cs.CS_ProjectionParameter;
import org.opengis.cs.CS_Unit;
import org.opengis.cs.CS_VerticalCoordinateSystem;
import org.opengis.cs.CS_VerticalDatum;
import org.opengis.cs.CS_WGS84ConversionInfo;

public class CoordinateSystemFactory {
    private static CoordinateSystemFactory DEFAULT;
    private transient WKTParser parser;
    private final WeakHashSet pool;
    private transient Object proxy;

    private CoordinateSystemFactory(WeakHashSet pool) {
        this.pool = pool;
    }

    protected CoordinateSystemFactory() {
        this(new WeakHashSet());
    }

    public static synchronized CoordinateSystemFactory getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new CoordinateSystemFactory(Info.pool);
        }
        return DEFAULT;
    }

    public GeocentricCoordinateSystem createGeocentricCoordinateSystem(CharSequence name, Unit unit, HorizontalDatum datum, PrimeMeridian meridian, AxisInfo[] axis) throws FactoryException {
        return (GeocentricCoordinateSystem)this.pool.canonicalize((Object)new GeocentricCoordinateSystem(name, unit, datum, meridian, axis));
    }

    public GeographicCoordinateSystem createGeographicCoordinateSystem(CharSequence name, HorizontalDatum datum) throws FactoryException {
        return this.createGeographicCoordinateSystem(name, Unit.DEGREE, datum, PrimeMeridian.GREENWICH, AxisInfo.LONGITUDE, AxisInfo.LATITUDE);
    }

    public GeographicCoordinateSystem createGeographicCoordinateSystem(CharSequence name, Unit unit, HorizontalDatum datum, PrimeMeridian meridian, AxisInfo axis0, AxisInfo axis1) throws FactoryException {
        return (GeographicCoordinateSystem)this.pool.canonicalize((Object)new GeographicCoordinateSystem(name, unit, datum, meridian, axis0, axis1));
    }

    public ProjectedCoordinateSystem createProjectedCoordinateSystem(CharSequence name, GeographicCoordinateSystem gcs, Projection projection) throws FactoryException {
        return this.createProjectedCoordinateSystem(name, gcs, projection, Unit.METRE, AxisInfo.X, AxisInfo.Y);
    }

    public ProjectedCoordinateSystem createProjectedCoordinateSystem(CharSequence name, GeographicCoordinateSystem gcs, Projection projection, Unit unit, AxisInfo axis0, AxisInfo axis1) throws FactoryException {
        return (ProjectedCoordinateSystem)this.pool.canonicalize((Object)new ProjectedCoordinateSystem(name, gcs, projection, unit, axis0, axis1));
    }

    public VerticalCoordinateSystem createVerticalCoordinateSystem(CharSequence name, VerticalDatum datum) throws FactoryException {
        return this.createVerticalCoordinateSystem(name, datum, Unit.METRE, AxisInfo.ALTITUDE);
    }

    public VerticalCoordinateSystem createVerticalCoordinateSystem(CharSequence name, VerticalDatum datum, Unit unit, AxisInfo axis) throws FactoryException {
        return (VerticalCoordinateSystem)this.pool.canonicalize((Object)new VerticalCoordinateSystem(name, datum, unit, axis));
    }

    public CompoundCoordinateSystem createCompoundCoordinateSystem(CharSequence name, CoordinateSystem head, CoordinateSystem tail) throws FactoryException {
        return (CompoundCoordinateSystem)this.pool.canonicalize((Object)new CompoundCoordinateSystem(name, head, tail));
    }

    public FittedCoordinateSystem createFittedCoordinateSystem(CharSequence name, CoordinateSystem base, MathTransform toBase, AxisInfo[] axes) throws FactoryException {
        return (FittedCoordinateSystem)this.pool.canonicalize((Object)new FittedCoordinateSystem(name, base, toBase, axes));
    }

    public LocalCoordinateSystem createLocalCoordinateSystem(CharSequence name, LocalDatum datum, Unit unit, AxisInfo[] axes) throws FactoryException {
        return this.createLocalCoordinateSystem(name, datum, LocalCoordinateSystem.expand(unit, axes.length), axes);
    }

    public LocalCoordinateSystem createLocalCoordinateSystem(CharSequence name, LocalDatum datum, Unit[] units, AxisInfo[] axes) throws FactoryException {
        return (LocalCoordinateSystem)this.pool.canonicalize((Object)new LocalCoordinateSystem(name, datum, units, axes));
    }

    public Ellipsoid createEllipsoid(CharSequence name, double semiMajorAxis, double semiMinorAxis, Unit unit) throws FactoryException {
        return (Ellipsoid)this.pool.canonicalize((Object)Ellipsoid.createEllipsoid(name, semiMajorAxis, semiMinorAxis, unit));
    }

    public Ellipsoid createFlattenedSphere(CharSequence name, double semiMajorAxis, double inverseFlattening, Unit unit) throws FactoryException {
        return (Ellipsoid)this.pool.canonicalize((Object)Ellipsoid.createFlattenedSphere(name, semiMajorAxis, inverseFlattening, unit));
    }

    public PrimeMeridian createPrimeMeridian(CharSequence name, Unit unit, double longitude) throws FactoryException {
        return (PrimeMeridian)this.pool.canonicalize((Object)new PrimeMeridian(name, unit, longitude));
    }

    public Projection createProjection(CharSequence name, String classification, ParameterList parameters) throws FactoryException {
        if (parameters == null) {
            parameters = this.createProjectionParameterList(classification);
        }
        return (Projection)this.pool.canonicalize((Object)new Projection(name, classification, parameters));
    }

    public Projection createProjection(CharSequence name, String classification, Ellipsoid ellipsoid, Point2D centre, Point2D translation) throws FactoryException {
        ParameterList param = this.createProjectionParameterList(classification);
        param = Projection.init(param, ellipsoid, centre, translation);
        return this.createProjection(name, classification, param);
    }

    public ParameterList createProjectionParameterList(String classification) {
        return Projection.getParameterList(classification);
    }

    public HorizontalDatum createHorizontalDatum(CharSequence name, DatumType.Horizontal type, Ellipsoid ellipsoid, WGS84ConversionInfo toWGS84) throws FactoryException {
        return (HorizontalDatum)this.pool.canonicalize((Object)new HorizontalDatum(name, type, ellipsoid, toWGS84));
    }

    public HorizontalDatum createHorizontalDatum(CharSequence name, Ellipsoid ellipsoid) throws FactoryException {
        return this.createHorizontalDatum(name, DatumType.Horizontal.OTHER, ellipsoid, null);
    }

    public VerticalDatum createVerticalDatum(CharSequence name, DatumType.Vertical type) throws FactoryException {
        return (VerticalDatum)this.pool.canonicalize((Object)new VerticalDatum(name, type));
    }

    public LocalDatum createLocalDatum(CharSequence name, DatumType.Local type) throws FactoryException {
        return (LocalDatum)this.pool.canonicalize((Object)new LocalDatum(name, type));
    }

    public CoordinateSystem createFromWKT(String text) throws FactoryException {
        if (this.parser == null) {
            this.parser = new WKTParser(Locale.US, this);
        }
        try {
            return this.parser.parseCoordinateSystem(text);
        }
        catch (ParseException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new FactoryException(exception.getLocalizedMessage(), exception);
        }
    }

    public Format getWKTFormat(Locale locale) {
        return new WKTParser(locale, this);
    }

    final synchronized Object toOpenGIS(Object adapters) throws RemoteException {
        if (this.proxy != null) {
            if (this.proxy instanceof Reference) {
                Object ref = ((Reference)this.proxy).get();
                if (ref != null) {
                    return ref;
                }
            } else {
                return this.proxy;
            }
        }
        Export opengis = new Export(adapters);
        this.proxy = new WeakReference<Export>(opengis);
        return opengis;
    }

    private final class Export
    extends UnicastRemoteObject
    implements CS_CoordinateSystemFactory {
        protected final Adapters adapters;

        protected Export(Object adapters) throws RemoteException {
            this.adapters = (Adapters)adapters;
        }

        public CoordinateSystemFactory getImplementation() {
            return CoordinateSystemFactory.this;
        }

        public CS_CoordinateSystem createFromXML(String xml) throws RemoteException {
            throw new UnsupportedOperationException("XML parsing not yet implemented");
        }

        public CS_CoordinateSystem createFromWKT(String text) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createFromWKT(text));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_CompoundCoordinateSystem createCompoundCoordinateSystem(String name, CS_CoordinateSystem head, CS_CoordinateSystem tail) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createCompoundCoordinateSystem(name, this.adapters.wrap(head), this.adapters.wrap(tail)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_FittedCoordinateSystem createFittedCoordinateSystem(String name, CS_CoordinateSystem base, String toBaseWKT, CS_AxisInfo[] axes) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createFittedCoordinateSystem(name, this.adapters.wrap(base), MathTransformFactory.getDefault().createFromWKT(toBaseWKT), this.adapters.wrap(axes)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_LocalCoordinateSystem createLocalCoordinateSystem(String name, CS_LocalDatum datum, CS_Unit unit, CS_AxisInfo[] arAxes) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createLocalCoordinateSystem((CharSequence)name, this.adapters.wrap(datum), this.adapters.wrap(unit), this.adapters.wrap(arAxes)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_Ellipsoid createEllipsoid(String name, double semiMajorAxis, double semiMinorAxis, CS_LinearUnit linearUnit) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createEllipsoid(name, semiMajorAxis, semiMinorAxis, this.adapters.wrap((CS_Unit)linearUnit)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_Ellipsoid createFlattenedSphere(String name, double semiMajorAxis, double inverseFlattening, CS_LinearUnit linearUnit) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createFlattenedSphere(name, semiMajorAxis, inverseFlattening, this.adapters.wrap((CS_Unit)linearUnit)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_ProjectedCoordinateSystem createProjectedCoordinateSystem(String name, CS_GeographicCoordinateSystem gcs, CS_Projection projection, CS_LinearUnit linearUnit, CS_AxisInfo axis0, CS_AxisInfo axis1) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createProjectedCoordinateSystem(name, this.adapters.wrap(gcs), this.adapters.wrap(projection), this.adapters.wrap((CS_Unit)linearUnit), this.adapters.wrap(axis0), this.adapters.wrap(axis1)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_Projection createProjection(String name, String wktProjectionClass, CS_ProjectionParameter[] parameters) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createProjection(name, wktProjectionClass, this.adapters.wrap(parameters)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_HorizontalDatum createHorizontalDatum(String name, CS_DatumType horizontalDatumType, CS_Ellipsoid ellipsoid, CS_WGS84ConversionInfo toWGS84) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createHorizontalDatum(name, (DatumType.Horizontal)this.adapters.wrap(horizontalDatumType), this.adapters.wrap(ellipsoid), this.adapters.wrap(toWGS84)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_PrimeMeridian createPrimeMeridian(String name, CS_AngularUnit angularUnit, double longitude) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createPrimeMeridian(name, this.adapters.wrap((CS_Unit)angularUnit), longitude));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_GeographicCoordinateSystem createGeographicCoordinateSystem(String name, CS_AngularUnit angularUnit, CS_HorizontalDatum horizontalDatum, CS_PrimeMeridian primeMeridian, CS_AxisInfo axis0, CS_AxisInfo axis1) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createGeographicCoordinateSystem(name, this.adapters.wrap((CS_Unit)angularUnit), this.adapters.wrap(horizontalDatum), this.adapters.wrap(primeMeridian), this.adapters.wrap(axis0), this.adapters.wrap(axis1)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_LocalDatum createLocalDatum(String name, CS_DatumType localDatumType) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createLocalDatum(name, (DatumType.Local)this.adapters.wrap(localDatumType)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_VerticalDatum createVerticalDatum(String name, CS_DatumType verticalDatumType) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createVerticalDatum(name, (DatumType.Vertical)this.adapters.wrap(verticalDatumType)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_VerticalCoordinateSystem createVerticalCoordinateSystem(String name, CS_VerticalDatum verticalDatum, CS_LinearUnit verticalUnit, CS_AxisInfo axis) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemFactory.this.createVerticalCoordinateSystem(name, this.adapters.wrap(verticalDatum), this.adapters.wrap((CS_Unit)verticalUnit), this.adapters.wrap(axis)));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }
    }
}

