/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.media.jai.ParameterList;
import javax.media.jai.util.CaselessStringKey;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.AxisOrientation;
import org.geotools.cs.CompoundCoordinateSystem;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.CoordinateSystemAuthorityFactory;
import org.geotools.cs.CoordinateSystemFactory;
import org.geotools.cs.Datum;
import org.geotools.cs.DatumType;
import org.geotools.cs.Ellipsoid;
import org.geotools.cs.FactoryException;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.Info;
import org.geotools.cs.InfoProperties;
import org.geotools.cs.NoSuchAuthorityCodeException;
import org.geotools.cs.PrimeMeridian;
import org.geotools.cs.ProjectedCoordinateSystem;
import org.geotools.cs.Projection;
import org.geotools.cs.VerticalCoordinateSystem;
import org.geotools.cs.WGS84ConversionInfo;
import org.geotools.resources.Arguments;
import org.geotools.resources.Geotools;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;

public class CoordinateSystemEPSGFactory
extends CoordinateSystemAuthorityFactory {
    private static CoordinateSystemEPSGFactory DEFAULT;
    private static final String DRIVER = "JDBC driver";
    private static final String DEFAULT_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    private static final String CONNECTION = "EPSG connection";
    private static final String DEFAULT_CONNECTION = "jdbc:odbc:EPSG";
    private static final String IMPLEMENTATION = "EPSG Factory";
    private static String[] DEFAULT_PARAM_MAP;
    private static final Map namesMap;
    private final Map statements = new IdentityHashMap();
    protected final Connection connection;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CoordinateSystemEPSGFactory(CoordinateSystemFactory factory, Connection connection) {
        super(factory);
        this.connection = connection;
        Info.ensureNonNull("connection", connection);
    }

    public CoordinateSystemEPSGFactory(CoordinateSystemFactory factory, String url, String driver) throws SQLException {
        this(factory, CoordinateSystemEPSGFactory.getConnection(url, driver));
    }

    private static CoordinateSystemEPSGFactory newInstance(CoordinateSystemFactory factory, String implementation, String url, String driver) throws SQLException {
        Class[] ARG_TYPES = new Class[]{CoordinateSystemFactory.class, String.class, String.class};
        try {
            return (CoordinateSystemEPSGFactory)Class.forName(implementation).getConstructor(ARG_TYPES).newInstance(factory, url, driver);
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getTargetException();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception cause) {
            IllegalStateException exception = new IllegalStateException(Resources.format(91, "-implementation", implementation));
            exception.initCause(cause);
            throw exception;
        }
    }

    public static synchronized CoordinateSystemAuthorityFactory getDefault() throws SQLException {
        if (DEFAULT == null) {
            Preferences prefs = Preferences.systemNodeForPackage(CoordinateSystemAuthorityFactory.class);
            String driver = prefs.get(DRIVER, DEFAULT_DRIVER);
            String connect = prefs.get(CONNECTION, DEFAULT_CONNECTION);
            String implement = prefs.get(IMPLEMENTATION, null);
            CoordinateSystemFactory factory = CoordinateSystemFactory.getDefault();
            DEFAULT = implement == null ? new CoordinateSystemEPSGFactory(factory, connect, driver) : CoordinateSystemEPSGFactory.newInstance(factory, implement, connect, driver);
            Runtime.getRuntime().addShutdownHook(new Thread("EPSG factory shutdown"){

                public void run() {
                    try {
                        DEFAULT.close(true);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            });
        }
        return DEFAULT;
    }

    protected String adaptSQL(String statement) {
        return statement;
    }

    public String getAuthority() {
        return "EPSG";
    }

    private static Connection getConnection(String url, String driver) throws SQLException {
        Info.ensureNonNull("url", url);
        if (driver != null) {
            LogRecord record;
            try {
                Driver drv = (Driver)Class.forName(driver).newInstance();
                record = Resources.getResources(null).getLogRecord(Level.CONFIG, 23);
                record.setParameters(new Object[]{drv.getClass().getName(), new Integer(drv.getMajorVersion()), new Integer(drv.getMinorVersion())});
            }
            catch (Exception exception) {
                record = new LogRecord(Level.WARNING, exception.getLocalizedMessage());
                record.setThrown(exception);
            }
            record.setSourceClassName("CoordinateSystemEPSGFactory");
            record.setSourceMethodName("<init>");
            Logger.getLogger("org.geotools.cs").log(record);
        }
        return DriverManager.getConnection(url);
    }

    private PreparedStatement prepareStatement(String key, String sql) throws SQLException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        PreparedStatement stmt = (PreparedStatement)this.statements.get(key);
        if (stmt == null) {
            stmt = this.connection.prepareStatement(this.adaptSQL(sql));
            this.statements.put(key, stmt);
        }
        return stmt;
    }

    private static String getString(ResultSet result, int columnIndex, String line) throws SQLException, FactoryException {
        String str = result.getString(columnIndex);
        if (result.wasNull()) {
            String column = result.getMetaData().getColumnName(columnIndex);
            result.close();
            throw new FactoryException(Resources.format(74, line, column));
        }
        return str.trim();
    }

    private static double getDouble(ResultSet result, int columnIndex, String line) throws SQLException, FactoryException {
        double value = result.getDouble(columnIndex);
        if (result.wasNull()) {
            String column = result.getMetaData().getColumnName(columnIndex);
            result.close();
            throw new FactoryException(Resources.format(74, line, column));
        }
        return value;
    }

    private static int getInt(ResultSet result, int columnIndex, String line) throws SQLException, FactoryException {
        int value = result.getInt(columnIndex);
        if (result.wasNull()) {
            String column = result.getMetaData().getColumnName(columnIndex);
            result.close();
            throw new FactoryException(Resources.format(74, line, column));
        }
        return value;
    }

    private static Object ensureSingleton(Object newValue, Object oldValue, String code) throws FactoryException {
        if (oldValue == null) {
            return newValue;
        }
        if (oldValue.equals(newValue)) {
            return oldValue;
        }
        throw new FactoryException(Resources.format(48, code));
    }

    private static String fromEPSGtoOGC(String name) {
        String ogcName = (String)namesMap.get(new CaselessStringKey(name));
        if (ogcName != null) {
            return ogcName;
        }
        StringBuffer buf = new StringBuffer();
        StringTokenizer st = new StringTokenizer(name, " ()");
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            buf.append(Character.toUpperCase(word.charAt(0)));
            buf.append(word.substring(1));
            buf.append("_");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private CharSequence pack(String name, String code, String remarks) {
        name = name.trim();
        code = code.trim();
        InfoProperties.Named props = new InfoProperties.Named(name);
        props.put("authority", this.getAuthority());
        props.put("authorityCode", code);
        if (remarks != null && (remarks = remarks.trim()).length() != 0) {
            props.put("remarks", remarks);
        }
        return props;
    }

    public synchronized Object createObject(String code) throws FactoryException {
        String type = null;
        try {
            PreparedStatement stmt = this.prepareStatement("Object", "select TABLE_NAME from [Codes] where RECORD_ID >= 4 and CODE_MINIMUM <= ? and CODE_MAXIMUM >= ?");
            stmt.setString(1, code);
            stmt.setString(2, code);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String str = CoordinateSystemEPSGFactory.getString(result, 1, code);
                type = (String)CoordinateSystemEPSGFactory.ensureSingleton(str, type, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw new FactoryException(code, exception);
        }
        if (type == null) {
            throw new NoSuchAuthorityCodeException(code);
        }
        if (type.equalsIgnoreCase("Coordinate Reference System")) {
            return this.createCoordinateSystem(code);
        }
        if (type.equalsIgnoreCase("Coordinate System")) {
            return this.createCoordinateSystem(code);
        }
        if (type.equalsIgnoreCase("Ellipsoid")) {
            return this.createEllipsoid(code);
        }
        if (type.equalsIgnoreCase("Unit of Measure")) {
            return this.createUnit(code);
        }
        if (type.matches("[\\w\\s]*Datum[\\w\\s]*")) {
            return this.createDatum(code);
        }
        throw new FactoryException(Resources.format(77, type));
    }

    public synchronized Ellipsoid createEllipsoid(String code) throws FactoryException {
        Ellipsoid returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("Ellipsoid", "select ELLIPSOID_NAME, SEMI_MAJOR_AXIS, INV_FLATTENING, SEMI_MINOR_AXIS, UOM_CODE, REMARKS from [Ellipsoid] where ELLIPSOID_CODE = ?");
            stmt.setString(1, code);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                Ellipsoid ellipsoid;
                String name = CoordinateSystemEPSGFactory.getString(result, 1, code);
                double semiMajorAxis = CoordinateSystemEPSGFactory.getDouble(result, 2, code);
                double inverseFlattening = result.getDouble(3);
                double semiMinorAxis = result.getDouble(4);
                String unitCode = CoordinateSystemEPSGFactory.getString(result, 5, code);
                String remarks = result.getString(6);
                Unit unit = this.createUnit(unitCode);
                CharSequence prp = this.pack(name, code, remarks);
                if (inverseFlattening == 0.0) {
                    if (semiMinorAxis == 0.0) {
                        String column = result.getMetaData().getColumnName(3);
                        result.close();
                        throw new FactoryException(Resources.format(74, code, column));
                    }
                    ellipsoid = this.factory.createEllipsoid(prp, semiMajorAxis, semiMinorAxis, unit);
                } else {
                    if (semiMinorAxis != 0.0) {
                        Logger.getLogger("org.geotools.cs").warning(Resources.format(41));
                    }
                    ellipsoid = this.factory.createFlattenedSphere(prp, semiMajorAxis, inverseFlattening, unit);
                }
                returnValue = (Ellipsoid)CoordinateSystemEPSGFactory.ensureSingleton(ellipsoid, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw new FactoryException(code, exception);
        }
        if (returnValue == null) {
            throw new NoSuchAuthorityCodeException(code);
        }
        return returnValue;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Unit createUnit(String code) throws FactoryException {
        Unit returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("Unit", "select UNIT_OF_MEAS_TYPE, FACTOR_B, FACTOR_C from [Unit of Measure] where UOM_CODE = ?");
            stmt.setString(1, code);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                Unit baseUnit;
                String type = CoordinateSystemEPSGFactory.getString(result, 1, code);
                double b = result.getDouble(2);
                double c = result.getDouble(3);
                Unit scaledUnit = null;
                if (type.equalsIgnoreCase("length")) {
                    baseUnit = Unit.METRE;
                } else if (type.equalsIgnoreCase("angle")) {
                    baseUnit = Unit.RADIAN;
                    if (b == 0.0 && c == 0.0) {
                        switch (Integer.parseInt(code)) {
                            case 9107: {
                                scaledUnit = Unit.DMS;
                                break;
                            }
                            case 9108: {
                                scaledUnit = Unit.DMS;
                                break;
                            }
                            case 9110: {
                                scaledUnit = Unit.SEXAGESIMAL_DEGREE;
                                break;
                            }
                            case 9111: {
                                throw new FactoryException("\"degree and decimal minute\" unit not yet supported");
                            }
                        }
                    }
                } else if (type.equalsIgnoreCase("scale")) {
                    baseUnit = Unit.DIMENSIONLESS;
                    if (b == 0.0 && c == 0.0) {
                        switch (Integer.parseInt(code)) {
                            case 9203: {
                                scaledUnit = baseUnit;
                            }
                        }
                    }
                } else {
                    result.close();
                    throw new FactoryException(Resources.format(77, type));
                }
                if (scaledUnit == null) {
                    void var10_9;
                    if (b == 0.0 || c == 0.0) {
                        String column = result.getMetaData().getColumnName(b == 0.0 ? 2 : 3);
                        result.close();
                        throw new FactoryException(Resources.format(74, code, column));
                    }
                    scaledUnit = var10_9.scale(b / c);
                }
                returnValue = (Unit)CoordinateSystemEPSGFactory.ensureSingleton(scaledUnit, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw new FactoryException(code, exception);
        }
        if (returnValue == null) {
            throw new NoSuchAuthorityCodeException(code);
        }
        return returnValue;
    }

    public synchronized PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        PrimeMeridian returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("PrimeMeridian", "select PRIME_MERIDIAN_NAME, GREENWICH_LONGITUDE, UOM_CODE, REMARKS from [Prime Meridian] where PRIME_MERIDIAN_CODE = ?");
            stmt.setString(1, code);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String name = CoordinateSystemEPSGFactory.getString(result, 1, code);
                double longitude = CoordinateSystemEPSGFactory.getDouble(result, 2, code);
                String unit_code = CoordinateSystemEPSGFactory.getString(result, 3, code);
                String remarks = result.getString(4);
                Unit unit = this.createUnit(unit_code);
                CharSequence prp = this.pack(name, code, remarks);
                PrimeMeridian primeMeridian = this.factory.createPrimeMeridian(prp, unit, longitude);
                returnValue = (PrimeMeridian)CoordinateSystemEPSGFactory.ensureSingleton(primeMeridian, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw new FactoryException(code, exception);
        }
        if (returnValue == null) {
            throw new NoSuchAuthorityCodeException(code);
        }
        return returnValue;
    }

    /*
     * WARNING - void declaration
     */
    public Datum createDatum(String code) throws FactoryException {
        Datum returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("Datum", "select DATUM_NAME, DATUM_TYPE, ELLIPSOID_CODE, REMARKS from [Datum] where DATUM_CODE = ?");
            stmt.setString(1, code);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                void var10_11;
                Datum datum;
                String name = CoordinateSystemEPSGFactory.getString(result, 1, code);
                String type = CoordinateSystemEPSGFactory.getString(result, 2, code);
                String ellps = CoordinateSystemEPSGFactory.getString(result, 3, code);
                String remarks = result.getString(4);
                CharSequence prp = this.pack(name, code, remarks);
                if (type.equalsIgnoreCase("vertical")) {
                    DatumType.Vertical dtype = DatumType.Vertical.ELLIPSOIDAL;
                    datum = this.factory.createVerticalDatum(prp, dtype);
                } else if (type.equalsIgnoreCase("geodetic")) {
                    Ellipsoid ellipsoid = this.createEllipsoid(ellps);
                    WGS84ConversionInfo[] infos = this.createWGS84ConversionInfo(code);
                    WGS84ConversionInfo mainInf = infos.length != 0 ? infos[0] : null;
                    DatumType.Horizontal dtype = DatumType.Horizontal.GEOCENTRIC;
                    datum = this.factory.createHorizontalDatum(prp, dtype, ellipsoid, mainInf);
                } else {
                    if (type.equalsIgnoreCase("engineering")) {
                        result.close();
                        throw new UnsupportedOperationException("DatumType.Local not supported.");
                    }
                    result.close();
                    throw new FactoryException(Resources.format(77, type));
                }
                returnValue = (Datum)CoordinateSystemEPSGFactory.ensureSingleton(var10_11, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw new FactoryException(code, exception);
        }
        if (returnValue == null) {
            throw new NoSuchAuthorityCodeException(code);
        }
        return returnValue;
    }

    private WGS84ConversionInfo[] createWGS84ConversionInfo(String code) throws FactoryException {
        ArrayList<WGS84ConversionInfo> list = new ArrayList<WGS84ConversionInfo>();
        try {
            PreparedStatement stmt = this.prepareStatement("WGS84ConversionInfo", "select CO.COORD_OP_CODE, Area.AREA_OF_USE, CO.COORD_OP_METHOD_CODE from [Coordinate_Operation] as CO, [Coordinate Reference System] as CRS, [Area] where CRS.DATUM_CODE = ? and CO.SOURCE_CRS_CODE = CRS.COORD_REF_SYS_CODE and CO.TARGET_CRS_CODE = 4326 and Area.AREA_CODE = CO.AREA_OF_USE_CODE order by CO.COORD_OP_CODE");
            stmt.setString(1, code);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                WGS84ConversionInfo info = new WGS84ConversionInfo();
                Parameter[] param = this.createParameter(CoordinateSystemEPSGFactory.getString(result, 1, code));
                if (param == null || param.length == 0) continue;
                String areaOfUse = result.getString(2);
                String methodOpCode = CoordinateSystemEPSGFactory.getString(result, 3, code);
                if (!methodOpCode.equals("9603") && !methodOpCode.equals("9606")) continue;
                info.areaOfUse = areaOfUse;
                info.dx = Unit.METRE.convert(param[0].value, param[0].unit);
                info.dy = Unit.METRE.convert(param[1].value, param[1].unit);
                info.dz = Unit.METRE.convert(param[2].value, param[2].unit);
                if (methodOpCode.equals("9606")) {
                    info.ex = Unit.ARC_SECOND.convert(param[3].value, param[3].unit);
                    info.ey = Unit.ARC_SECOND.convert(param[4].value, param[4].unit);
                    info.ez = Unit.ARC_SECOND.convert(param[5].value, param[5].unit);
                    info.ppm = param[6].value;
                }
                list.add(info);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw new FactoryException(code, exception);
        }
        return list.toArray(new WGS84ConversionInfo[list.size()]);
    }

    public synchronized CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        String type = null;
        try {
            PreparedStatement stmt = this.prepareStatement("CoordinateSystem", "select COORD_REF_SYS_KIND from [Coordinate Reference System] where COORD_REF_SYS_CODE = ?");
            stmt.setString(1, code);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String candidate = CoordinateSystemEPSGFactory.getString(result, 1, code);
                type = (String)CoordinateSystemEPSGFactory.ensureSingleton(candidate, type, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw new FactoryException(code, exception);
        }
        if (type == null) {
            throw new NoSuchAuthorityCodeException(code);
        }
        if (type.equalsIgnoreCase("compound")) {
            return this.createCompoundCoordinateSystem(code);
        }
        if (type.equalsIgnoreCase("vertical")) {
            return this.createVerticalCoordinateSystem(code);
        }
        if (type.equalsIgnoreCase("geographic 2D")) {
            return this.createGeographicCoordinateSystem(code);
        }
        if (type.equalsIgnoreCase("projected")) {
            return this.createProjectedCoordinateSystem(code);
        }
        throw new FactoryException(Resources.format(77, code));
    }

    public synchronized GeographicCoordinateSystem createGeographicCoordinateSystem(String code) throws FactoryException {
        GeographicCoordinateSystem returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("GeographicCoordinateSystem", "select DIMENSION, CS.COORD_SYS_CODE, COORD_REF_SYS_NAME, PRIME_MERIDIAN_CODE, Datum.DATUM_CODE, CRS.REMARKS from [Coordinate Reference System] as CRS, [Coordinate System] as CS, [Datum] where COORD_REF_SYS_CODE = ? and CS.COORD_SYS_CODE = CRS.COORD_SYS_CODE and Datum.DATUM_CODE = CRS.DATUM_CODE");
            stmt.setString(1, code);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                int dimension = CoordinateSystemEPSGFactory.getInt(result, 1, code);
                String coordSysCode = CoordinateSystemEPSGFactory.getString(result, 2, code);
                String name = CoordinateSystemEPSGFactory.getString(result, 3, code);
                String primeMeridian = CoordinateSystemEPSGFactory.getString(result, 4, code);
                String datum = CoordinateSystemEPSGFactory.getString(result, 5, code);
                String remarks = result.getString(6);
                AxisInfo[] axisInfos = this.createAxisInfos(coordSysCode, dimension);
                Unit unit = this.createUnitCS(coordSysCode);
                CharSequence prp = this.pack(name, code, remarks);
                GeographicCoordinateSystem coordSys = this.factory.createGeographicCoordinateSystem(prp, unit, this.createHorizontalDatum(datum), this.createPrimeMeridian(primeMeridian), axisInfos[0], axisInfos[1]);
                returnValue = (GeographicCoordinateSystem)CoordinateSystemEPSGFactory.ensureSingleton(coordSys, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw new FactoryException(code, exception);
        }
        if (returnValue == null) {
            throw new NoSuchAuthorityCodeException(code);
        }
        return returnValue;
    }

    public synchronized ProjectedCoordinateSystem createProjectedCoordinateSystem(String code) throws FactoryException {
        CoordinateSystem returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("ProjectedCoordinateSystem", "select DIMENSION, CS.COORD_SYS_CODE, CRS.COORD_REF_SYS_NAME, CRS.SOURCE_GEOGCRS_CODE, CO.COORD_OP_NAME, COM.COORD_OP_METHOD_NAME, CRS.PROJECTION_CONV_CODE, CRS.REMARKS from [Coordinate Reference System] as CRS, [Coordinate System] as CS, [Coordinate_Operation] as CO, [Coordinate_Operation Method] as COM where CRS.COORD_REF_SYS_CODE = ? and CS.COORD_SYS_CODE = CRS.COORD_SYS_CODE and CO.COORD_OP_CODE = CRS.PROJECTION_CONV_CODE and COM.COORD_OP_METHOD_CODE = CO.COORD_OP_METHOD_CODE");
            stmt.setString(1, code);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                int dimension = CoordinateSystemEPSGFactory.getInt(result, 1, code);
                String coordSysCode = CoordinateSystemEPSGFactory.getString(result, 2, code);
                String name = CoordinateSystemEPSGFactory.getString(result, 3, code);
                String geoCoordSys = CoordinateSystemEPSGFactory.getString(result, 4, code);
                String operationName = CoordinateSystemEPSGFactory.getString(result, 5, code);
                String classification = CoordinateSystemEPSGFactory.fromEPSGtoOGC(CoordinateSystemEPSGFactory.getString(result, 6, code));
                Parameter[] parameters = this.createParameter(CoordinateSystemEPSGFactory.getString(result, 7, code));
                String remarks = result.getString(8);
                AxisInfo[] axisInfos = this.createAxisInfos(coordSysCode, dimension);
                CharSequence prp = this.pack(name, code, remarks);
                ParameterList list = this.factory.createProjectionParameterList(classification);
                for (int i = 0; i < parameters.length; ++i) {
                    parameters[i].setParameter(list);
                }
                GeographicCoordinateSystem gcs = this.createGeographicCoordinateSystem(geoCoordSys);
                Ellipsoid e = gcs.getHorizontalDatum().getEllipsoid();
                if (e != null) {
                    Unit unit = e.getAxisUnit();
                    list.setParameter("semi_major", Unit.METRE.convert(e.getSemiMajorAxis(), unit));
                    list.setParameter("semi_minor", Unit.METRE.convert(e.getSemiMinorAxis(), unit));
                }
                Projection projection = this.factory.createProjection(operationName, classification, list);
                Unit unit = this.createUnitCS(coordSysCode);
                ProjectedCoordinateSystem coordSys = this.factory.createProjectedCoordinateSystem(prp, gcs, projection, unit, axisInfos[0], axisInfos[1]);
                returnValue = (CoordinateSystem)CoordinateSystemEPSGFactory.ensureSingleton(coordSys, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw new FactoryException(code, exception);
        }
        if (returnValue == null) {
            throw new NoSuchAuthorityCodeException(code);
        }
        return (ProjectedCoordinateSystem)returnValue;
    }

    public synchronized VerticalCoordinateSystem createVerticalCoordinateSystem(String code) throws FactoryException {
        VerticalCoordinateSystem returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("VerticalCoordinateSystem", "select DIMENSION, CS.COORD_SYS_CODE, COORD_REF_SYS_NAME, DATUM_CODE, CRS.REMARKS from [Coordinate Reference System] as CRS, [Coordinate System] as CS where COORD_REF_SYS_CODE = ? and CS.COORD_SYS_CODE = CRS.COORD_SYS_CODE");
            stmt.setString(1, code);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                int dimension = CoordinateSystemEPSGFactory.getInt(result, 1, code);
                String coordSysCode = CoordinateSystemEPSGFactory.getString(result, 2, code);
                String name = CoordinateSystemEPSGFactory.getString(result, 3, code);
                String datum = CoordinateSystemEPSGFactory.getString(result, 4, code);
                String remarks = result.getString(5);
                AxisInfo[] axisInfos = this.createAxisInfos(coordSysCode, dimension);
                CharSequence prp = this.pack(name, code, remarks);
                VerticalCoordinateSystem coordSys = this.factory.createVerticalCoordinateSystem(prp, this.createVerticalDatum(datum), this.createUnitCS(coordSysCode), axisInfos[0]);
                returnValue = (VerticalCoordinateSystem)CoordinateSystemEPSGFactory.ensureSingleton(coordSys, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw new FactoryException(code, exception);
        }
        if (returnValue == null) {
            throw new NoSuchAuthorityCodeException(code);
        }
        return returnValue;
    }

    public synchronized CompoundCoordinateSystem createCompoundCoordinateSystem(String code) throws FactoryException {
        CompoundCoordinateSystem returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("CompoundCoordinateSystem", "select COORD_REF_SYS_NAME, COORD_REF_SYS_KIND, CMPD_HORIZCRS_CODE, CMPD_VERTCRS_CODE, REMARKS from [Coordinate Reference System] where COORD_REF_SYS_CODE = ?");
            stmt.setString(1, code);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String name = CoordinateSystemEPSGFactory.getString(result, 1, code);
                String type = CoordinateSystemEPSGFactory.getString(result, 2, code);
                if (!type.equalsIgnoreCase("compound")) {
                    throw new FactoryException(Resources.format(77, code));
                }
                CoordinateSystem cs1 = this.createCoordinateSystem(CoordinateSystemEPSGFactory.getString(result, 3, code));
                CoordinateSystem cs2 = this.createCoordinateSystem(CoordinateSystemEPSGFactory.getString(result, 4, code));
                CharSequence prp = this.pack(name, code, result.getString(5));
                CompoundCoordinateSystem cs = this.factory.createCompoundCoordinateSystem(prp, cs1, cs2);
                returnValue = (CompoundCoordinateSystem)CoordinateSystemEPSGFactory.ensureSingleton(cs, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw new FactoryException(code, exception);
        }
        if (returnValue == null) {
            throw new NoSuchAuthorityCodeException(code);
        }
        return returnValue;
    }

    private AxisInfo[] createAxisInfos(String code, int dimension) throws SQLException, FactoryException {
        AxisInfo[] axis = new AxisInfo[dimension];
        PreparedStatement stmt = this.prepareStatement("AxisInfo", "select COORD_AXIS_NAME, COORD_AXIS_ORIENTATION from [Coordinate Axis] as CA, [Coordinate Axis Name] as CAN where COORD_SYS_CODE = ? and CA.COORD_AXIS_NAME_CODE = CAN.COORD_AXIS_NAME_CODE order by [ORDER]");
        stmt.setString(1, code);
        ResultSet result = stmt.executeQuery();
        int i = 0;
        while (result.next()) {
            AxisOrientation orientation;
            String name = CoordinateSystemEPSGFactory.getString(result, 1, code);
            try {
                orientation = AxisOrientation.getEnum(CoordinateSystemEPSGFactory.getString(result, 2, code));
            }
            catch (NoSuchElementException exception) {
                throw new FactoryException(Resources.format(77, name), exception);
            }
            if (i >= axis.length) continue;
            axis[i++] = new AxisInfo(name, orientation);
        }
        result.close();
        if (i != axis.length) {
            throw new FactoryException(Resources.format(60, new Integer(axis.length), new Integer(i)));
        }
        return axis;
    }

    private Unit createUnitCS(String code) throws SQLException, FactoryException {
        Unit returnValue = null;
        PreparedStatement stmt = this.prepareStatement("UnitCS", "select UOM_CODE from [Coordinate Axis] where COORD_SYS_CODE = ?");
        stmt.setString(1, code);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            Unit unit = this.createUnit(CoordinateSystemEPSGFactory.getString(result, 1, code));
            returnValue = (Unit)CoordinateSystemEPSGFactory.ensureSingleton(unit, returnValue, code);
        }
        result.close();
        if (returnValue == null) {
            throw new NoSuchAuthorityCodeException(code);
        }
        return this.replaceAxisUnit(returnValue);
    }

    protected Unit replaceAxisUnit(Unit unit) {
        if (Unit.DMS.equals((Object)unit) || Unit.SEXAGESIMAL_DEGREE.equals((Object)unit)) {
            return Unit.DEGREE;
        }
        return unit;
    }

    public synchronized void dispose() throws FactoryException {
        try {
            this.close(this != DEFAULT);
        }
        catch (SQLException exception) {
            throw new FactoryException(null, exception);
        }
    }

    private synchronized void close(boolean definitive) throws SQLException {
        Iterator it = this.statements.values().iterator();
        while (it.hasNext()) {
            PreparedStatement stmt = (PreparedStatement)it.next();
            stmt.close();
        }
        this.statements.clear();
        if (definitive) {
            this.connection.close();
        }
    }

    private Parameter[] createParameter(String code) throws SQLException, FactoryException {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        PreparedStatement stmt = this.prepareStatement("Parameter", "select  COP.PARAMETER_NAME, COPV.PARAMETER_VALUE, COPV.UOM_CODE from [Coordinate_Operation Parameter Usage] as COPU, [Coordinate_Operation] as CO, [Coordinate_Operation Parameter] as COP, [Coordinate_Operation Parameter Value] as COPV where CO.COORD_OP_CODE = ? and CO.COORD_OP_METHOD_CODE = COPU.COORD_OP_METHOD_CODE and COP.PARAMETER_CODE = COPU.PARAMETER_CODE and COPV.PARAMETER_CODE = COPU.PARAMETER_CODE and COPV.COORD_OP_CODE = ? order by COPU.SORT_ORDER");
        stmt.setString(1, code);
        stmt.setString(2, code);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            String name = CoordinateSystemEPSGFactory.getString(result, 1, code);
            double value = result.getDouble(2);
            if (result.wasNull()) {
                result.close();
                throw new UnsupportedOperationException("Not yet implemented");
            }
            String unit = CoordinateSystemEPSGFactory.getString(result, 3, code);
            list.add(new Parameter(name, value, this.createUnit(unit)));
        }
        result.close();
        return list.toArray(new Parameter[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Geotools.init();
        Arguments arguments = new Arguments(args);
        PrintWriter out = arguments.out;
        String newDriver = arguments.getOptionalString("-driver");
        String newConnection = arguments.getOptionalString("-connection");
        String newImplement = arguments.getOptionalString("-implementation");
        Preferences prefs = Preferences.systemNodeForPackage(CoordinateSystemAuthorityFactory.class);
        if (newDriver != null) {
            if (newDriver.length() == 0) {
                prefs.remove(DRIVER);
            } else {
                prefs.put(DRIVER, newDriver);
            }
        }
        if (newConnection != null) {
            if (newConnection.length() == 0) {
                prefs.remove(CONNECTION);
            } else {
                prefs.put(CONNECTION, newConnection);
            }
        }
        if (newImplement != null) {
            if (newImplement.length() == 0) {
                prefs.remove(IMPLEMENTATION);
            } else {
                prefs.put(IMPLEMENTATION, newImplement);
            }
        }
        if ((args = arguments.getRemainingArguments(Integer.MAX_VALUE)).length == 0) {
            String driver = prefs.get(DRIVER, DEFAULT_DRIVER);
            String connect = prefs.get(CONNECTION, DEFAULT_CONNECTION);
            try {
                Driver drv = (Driver)Class.forName(driver).newInstance();
                out.println(Resources.getResources(arguments.locale).getString(23, drv.getClass().getName(), new Integer(drv.getMajorVersion()), new Integer(drv.getMinorVersion())));
            }
            catch (Exception exception) {
                out.println(exception);
            }
            out.print("Connection: \"");
            out.print(connect);
            out.println('\"');
            return;
        }
        CoordinateSystemAuthorityFactory factory = null;
        try {
            try {
                factory = CoordinateSystemEPSGFactory.getDefault();
                for (int i = 0; i < args.length; ++i) {
                    out.println();
                    out.println();
                    out.print("<=== EPSG ");
                    out.print(args[i]);
                    out.println(" ===>");
                    out.println(factory.createObject(args[i]));
                    out.flush();
                }
            }
            finally {
                if (factory != null) {
                    factory.dispose();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(out);
        }
        out.flush();
    }

    static {
        $assertionsDisabled = !CoordinateSystemEPSGFactory.class.desiredAssertionStatus();
        DEFAULT_PARAM_MAP = new String[]{"Latitude of natural origin", "latitude_of_origin", "Longitude of natural origin", "central_meridian", "Scale factor at natural origin", "scale_factor", "False easting", "false_easting", "False northing", "false_northing", "Easting at false origin", "false_easting", "Northing at false origin", "false_northing", "Latitude of 1st standard parallel", "standard_parallel1", "Latitude of 2nd standard parallel", "standard_parallel2", "Lambert Conic Conformal (2SP)", "Lambert_Conformal_Conic_2SP"};
        namesMap = new HashMap();
        int i = 0;
        while (i < DEFAULT_PARAM_MAP.length) {
            namesMap.put(new CaselessStringKey(DEFAULT_PARAM_MAP[i++]), DEFAULT_PARAM_MAP[i++]);
        }
    }

    private static final class Parameter {
        public final String name;
        public final double value;
        public final Unit unit;

        private Parameter(String name, double value, Unit unit) {
            this.name = name;
            this.value = value;
            this.unit = unit;
        }

        final void setParameter(ParameterList list) {
            String ogcName = CoordinateSystemEPSGFactory.fromEPSGtoOGC(this.name);
            double standardValue = this.value;
            if (Unit.METRE.canConvert(this.unit)) {
                standardValue = Unit.METRE.convert(standardValue, this.unit);
            }
            if (Unit.DEGREE.canConvert(this.unit)) {
                standardValue = Unit.DEGREE.convert(standardValue, this.unit);
            }
            try {
                list.setParameter(ogcName, standardValue);
            }
            catch (IllegalArgumentException exception) {
                LogRecord record = Resources.getResources(null).getLogRecord(Level.WARNING, 83, this.name, new Double(this.value), this.unit);
                record.setSourceClassName("CoordinateSystemEPSGFactory");
                record.setSourceMethodName("createProjectedCoordinateSystem");
                record.setThrown(exception);
                Logger.getLogger("org.geotools.cs").log(record);
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("Parameter[\"");
            buffer.append(this.name);
            buffer.append("\"=");
            buffer.append(this.value);
            buffer.append(' ');
            buffer.append(this.unit);
            buffer.append(']');
            return buffer.toString();
        }
    }
}

