/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.geotools.cs.Adapters;
import org.geotools.cs.CompoundCoordinateSystem;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.CoordinateSystemFactory;
import org.geotools.cs.Datum;
import org.geotools.cs.Ellipsoid;
import org.geotools.cs.FactoryException;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.HorizontalCoordinateSystem;
import org.geotools.cs.HorizontalDatum;
import org.geotools.cs.Info;
import org.geotools.cs.NoSuchAuthorityCodeException;
import org.geotools.cs.PrimeMeridian;
import org.geotools.cs.ProjectedCoordinateSystem;
import org.geotools.cs.VerticalCoordinateSystem;
import org.geotools.cs.VerticalDatum;
import org.geotools.units.Unit;
import org.opengis.cs.CS_AngularUnit;
import org.opengis.cs.CS_CompoundCoordinateSystem;
import org.opengis.cs.CS_CoordinateSystemAuthorityFactory;
import org.opengis.cs.CS_Ellipsoid;
import org.opengis.cs.CS_GeographicCoordinateSystem;
import org.opengis.cs.CS_HorizontalCoordinateSystem;
import org.opengis.cs.CS_HorizontalDatum;
import org.opengis.cs.CS_LinearUnit;
import org.opengis.cs.CS_PrimeMeridian;
import org.opengis.cs.CS_ProjectedCoordinateSystem;
import org.opengis.cs.CS_VerticalCoordinateSystem;
import org.opengis.cs.CS_VerticalDatum;

public abstract class CoordinateSystemAuthorityFactory {
    protected final CoordinateSystemFactory factory;
    private transient Object proxy;

    public CoordinateSystemAuthorityFactory(CoordinateSystemFactory factory) {
        Info.ensureNonNull("factory", factory);
        this.factory = factory;
    }

    public abstract String getAuthority();

    public Object createObject(String code) throws FactoryException {
        throw new NoSuchAuthorityCodeException("Object", code);
    }

    public abstract Unit createUnit(String var1) throws FactoryException;

    public abstract Ellipsoid createEllipsoid(String var1) throws FactoryException;

    public abstract PrimeMeridian createPrimeMeridian(String var1) throws FactoryException;

    public abstract Datum createDatum(String var1) throws FactoryException;

    public HorizontalDatum createHorizontalDatum(String code) throws FactoryException {
        Datum datum = this.createDatum(code);
        if (datum instanceof HorizontalDatum) {
            return (HorizontalDatum)datum;
        }
        throw new NoSuchAuthorityCodeException("HorizontalDatum", code);
    }

    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        Datum datum = this.createDatum(code);
        if (datum instanceof VerticalDatum) {
            return (VerticalDatum)datum;
        }
        throw new NoSuchAuthorityCodeException("VerticalDatum", code);
    }

    public abstract CoordinateSystem createCoordinateSystem(String var1) throws FactoryException;

    public HorizontalCoordinateSystem createHorizontalCoordinateSystem(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        if (cs instanceof HorizontalCoordinateSystem) {
            return (HorizontalCoordinateSystem)cs;
        }
        throw new NoSuchAuthorityCodeException("HorizontalCoordinateSystem", code);
    }

    public GeographicCoordinateSystem createGeographicCoordinateSystem(String code) throws FactoryException {
        HorizontalCoordinateSystem cs = this.createHorizontalCoordinateSystem(code);
        if (cs instanceof GeographicCoordinateSystem) {
            return (GeographicCoordinateSystem)cs;
        }
        throw new NoSuchAuthorityCodeException("GeographicCoordinateSystem", code);
    }

    public ProjectedCoordinateSystem createProjectedCoordinateSystem(String code) throws FactoryException {
        HorizontalCoordinateSystem cs = this.createHorizontalCoordinateSystem(code);
        if (cs instanceof ProjectedCoordinateSystem) {
            return (ProjectedCoordinateSystem)cs;
        }
        throw new NoSuchAuthorityCodeException("ProjectedCoordinateSystem", code);
    }

    public VerticalCoordinateSystem createVerticalCoordinateSystem(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        if (cs instanceof VerticalCoordinateSystem) {
            return (VerticalCoordinateSystem)cs;
        }
        throw new NoSuchAuthorityCodeException("VerticalCoordinateSystem", code);
    }

    public CompoundCoordinateSystem createCompoundCoordinateSystem(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        if (cs instanceof CompoundCoordinateSystem) {
            return (CompoundCoordinateSystem)cs;
        }
        throw new NoSuchAuthorityCodeException("CompoundCoordinateSystem", code);
    }

    public void dispose() throws FactoryException {
    }

    final synchronized Object toOpenGIS(Object adapters) throws RemoteException {
        if (this.proxy != null) {
            if (this.proxy instanceof Reference) {
                Object ref = ((Reference)this.proxy).get();
                if (ref != null) {
                    return ref;
                }
            } else {
                return this.proxy;
            }
        }
        Export opengis = new Export(adapters);
        this.proxy = new WeakReference<Export>(opengis);
        return opengis;
    }

    private final class Export
    extends UnicastRemoteObject
    implements CS_CoordinateSystemAuthorityFactory {
        protected final Adapters adapters;

        protected Export(Object adapters) throws RemoteException {
            this.adapters = (Adapters)adapters;
        }

        public CoordinateSystemAuthorityFactory getImplementation() {
            return CoordinateSystemAuthorityFactory.this;
        }

        public String getAuthority() throws RemoteException {
            return CoordinateSystemAuthorityFactory.this.getAuthority();
        }

        public CS_AngularUnit createAngularUnit(String code) throws RemoteException {
            try {
                return (CS_AngularUnit)this.adapters.export(CoordinateSystemAuthorityFactory.this.createUnit(code));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_LinearUnit createLinearUnit(String code) throws RemoteException {
            try {
                return (CS_LinearUnit)this.adapters.export(CoordinateSystemAuthorityFactory.this.createUnit(code));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_Ellipsoid createEllipsoid(String code) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemAuthorityFactory.this.createEllipsoid(code));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_PrimeMeridian createPrimeMeridian(String code) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemAuthorityFactory.this.createPrimeMeridian(code));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_HorizontalDatum createHorizontalDatum(String code) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemAuthorityFactory.this.createHorizontalDatum(code));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_VerticalDatum createVerticalDatum(String code) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemAuthorityFactory.this.createVerticalDatum(code));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_HorizontalCoordinateSystem createHorizontalCoordinateSystem(String code) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemAuthorityFactory.this.createHorizontalCoordinateSystem(code));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_GeographicCoordinateSystem createGeographicCoordinateSystem(String code) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemAuthorityFactory.this.createGeographicCoordinateSystem(code));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_ProjectedCoordinateSystem createProjectedCoordinateSystem(String code) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemAuthorityFactory.this.createProjectedCoordinateSystem(code));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_VerticalCoordinateSystem createVerticalCoordinateSystem(String code) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemAuthorityFactory.this.createVerticalCoordinateSystem(code));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public CS_CompoundCoordinateSystem createCompoundCoordinateSystem(String code) throws RemoteException {
            try {
                return this.adapters.export(CoordinateSystemAuthorityFactory.this.createCompoundCoordinateSystem(code));
            }
            catch (FactoryException exception) {
                throw Adapters.serverException(exception);
            }
        }

        public String descriptionText(String code) throws RemoteException {
            throw new UnsupportedOperationException("Description text not yet implemented");
        }

        public String geoidFromWKTName(String wkt) throws RemoteException {
            throw new UnsupportedOperationException("Geoid from WKT code not yet implemented");
        }

        public String wktGeoidName(String geoid) throws RemoteException {
            throw new UnsupportedOperationException("WKT formatting not yet implemented");
        }
    }
}

