/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.AxisOrientation;
import org.geotools.cs.Datum;
import org.geotools.cs.DatumType;
import org.geotools.cs.Info;
import org.geotools.pt.Dimensioned;
import org.geotools.pt.Envelope;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.opengis.cs.CS_AxisInfo;
import org.opengis.cs.CS_CoordinateSystem;
import org.opengis.cs.CS_Unit;
import org.opengis.pt.PT_Envelope;
import org.opengis.sc.CoordinateReferenceSystem;

public abstract class CoordinateSystem
extends Info
implements Dimensioned,
CoordinateReferenceSystem {
    private static final long serialVersionUID = -4539963180028417479L;

    public CoordinateSystem(CharSequence name) {
        super(name);
    }

    final void checkAxis(DatumType type) throws IllegalArgumentException {
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            AxisOrientation check = this.getAxis((int)i).orientation;
            if (type != null && !type.isCompatibleOrientation(check)) {
                throw new IllegalArgumentException(Resources.format(52, check.getName(null), Utilities.getShortClassName((Object)this)));
            }
            if ((check = check.absolute()).equals(AxisOrientation.OTHER)) continue;
            for (int j = i + 1; j < dimension; ++j) {
                if (!check.equals(this.getAxis((int)j).orientation.absolute())) continue;
                String nameI = this.getAxis((int)i).orientation.getName(null);
                String nameJ = this.getAxis((int)j).orientation.getName(null);
                throw new IllegalArgumentException(Resources.format(47, nameI, nameJ));
            }
        }
    }

    public abstract int getDimension();

    public abstract AxisInfo getAxis(int var1);

    public abstract Unit getUnits(int var1);

    final Unit getUnits() {
        Unit units = null;
        int i = this.getDimension();
        while (--i >= 0) {
            Unit check = this.getUnits(i);
            if (units == null) {
                units = check;
                continue;
            }
            if (units.equals((Object)check)) continue;
            return null;
        }
        return units;
    }

    Datum getDatum() throws IllegalStateException {
        return null;
    }

    public Envelope getDefaultEnvelope() {
        int dimension = this.getDimension();
        Envelope envelope = new Envelope(dimension);
        int i = dimension;
        while (--i >= 0) {
            envelope.setRange(i, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        return envelope;
    }

    public boolean equivalents(CoordinateSystem cs) {
        return this.equals(cs, false);
    }

    Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    class Export
    extends Info.Export
    implements CS_CoordinateSystem {
        protected Export(Object adapters) throws RemoteException {
            super(CoordinateSystem.this, adapters);
        }

        public int getDimension() throws RemoteException {
            return CoordinateSystem.this.getDimension();
        }

        public CS_AxisInfo getAxis(int dimension) throws RemoteException {
            return this.adapters.export(CoordinateSystem.this.getAxis(dimension));
        }

        public CS_Unit getUnits(int dimension) throws RemoteException {
            return this.adapters.export(CoordinateSystem.this.getUnits(dimension));
        }

        public PT_Envelope getDefaultEnvelope() throws RemoteException {
            return this.adapters.export(CoordinateSystem.this.getDefaultEnvelope());
        }
    }
}

