/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.Datum;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.Info;
import org.geotools.cs.VerticalCoordinateSystem;
import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Envelope;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.opengis.cs.CS_CompoundCoordinateSystem;
import org.opengis.cs.CS_CoordinateSystem;

public class CompoundCoordinateSystem
extends CoordinateSystem {
    private static final long serialVersionUID = -488997059924367289L;
    public static final CompoundCoordinateSystem WGS84 = (CompoundCoordinateSystem)pool.canonicalize((Object)new CompoundCoordinateSystem("WGS84", GeographicCoordinateSystem.WGS84, VerticalCoordinateSystem.ELLIPSOIDAL));
    private final CoordinateSystem head;
    private final CoordinateSystem tail;

    public CompoundCoordinateSystem(CharSequence name, CoordinateSystem head, CoordinateSystem tail) {
        super(name);
        this.head = head;
        this.tail = tail;
        CompoundCoordinateSystem.ensureNonNull("head", head);
        CompoundCoordinateSystem.ensureNonNull("tail", tail);
        this.checkAxis(null);
    }

    public CoordinateSystem getHeadCS() {
        return this.head;
    }

    public CoordinateSystem getTailCS() {
        return this.tail;
    }

    public int getDimension() {
        return this.head.getDimension() + this.tail.getDimension();
    }

    public AxisInfo getAxis(int dimension) {
        if (dimension >= 0) {
            int headDim = this.head.getDimension();
            if (dimension < headDim) {
                return this.head.getAxis(dimension);
            }
            int dim = dimension - headDim;
            if (dim < this.tail.getDimension()) {
                return this.tail.getAxis(dim);
            }
        }
        throw new IndexOutOfBoundsException(Resources.format(56, new Integer(dimension)));
    }

    public Unit getUnits(int dimension) {
        if (dimension >= 0) {
            int headDim = this.head.getDimension();
            if (dimension < headDim) {
                return this.head.getUnits(dimension);
            }
            int dim = dimension - headDim;
            if (dim < this.tail.getDimension()) {
                return this.tail.getUnits(dim);
            }
        }
        throw new IndexOutOfBoundsException(Resources.format(56, new Integer(dimension)));
    }

    Datum getDatum() throws IllegalStateException {
        Datum head = this.getHeadCS().getDatum();
        Datum tail = this.getTailCS().getDatum();
        if (tail == null) {
            return head;
        }
        if (head == null) {
            return tail;
        }
        if (head.equals(tail)) {
            return head;
        }
        throw new IllegalStateException();
    }

    public Envelope getDefaultEnvelope() {
        int i;
        Envelope headEnv = this.head.getDefaultEnvelope();
        Envelope tailEnv = this.tail.getDefaultEnvelope();
        int headDim = headEnv.getDimension();
        int tailDim = tailEnv.getDimension();
        CoordinatePoint min = new CoordinatePoint(headDim + tailDim);
        CoordinatePoint max = new CoordinatePoint(headDim + tailDim);
        for (i = 0; i < headDim; ++i) {
            min.ord[i] = headEnv.getMinimum(i);
            max.ord[i] = headEnv.getMaximum(i);
        }
        for (i = 0; i < tailDim; ++i) {
            min.ord[headDim + i] = tailEnv.getMinimum(i);
            max.ord[headDim + i] = tailEnv.getMaximum(i);
        }
        return new Envelope(min, max);
    }

    public boolean equals(Info object, boolean compareNames) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareNames)) {
            CompoundCoordinateSystem that = (CompoundCoordinateSystem)object;
            return CompoundCoordinateSystem.equals(this.head, that.head, compareNames) && CompoundCoordinateSystem.equals(this.tail, that.tail, compareNames);
        }
        return false;
    }

    public int hashCode() {
        return -889231289 + 37 * (this.head.hashCode() + 37 * this.tail.hashCode());
    }

    String addString(StringBuffer buffer, Unit context) {
        buffer.append(", ");
        buffer.append(this.head);
        buffer.append(", ");
        buffer.append(this.tail);
        return "COMPD_CS";
    }

    final Object toOpenGIS(Object adapters) throws RemoteException {
        return new Export(adapters);
    }

    private final class Export
    extends CoordinateSystem.Export
    implements CS_CompoundCoordinateSystem {
        protected Export(Object adapters) throws RemoteException {
            super(adapters);
        }

        public CS_CoordinateSystem getHeadCS() throws RemoteException {
            return this.adapters.export(CompoundCoordinateSystem.this.getHeadCS());
        }

        public CS_CoordinateSystem getTailCS() throws RemoteException {
            return this.adapters.export(CompoundCoordinateSystem.this.getTailCS());
        }
    }
}

