/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.io.ObjectStreamException;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.media.jai.EnumeratedParameter;
import org.geotools.resources.cts.Resources;

public final class AxisOrientation
extends EnumeratedParameter
implements Comparable {
    private static final long serialVersionUID = 4649182002820021468L;
    public static final AxisOrientation OTHER = new AxisOrientation("OTHER", 0, 29);
    public static final AxisOrientation NORTH = new AxisOrientation("NORTH", 1, 27);
    public static final AxisOrientation SOUTH = new AxisOrientation("SOUTH", 2, 32);
    public static final AxisOrientation EAST = new AxisOrientation("EAST", 3, 12);
    public static final AxisOrientation WEST = new AxisOrientation("WEST", 4, 42);
    public static final AxisOrientation UP = new AxisOrientation("UP", 5, 38);
    public static final AxisOrientation DOWN = new AxisOrientation("DOWN", 6, 11);
    public static final AxisOrientation FUTURE = new AxisOrientation("FUTURE", 7, 14);
    public static final AxisOrientation PAST = new AxisOrientation("PAST", 8, 31);
    private static final int LAST_PAIRED_VALUE = 8;
    private static final AxisOrientation[] ENUMS = new AxisOrientation[]{OTHER, NORTH, SOUTH, EAST, WEST, UP, DOWN, FUTURE, PAST};
    private static final AxisOrientation[] ORDER;
    private final transient int key;

    private AxisOrientation(String name, int value, int key) {
        super(name, value);
        this.key = key;
    }

    public static AxisOrientation getEnum(int value) throws NoSuchElementException {
        if (value >= 0 && value < ENUMS.length) {
            return ENUMS[value];
        }
        throw new NoSuchElementException(String.valueOf(value));
    }

    public static AxisOrientation getEnum(String name) {
        name = name.trim();
        for (int i = 0; i < ENUMS.length; ++i) {
            AxisOrientation candidate = ENUMS[i];
            if (!name.equalsIgnoreCase(candidate.getName())) continue;
            return candidate;
        }
        throw new NoSuchElementException(name);
    }

    public static AxisOrientation getEnum(String name, Locale locale) {
        name = name.trim();
        Resources resources = Resources.getResources(locale);
        for (int i = 0; i < ENUMS.length; ++i) {
            AxisOrientation candidate = ENUMS[i];
            if (!name.equalsIgnoreCase(resources.getString(candidate.key))) continue;
            return candidate;
        }
        throw new NoSuchElementException(name);
    }

    public String getName(Locale locale) {
        return Resources.getResources(locale).getString(this.key);
    }

    public AxisOrientation inverse() {
        int value = this.getValue() - 1;
        if (value >= 0 && value < 8) {
            return ENUMS[(value ^ 1) + 1];
        }
        return this;
    }

    public AxisOrientation absolute() {
        int value = this.getValue() - 1;
        if (value >= 0 && value < 8) {
            return ENUMS[(value & 0xFFFFFFFE) + 1];
        }
        return this;
    }

    public int compareTo(Object ao) {
        int thatOrder;
        AxisOrientation that = (AxisOrientation)ao;
        int thisOrder = this.absolute().getOrder();
        if (thisOrder > (thatOrder = that.absolute().getOrder())) {
            return 1;
        }
        if (thisOrder < thatOrder) {
            return -1;
        }
        return 0;
    }

    private int getOrder() {
        int i;
        for (i = 0; i < ORDER.length && !this.equals(ORDER[i]); ++i) {
        }
        return i;
    }

    private Object readResolve() throws ObjectStreamException {
        int value = this.getValue();
        if (value >= 0 && value < ENUMS.length) {
            return ENUMS[value];
        }
        return ENUMS[0];
    }

    static {
        for (int i = 0; i < ENUMS.length; ++i) {
            if (ENUMS[i].getValue() != i) {
                throw new AssertionError(ENUMS[i]);
            }
        }
        ORDER = new AxisOrientation[]{EAST, NORTH, UP, FUTURE};
    }
}

