/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.io.Serializable;
import java.util.Locale;
import org.geotools.cs.AxisOrientation;
import org.geotools.cs.Info;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;

public class AxisInfo
implements Serializable {
    private static final long serialVersionUID = 6799874182734710227L;
    public static final AxisInfo X = new AxisInfo("x", AxisOrientation.EAST);
    public static final AxisInfo Y = new AxisInfo("y", AxisOrientation.NORTH);
    public static final AxisInfo LONGITUDE = new Localized("Longitude", 25, AxisOrientation.EAST);
    public static final AxisInfo LATITUDE = new Localized("Latitude", 22, AxisOrientation.NORTH);
    public static final AxisInfo ALTITUDE = new Localized("Altitude", 2, AxisOrientation.UP);
    public static final AxisInfo TIME = new Localized("Time", 35, AxisOrientation.FUTURE);
    public final String name;
    public final AxisOrientation orientation;

    public AxisInfo(String name, AxisOrientation orientation) {
        this.name = name;
        this.orientation = orientation;
        Info.ensureNonNull("name", name);
        Info.ensureNonNull("orientation", orientation);
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public int hashCode() {
        int code = -1153399341;
        if (this.orientation != null) {
            code = code * 37 + this.orientation.hashCode();
        }
        if (this.name != null) {
            code = code * 37 + this.name.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            AxisInfo that = (AxisInfo)object;
            return Utilities.equals((Object)this.orientation, (Object)that.orientation) && Utilities.equals((Object)this.name, (Object)that.name);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("AXIS[\"");
        buffer.append(this.name);
        buffer.append('\"');
        if (this.orientation != null) {
            buffer.append(',');
            buffer.append(this.orientation.getName());
        }
        buffer.append(']');
        return buffer.toString();
    }

    private static final class Localized
    extends AxisInfo {
        private static final long serialVersionUID = 7625005531024599865L;
        private final int key;

        public Localized(String name, int key, AxisOrientation orientation) {
            super(name, orientation);
            this.key = key;
        }

        public String getName(Locale locale) {
            return Resources.getResources(locale).getString(this.key);
        }
    }
}

